/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.serialization;

import com.solace.serdes.Deserializer;
import com.solace.serdes.Serializer;
import com.solacesystems.jcsmp.BytesMessage;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.TextMessage;
import com.solacesystems.jcsmp.serialization.SDTMapAdapter;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public final class SerdeMessage {
    private SerdeMessage() {
    }

    public static <T> void serialize(Serializer<T> serializer, BytesXMLMessage message, T data) {
        Destination destination = null;
        if (message != null) {
            destination = message.getDestination();
        }
        SerdeMessage.serialize(serializer, destination, message, data);
    }

    public static <T> void serialize(Serializer<T> serializer, Destination destination, BytesXMLMessage message, T data) {
        if (serializer == null) {
            throw new IllegalArgumentException("serializer must not be null");
        }
        if (!(message instanceof BytesMessage)) {
            throw new IllegalArgumentException("message must be a " + BytesMessage.class.getName());
        }
        if (message.isReadOnly()) {
            throw new IllegalArgumentException("message can not be read only");
        }
        BytesMessage bytesMsg = (BytesMessage)message;
        SDTMap userProperties = bytesMsg.getProperties();
        if (userProperties == null) {
            userProperties = JCSMPFactory.onlyInstance().createMap();
        }
        SDTMapAdapter serializationContextHeaders = new SDTMapAdapter(userProperties);
        String destinationName = null;
        if (destination != null) {
            destinationName = destination.getName();
        }
        byte[] payload = serializer.serialize(destinationName, data, (Map)serializationContextHeaders);
        bytesMsg.setData(payload);
        if (!userProperties.isEmpty()) {
            bytesMsg.setProperties(userProperties);
        }
    }

    public static <T> T deserialize(Deserializer<T> deserializer, BytesXMLMessage message) {
        Destination destination = null;
        if (message != null) {
            destination = message.getDestination();
        }
        return SerdeMessage.deserialize(deserializer, destination, message);
    }

    public static <T> T deserialize(Deserializer<T> deserializer, Destination destination, BytesXMLMessage message) {
        if (deserializer == null) {
            throw new IllegalArgumentException("deserializer must not be null");
        }
        byte[] data = SerdeMessage.getData(message);
        SDTMap userProperties = message.getProperties();
        SDTMapAdapter deserializationContextHeaders = null;
        if (userProperties != null) {
            deserializationContextHeaders = new SDTMapAdapter(userProperties);
        }
        String destinationName = null;
        if (destination != null) {
            destinationName = destination.getName();
        }
        if (deserializationContextHeaders == null) {
            return (T)deserializer.deserialize(destinationName, data);
        }
        return (T)deserializer.deserialize(destinationName, data, (Map)deserializationContextHeaders);
    }

    private static byte[] getData(BytesXMLMessage message) {
        byte[] data = null;
        if (message instanceof BytesMessage) {
            BytesMessage bytesMsg = (BytesMessage)message;
            data = bytesMsg.getData();
        } else if (message instanceof TextMessage) {
            TextMessage textMsg = (TextMessage)message;
            String text = textMsg.getText();
            if (text != null) {
                data = text.getBytes(StandardCharsets.UTF_8);
            }
        } else {
            throw new IllegalArgumentException("Message type [" + (message != null ? message.getClass().getName() : "null") + "] is not supported must be a " + BytesMessage.class.getName() + " or " + TextMessage.class.getName());
        }
        return data;
    }
}

