/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.serialization;

import com.solace.serdes.Deserializer;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jcsmp.serialization.SerdeMessage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

class DeserializerListener<T>
implements XMLMessageListener {
    final BiConsumer<BytesXMLMessage, T> NOOP_ON_DATA = (m, d) -> {};
    static final BiConsumer<BytesXMLMessage, RuntimeException> NOOP_ON_DESERIALIZATION_EXCEPTION = (m, e) -> {};
    static final Consumer<JCSMPException> NOOP_ON_LISTENER_EXCEPTION = e -> {};
    Deserializer<T> deserializer;
    private BiConsumer<BytesXMLMessage, T> onData;
    private BiConsumer<BytesXMLMessage, RuntimeException> onDeserializationException;
    private Consumer<JCSMPException> onListenerException;

    DeserializerListener(Deserializer<T> deserializer, BiConsumer<BytesXMLMessage, T> onData, BiConsumer<BytesXMLMessage, RuntimeException> onDeserializationException, Consumer<JCSMPException> onListenerException) {
        this.setDeserializer(deserializer);
        this.setOnDataHandler(onData);
        this.setOnDeserializationExceptionHandler(onDeserializationException);
        this.setOnListenerExceptionHandler(onListenerException);
    }

    void setDeserializer(Deserializer<T> deserializer) {
        this.deserializer = deserializer;
    }

    void setOnDataHandler(BiConsumer<BytesXMLMessage, T> onData) {
        this.onData = onData == null ? this.NOOP_ON_DATA : onData;
    }

    void setOnDeserializationExceptionHandler(BiConsumer<BytesXMLMessage, RuntimeException> onDeserializationException) {
        this.onDeserializationException = onDeserializationException == null ? NOOP_ON_DESERIALIZATION_EXCEPTION : onDeserializationException;
    }

    void setOnListenerExceptionHandler(Consumer<JCSMPException> onListenerException) {
        this.onListenerException = onListenerException == null ? NOOP_ON_LISTENER_EXCEPTION : onListenerException;
    }

    @Override
    public void onReceive(BytesXMLMessage message) {
        boolean thrown = true;
        Deserializer<T> deserializer = this.deserializer;
        Object result = null;
        try {
            result = SerdeMessage.deserialize(deserializer, message);
            thrown = false;
        }
        catch (RuntimeException e) {
            this.onDeserializationException.accept(message, e);
        }
        if (!thrown) {
            this.onData.accept(message, (BytesXMLMessage)result);
        }
    }

    @Override
    public void onException(JCSMPException exception) {
        this.onListenerException.accept(exception);
    }
}

