/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf;

import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.WireMessagePool;
import com.solacesystems.jcsmp.protocol.HeaderDescriptionBean;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.WireMessageHandler;
import com.solacesystems.jcsmp.protocol.nio.impl.AbstractSMFReadHandler;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.ClientCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SmpHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.impl.AssuredCtrlHeaderDecoder;
import com.solacesystems.jcsmp.protocol.smf.impl.AssuredCtrlHeaderEncoder;
import com.solacesystems.jcsmp.protocol.smf.impl.ClientCtrlHeaderDecoder;
import com.solacesystems.jcsmp.protocol.smf.impl.ClientCtrlHeaderEncoder;
import com.solacesystems.jcsmp.protocol.smf.impl.NetworkIOUtil;
import com.solacesystems.jcsmp.protocol.smf.impl.SMFHeaderDecoder;
import com.solacesystems.jcsmp.protocol.smf.impl.SMFHeaderEncoder;
import com.solacesystems.jcsmp.protocol.smf.impl.SmpHeaderDecoder;
import com.solacesystems.jcsmp.protocol.smf.impl.SmpHeaderEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class SMFWireMessageHandler
implements WireMessageHandler {
    SMFHeaderDecoder smfDecoder = new SMFHeaderDecoder();
    SMFHeaderEncoder smfEncoder = new SMFHeaderEncoder();
    AssuredCtrlHeaderDecoder assDecoder = new AssuredCtrlHeaderDecoder();
    AssuredCtrlHeaderEncoder assEncoder = new AssuredCtrlHeaderEncoder();
    ClientCtrlHeaderDecoder clientDecoder = new ClientCtrlHeaderDecoder();
    ClientCtrlHeaderEncoder clientEncoder = new ClientCtrlHeaderEncoder();
    SmpHeaderDecoder smpDecoder = new SmpHeaderDecoder();
    SmpHeaderEncoder smpEncoder = new SmpHeaderEncoder();
    ClientCtrlHeaderBean _clientHeader = new ClientCtrlHeaderBean();
    ByteArrayOutputStream _baos = new ByteArrayOutputStream(4096);

    public void readMessage(ByteBuffer buf, WireMessage msg) throws IOException {
        try {
            msg.reset();
            SMFHeaderBean smfHeader = WireMessagePool.getInstance().getSMFHeaderBean();
            this.smfDecoder.decodeHeader(buf, (HeaderDescriptionBean)smfHeader);
            msg.setSmfHeader(smfHeader);
            this.readPayload(null, buf, msg, smfHeader);
        }
        catch (OutOfMemoryError oom) {
            throw new IOException("OutOfMemoryError parsing SMF message (message too big): " + oom.getMessage());
        }
    }

    @Override
    public void readMessage(InputStream istr, WireMessage msg) throws IOException {
        try {
            msg.reset();
            SMFHeaderBean smfHeader = WireMessagePool.getInstance().getSMFHeaderBean();
            this.smfDecoder.decodeHeader(istr, (HeaderDescriptionBean)smfHeader);
            msg.setSmfHeader(smfHeader);
            this.readPayload(istr, null, msg, smfHeader);
        }
        catch (OutOfMemoryError oom) {
            throw new IOException("OutOfMemoryError parsing SMF message (message too big): " + oom.getMessage());
        }
    }

    private static void copyBufData(InputStream istr, ByteBuffer inputBuf, byte[] outputBuf) throws IOException {
        if (istr != null) {
            NetworkIOUtil.readDataSafely(istr, outputBuf, 0, outputBuf.length);
        } else {
            inputBuf.get(outputBuf, 0, outputBuf.length);
        }
    }

    private void readPayload(InputStream istr, ByteBuffer inputBuf, WireMessage msg, SMFHeaderBean smfHeader) throws IOException {
        byte[] buf = null;
        int len = 0;
        if (smfHeader.isUnknownProtocol()) {
            len = smfHeader.getMsgLen();
            buf = new byte[len];
            SMFWireMessageHandler.copyBufData(istr, inputBuf, buf);
            msg.setPayload(buf);
            return;
        }
        switch (smfHeader.getProtocol()) {
            case 14: 
            case 20: {
                len = smfHeader.getMsgLen();
                buf = new byte[len];
                SMFWireMessageHandler.copyBufData(istr, inputBuf, buf);
                msg.setPayload(buf);
                break;
            }
            case 13: {
                len = smfHeader.getMsgLen();
                buf = new byte[len];
                SMFWireMessageHandler.copyBufData(istr, inputBuf, buf);
                msg.setPayload(buf);
                break;
            }
            case 10: 
            case 11: {
                len = smfHeader.getMsgLen();
                if (len <= 0) break;
                buf = new byte[len];
                SMFWireMessageHandler.copyBufData(istr, inputBuf, buf);
                msg.setPayload(buf);
                break;
            }
            case 9: 
            case 19: {
                if (smfHeader.getMsgLen() <= 0) break;
                AssuredCtrlHeaderBean adctrlHeader = WireMessagePool.getInstance().getAdctrlHeaderBean();
                if (istr == null) {
                    istr = AbstractSMFReadHandler.newByteBufferInputStream(inputBuf);
                }
                this.assDecoder.decodeHeader(istr, adctrlHeader);
                msg.addHeaderBean(adctrlHeader);
                break;
            }
            case 12: {
                if (smfHeader.getMsgLen() <= 0) break;
                ClientCtrlHeaderBean clientHeader = WireMessagePool.getInstance().getClientCtrlHeaderBean();
                if (istr == null) {
                    istr = AbstractSMFReadHandler.newByteBufferInputStream(inputBuf);
                }
                this.clientDecoder.decodeHeader(istr, clientHeader);
                msg.addHeaderBean(clientHeader);
                break;
            }
            case 15: {
                if (smfHeader.getMsgLen() <= 0) break;
                SmpHeaderBean smpHeader = WireMessagePool.getInstance().getSmpHeaderBean();
                if (istr == null) {
                    istr = AbstractSMFReadHandler.newByteBufferInputStream(inputBuf);
                }
                this.smpDecoder.decodeHeader(istr, smpHeader);
                msg.addHeaderBean(smpHeader);
            }
        }
    }

    private void writeData(OutputStream ostr, byte[] buf) throws IOException {
        ostr.write(buf);
    }

    @Override
    public synchronized void writeMessage(OutputStream ostr, WireMessage msg) throws IOException {
        SMFHeaderBean smfHeader = msg.getSmfHeader();
        this._baos.reset();
        switch (smfHeader.getProtocol()) {
            case 3: 
            case 10: 
            case 11: 
            case 14: {
                smfHeader.setMsgLen(msg.getPayload().length);
                this.smfEncoder.encodeHeader(this._baos, smfHeader);
                if (msg.getPayload().length <= 0) break;
                this.writeData(this._baos, msg.getPayload());
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 19: {
                HeaderDescriptionBean ctrlHeader = msg.getHeaderBean();
                smfHeader.setMsgLen(ctrlHeader.getSmfEncodedLength());
                this.smfEncoder.encodeHeader(this._baos, smfHeader);
                if (ctrlHeader instanceof AssuredCtrlHeaderBean) {
                    this.assEncoder.encodeHeader(this._baos, ctrlHeader);
                    break;
                }
                if (ctrlHeader instanceof ClientCtrlHeaderBean) {
                    this.clientEncoder.encodeHeader(this._baos, ctrlHeader);
                    break;
                }
                if (ctrlHeader instanceof SmpHeaderBean) {
                    this.smpEncoder.encodeHeader(this._baos, ctrlHeader);
                    break;
                }
                throw new IOException(JCSMPRB.BUNDLE.getStringSafely("SMFWireMessageHandler.encodingError"));
            }
        }
        this._baos.writeTo(ostr);
        ostr.flush();
    }
}

