/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.ContextImpl;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimeoutHandler;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimer;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ReconnectFreqManager
implements JCSMPTimeoutHandler {
    AtomicInteger _cnt = new AtomicInteger(0);
    FreqExceededHandler _frHandler;
    volatile JCSMPTimer _timer;
    volatile boolean _exceeded;
    final ContextImpl _context;
    static final long TIME_INTERVAL = 4000L;
    final long MAX_RECONNECTS;
    private final LogWrapper Trace = new LogWrapper(ReconnectFreqManager.class);

    public ReconnectFreqManager(Object channel, ContextImpl context) {
        this._context = context;
        if (channel instanceof TcpClientChannel) {
            this._frHandler = new ClientFreqExceededHandler((TcpClientChannel)channel);
            this.Trace.setContextInfo(((TcpClientChannel)channel).getLogContextInfo());
        }
        this._exceeded = false;
        this.MAX_RECONNECTS = JCSMPFactory.onlyInstance().getGlobalProperties().getReconnectFreqManagerMaxReconnects();
    }

    public void notifyReconnectOccurred() {
        if (this._timer == null || !this._timer.isActive()) {
            this._timer = this._context.getTimeService().schedule_relative(4000L, this);
        }
        this._cnt.incrementAndGet();
    }

    public void cancelTimer() {
        if (this._timer != null && this._timer.isActive()) {
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug("Canceling ConsumerReconnectFreqManager timer.");
            }
            this._context.getTimeService().cancelTimer(this._timer);
        }
    }

    @Override
    public void handleTimeout() {
        int periodCount;
        if (this.Trace.isDebugEnabled()) {
            this.Trace.debug("Timer expiry: checking reconnect counter.");
        }
        if ((long)(periodCount = this._cnt.getAndSet(0)) > this.MAX_RECONNECTS) {
            this.Trace.warn("Reconnect frequency exceeded, closing channel.");
            this._exceeded = true;
            this._frHandler.handleFreqExceeded();
        } else if (this.Trace.isDebugEnabled()) {
            this.Trace.debug(String.format("Reconnect frequency OK: count=%s", periodCount));
        }
    }

    public boolean hasExceededRcFreq() {
        return this._exceeded;
    }

    class ClientFreqExceededHandler
    extends FreqExceededHandler {
        TcpClientChannel _c;

        public ClientFreqExceededHandler(TcpClientChannel channel) {
            this._c = channel;
        }

        @Override
        public void handleFreqExceeded() {
            InvalidOperationException ex = new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessageConsumer.exceededAutoReconnectFreqAbortRetry"));
            if (this._c != null) {
                this._c.startFreqDisconnect(ex);
            }
        }
    }

    abstract class FreqExceededHandler {
        FreqExceededHandler() {
        }

        public abstract void handleFreqExceeded();
    }
}

