/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp;

public class EndpointProperties {
    public static final int PERMISSION_NONE = 0;
    public static final int PERMISSION_READ_ONLY = 1;
    public static final int PERMISSION_CONSUME = 2;
    public static final int PERMISSION_MODIFY_TOPIC = 3;
    public static final int PERMISSION_DELETE = 4;
    public static final int ACCESSTYPE_EXCLUSIVE = 1;
    public static final int ACCESSTYPE_NONEXCLUSIVE = 0;
    public static final int DISCARD_NOTIFY_SENDER_ON = 2;
    public static final int DISCARD_NOTIFY_SENDER_OFF = 1;
    private Integer mAccessType = null;
    private Integer mMaxMsgSize = null;
    private Integer mPermission = null;
    private Integer mQuota = null;
    private Boolean mRespectsMsgTTL = null;
    private Integer mDiscardBehavior = null;
    private Integer mMaxMsgRedelivery = null;

    public EndpointProperties() {
    }

    public EndpointProperties(Integer accessType, Integer maxMsgSize, Integer permission, Integer quota) {
        this.setAccessType(accessType);
        this.setMaxMsgSize(maxMsgSize);
        this.setPermission(permission);
        this.setQuota(quota);
    }

    public EndpointProperties(Integer accessType, Integer maxMsgSize, Integer permission, Integer quota, Boolean respectsMsgTimeToLive) {
        this.setAccessType(accessType);
        this.setMaxMsgSize(maxMsgSize);
        this.setPermission(permission);
        this.setQuota(quota);
        this.setRespectsMsgTTL(respectsMsgTimeToLive);
    }

    public EndpointProperties(Integer accessType, Integer maxMsgSize, Integer permission, Integer quota, Boolean respectsMsgTimeToLive, Integer discardBehavior) {
        this.setAccessType(accessType);
        this.setMaxMsgSize(maxMsgSize);
        this.setPermission(permission);
        this.setQuota(quota);
        this.setRespectsMsgTTL(respectsMsgTimeToLive);
        this.setDiscardBehavior(discardBehavior);
    }

    public EndpointProperties(Integer accessType, Integer maxMsgSize, Integer permission, Integer quota, Boolean respectsMsgTimeToLive, Integer discardBehavior, Integer maxMsgRedelivery) {
        this.setAccessType(accessType);
        this.setMaxMsgSize(maxMsgSize);
        this.setPermission(permission);
        this.setQuota(quota);
        this.setRespectsMsgTTL(respectsMsgTimeToLive);
        this.setDiscardBehavior(discardBehavior);
        this.setMaxMsgRedelivery(maxMsgRedelivery);
    }

    public Integer getAccessType() {
        return this.mAccessType;
    }

    public Integer getMaxMsgSize() {
        return this.mMaxMsgSize;
    }

    public Integer getPermission() {
        return this.mPermission;
    }

    public Integer getQuota() {
        return this.mQuota;
    }

    public void setAccessType(Integer accessType) {
        if (accessType != null && accessType != 1 && accessType != 0) {
            throw new IllegalArgumentException("invalid value for access type");
        }
        this.mAccessType = accessType;
    }

    public void setMaxMsgSize(Integer maxMsgSize) {
        if (maxMsgSize != null && maxMsgSize < 0) {
            throw new IllegalArgumentException("invalid value for maximum message size");
        }
        this.mMaxMsgSize = maxMsgSize;
    }

    public void setPermission(Integer permission) {
        if (permission != null && (permission < 0 || permission > 4)) {
            throw new IllegalArgumentException("invalid value for permission");
        }
        this.mPermission = permission;
    }

    public void setQuota(Integer quota) {
        if (quota != null && quota < 0) {
            throw new IllegalArgumentException("invalid value for quota");
        }
        this.mQuota = quota;
    }

    public Boolean isRespectsMsgTTL() {
        return this.mRespectsMsgTTL;
    }

    public void setRespectsMsgTTL(Boolean respectsMsgTimeToLive) {
        this.mRespectsMsgTTL = respectsMsgTimeToLive;
    }

    public void setDiscardBehavior(Integer discardBehavior) {
        if (discardBehavior != null && discardBehavior != 1 && discardBehavior != 2) {
            throw new IllegalArgumentException("Invalid value for discardBehavior.");
        }
        this.mDiscardBehavior = discardBehavior;
    }

    public Integer getDiscardBehavior() {
        return this.mDiscardBehavior;
    }

    public void setMaxMsgRedelivery(Integer maxMsgRedelivery) {
        if (maxMsgRedelivery != null && (maxMsgRedelivery < 0 || maxMsgRedelivery > 255)) {
            throw new IllegalArgumentException("Invalid value for discardBehavior.");
        }
        this.mMaxMsgRedelivery = maxMsgRedelivery;
    }

    public Integer getMaxMsgRedelivery() {
        return this.mMaxMsgRedelivery;
    }
}

