/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jcsmp.FlowReceiver;
import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jms.SolDestination;
import com.solacesystems.jms.SolMessageConsumer;
import com.solacesystems.jms.SolSessionIF;
import com.solacesystems.jms.SolTemporaryQueueIF;
import com.solacesystems.jms.SolTemporaryTopicIF;
import com.solacesystems.jms.impl.JCSMPConsumerFactory;
import com.solacesystems.jms.impl.JCSMPMessageListener;
import com.solacesystems.jms.impl.JMSState;
import com.solacesystems.jms.impl.Validator;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MessageListener;
import jakarta.jms.TopicSubscriber;

public class SolTopicSubscriber
extends SolMessageConsumer
implements TopicSubscriber {
    private final LogWrapper log = new LogWrapper(SolTopicSubscriber.class);
    protected String mName;

    SolTopicSubscriber(SolSessionIF session, jakarta.jms.Topic topic, String messageSelector, boolean noLocal, String name, JMSState state) throws JMSException {
        super(session, (Destination)topic, messageSelector, noLocal, state, name != null);
        this.mName = name;
        this.createConsumer();
        this.log.setContextInfo(this.getLogContextInfo());
        if (this.log.isDebugEnabled()) {
            this.log.debug("SolTopicSubscriber created.");
        }
    }

    @Override
    public boolean getNoLocal() throws JMSException {
        Validator.checkClosed(this.mState, "MessageConsumer");
        return this.mNoLocal;
    }

    public jakarta.jms.Topic getTopic() throws JMSException {
        Validator.checkClosed(this.mState, "MessageConsumer");
        return (jakarta.jms.Topic)this.mDestination;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Setting message listener in SolTopicSubscriber " + this.mName);
            }
            if (listener == null) {
                ((FlowReceiver)this.mConsumer).setMessageListener(null);
                this.mListener.setMessageListener(listener);
            } else {
                this.mListener.setMessageListener(listener);
                ((FlowReceiver)this.mConsumer).setMessageListener(this.mListener);
            }
            this.processDelayStart();
        }
        catch (Exception e) {
            throw Validator.createJMSException("soljms.operation.consumer.setlistener", e);
        }
    }

    @Override
    protected void createConsumer() throws JMSException {
        Topic topic = (Topic)((SolDestination)this.mDestination).getJCSMPDestination();
        boolean nonDurable = this.mName == null;
        try {
            JCSMPMessageListener listener = this.mListener.getMessageListener() == null ? null : this.mListener;
            if (nonDurable) {
                boolean direct = this.mSessionProps.getConnectionProperties().getPropertyBean().getDirectTransport();
                if (!direct && this.mEndpoint == null) {
                    this.mEndpoint = this.mSessionProps.getConnectionProperties().getJCSMPSession().createNonDurableTopicEndpoint();
                }
                this.mConsumer = this.mConsumerFac.createNonDurableConsumer(topic, (XMLMessageListener)listener, this.mEndpoint, JCSMPConsumerFactory.standard);
            } else {
                if (this.mEndpoint == null) {
                    this.mEndpoint = JCSMPFactory.onlyInstance().createDurableTopicEndpoint(this.mName);
                }
                this.mConsumer = this.mConsumerFac.createDurableConsumer(topic, (XMLMessageListener)listener, this.mEndpoint, JCSMPConsumerFactory.standard);
            }
            super.updateLogContextInfo();
            super.createConsumer();
        }
        catch (Exception e) {
            throw Validator.createJMSException("soljms.operation.consumer.create", e);
        }
    }

    @Override
    public boolean isTemporaryQueueUsed(SolTemporaryQueueIF queue) {
        return false;
    }

    @Override
    public boolean isTemporaryTopicUsed(SolTemporaryTopicIF topic) {
        if (this.mState != JMSState.Closed) {
            return topic.equals(this.mDestination);
        }
        return false;
    }
}

