/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp;

import com.solacesystems.jcsmp.JCSMPRuntime;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.JCSMPStats;
import com.solacesystems.jcsmp.statistics.StatType;

public class JCSMPSessionStats
extends JCSMPStats {
    private JCSMPStats globalStats;
    private volatile boolean publishedAD;

    public JCSMPSessionStats(JCSMPSession session) {
        super(session.getSessionName());
        this.resetStats();
        this.globalStats = JCSMPRuntime.onlyInstance();
        this.publishedAD = false;
    }

    public JCSMPSessionStats() {
        super("defaultname");
        this.resetStats();
        this.globalStats = JCSMPRuntime.onlyInstance();
    }

    @Override
    public void incStat(StatType t) {
        super.incStat(t);
        this.globalStats.incStat(t);
    }

    @Override
    public void incStat(StatType t, long v) {
        super.incStat(t, v);
        this.globalStats.incStat(t, v);
    }

    public void setPublishedAD(boolean publishedAd) {
        this.publishedAD = publishedAd;
    }

    public boolean hasPublishedAD() {
        return this.publishedAD;
    }
}

