/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp;

import com.solacesystems.common.SolReserved;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPPropertyMap;
import com.solacesystems.jcsmp.PropertyMap;
import com.solacesystems.jcsmp.impl.JCSMPPropertiesTextMarshaling;
import com.solacesystems.jcsmp.secure.SecureProperties;
import com.solacesystems.jcsmp.secure.SecureSessionProperties;
import java.io.Serializable;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class JCSMPProperties
extends JCSMPPropertyMap
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final String SUPPORTED_MESSAGE_ACK_AUTO = "auto_ack";
    public static final String SUPPORTED_MESSAGE_ACK_CLIENT = "client_ack";
    @SolReserved
    public static final String SUPPORTED_MESSAGE_ACK_CLIENT_WINDOWED = "client_ack_windowed";
    public static final String SUPPORTED_ACK_EVENT_MODE_PER_MSG = "SUPPORTED_ACK_EVENT_MODE_PER_MSG";
    public static final String SUPPORTED_ACK_EVENT_MODE_WINDOWED = "SUPPORTED_ACK_EVENT_MODE_WINDOWED";
    @Deprecated
    public static final String CLIENT_MODE = "client_mode";
    public static final String AUTHENTICATION_SCHEME_BASIC = "AUTHENTICATION_SCHEME_BASIC";
    public static final String AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE = "AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE";
    public static final String AUTHENTICATION_SCHEME_GSS_KRB = "AUTHENTICATION_SCHEME_GSS_KRB";
    public static final String AUTHENTICATION_SCHEME_OAUTH2 = "AUTHENTICATION_SCHEME_OAUTH2";
    public static final String OAUTH2_ACCESS_TOKEN = "OAUTH2_ACCESS_TOKEN";
    public static final String OAUTH2_ISSUER_IDENTIFIER = "OAUTH2_ISSUER_IDENTIFIER";
    public static final String OIDC_ID_TOKEN = "OIDC_ID_TOKEN";
    @SolReserved
    public static final String CONNECTION_TYPE_BASIC = "CONNECTION_TYPE_BASIC";
    @SolReserved
    public static final String CONNECTION_TYPE_XA = "CONNECTION_TYPE_XA";
    public static final String TRANSPORT_PROTOCOL_PLAIN_TEXT = "PLAIN_TEXT";
    public static final String HOST = "host";
    @Deprecated
    public static final String SESSION_NAME = "session_name";
    public static final String LOCALHOST = "localhost";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    @Deprecated
    public static final String SECURE_PROPS = "secure_props";
    public static final String CLIENT_CHANNEL_PROPERTIES = "client_channel";
    public static final String MESSAGE_ACK_MODE = "message_ack_mode";
    public static final String APPLICATION_DESCRIPTION = "application_description";
    public static final String CLIENT_NAME = "client_name";
    public static final String P2PINBOX_IN_USE = "p2pinbox_in_use";
    public static final String GENERATE_SENDER_ID = "generate_sender_id";
    public static final String GENERATE_SEND_TIMESTAMPS = "generate_send_timestamps";
    public static final String GENERATE_RCV_TIMESTAMPS = "generate_rcv_timestamps";
    public static final String GENERATE_SEQUENCE_NUMBERS = "generate_sequence_numbers";
    public static final String CALCULATE_MESSAGE_EXPIRATION = "calculate_message_expiration";
    public static final String VPN_NAME = "vpn_name";
    public static final String VPN_NAME_IN_USE = "vpn_name_in_use";
    public static final String REAPPLY_SUBSCRIPTIONS = "reapply_subscriptions";
    public static final String PUB_MULTI_THREAD = "pub_multi_thread";
    public static final String PUB_USE_INTERMEDIATE_DIRECT_BUF = "pub_use_intermediate_direct_buf";
    public static final String MESSAGE_CALLBACK_ON_REACTOR = "MESSAGE_CALLBACK_ON_REACTOR";
    public static final String IGNORE_DUPLICATE_SUBSCRIPTION_ERROR = "IGNORE_DUPLICATE_SUBSCRIPTION_ERROR";
    public static final String IGNORE_SUBSCRIPTION_NOT_FOUND_ERROR = "IGNORE_SUBSCRIPTION_NOT_FOUND_ERROR";
    public static final String VIRTUAL_ROUTER_NAME = "VIRTUAL_ROUTER_NAME";
    public static final String NO_LOCAL = "NO_LOCAL";
    public static final String ACK_EVENT_MODE = "ACK_EVENT_MODE";
    public static final String SSL_EXCLUDED_PROTOCOLS = "SSL_EXCLUDED_PROTOCOLS";
    public static final String SSL_VALIDATE_CERTIFICATE = "SSL_VALIDATE_CERTIFICATE";
    public static final String SSL_VALIDATE_CERTIFICATE_DATE = "SSL_VALIDATE_CERTIFICATE_DATE";
    public static final String SSL_VALIDATE_CERTIFICATE_HOST = "SSL_VALIDATE_CERTIFICATE_HOST";
    public static final String SSL_CIPHER_SUITES = "SSL_CIPHER_SUITES";
    public static final String SSL_TRUST_STORE = "SSL_TRUST_STORE";
    public static final String SSL_TRUST_STORE_PASSWORD = "SSL_TRUST_STORE_PASSWORD";
    public static final String SSL_TRUST_STORE_FORMAT = "SSL_TRUST_STORE_FORMAT";
    public static final String SSL_TRUSTED_COMMON_NAME_LIST = "SSL_TRUSTED_COMMON_NAME_LIST";
    public static final String SSL_KEY_STORE = "SSL_KEY_STORE";
    public static final String SSL_KEY_STORE_PASSWORD = "SSL_KEY_STORE_PASSWORD";
    public static final String SSL_KEY_STORE_FORMAT = "SSL_KEY_STORE_FORMAT";
    public static final String SSL_KEY_STORE_NORMALIZED_FORMAT = "SSL_KEY_STORE_NORMALIZED_FORMAT";
    public static final String SSL_PRIVATE_KEY_ALIAS = "SSL_PRIVATE_KEY_ALIAS";
    public static final String SSL_PRIVATE_KEY_PASSWORD = "SSL_PRIVATE_KEY_PASSWORD";
    public static final String SSL_IN_MEMORY_KEY_STORE = "SSL_IN_MEMORY_KEY_STORE";
    public static final String SSL_IN_MEMORY_TRUST_STORE = "SSL_IN_MEMORY_TRUST_STORE";
    public static final String KRB_SERVICE_NAME = "KRB_SERVICE_NAME";
    @Deprecated
    public static final String SUBSCRIBER_LOCAL_PRIORITY = "subscriber_local_priority";
    @Deprecated
    public static final String SUBSCRIBER_NETWORK_PRIORITY = "subscriber_network_priority";
    @Deprecated
    public static final String SSL_PROTOCOL = "SSL_PROTOCOL";
    public static final String AUTHENTICATION_SCHEME = "AUTHENTICATION_SCHEME";
    public static final String SSL_CONNECTION_DOWNGRADE_TO = "SSL_CONNECTION_DOWNGRADE_TO";
    public static final String GD_RECONNECT_FAIL_ACTION = "gd_reconnect_fail_action";
    public static final String GD_RECONNECT_FAIL_ACTION_AUTO_RETRY = "gd_reconnect_fail_action_auto_retry";
    public static final String GD_RECONNECT_FAIL_ACTION_DISCONNECT = "gd_reconnect_fail_action_disconnect";
    @SolReserved
    public static final String KRB_MUTUAL_AUTHENTICATION = "KRB_MUTUAL_AUTHENTICATION";
    @SolReserved
    public static final String P2PTOPICDESCRIPTION = "P2PTOPICDESCRIPTION";
    @SolReserved
    public static final String TOPIC_DISPATCH = "topic_dispatch";
    @SolReserved
    public static final String TOPIC_DISPATCH_OPTIMIZE_DIRECT = "topic_dispatch_optimize_direct";
    @SolReserved
    public static final String CLIENT_INFO_PROVIDER = "client_info_provider";
    @SolReserved
    public static final String AD_PUB_ROUTER_WINDOWED_ACK = "ad_pub_router_windowed_ack";
    @SolReserved
    public static final String CONNECTION_TYPE = "connection_type";
    public static final String CONTROL_CHANNEL_PROPERTIES = "control_channel";
    public static final String PUBLISHER_DATA_CHANNEL_PROPERTIES = "publisher_data_channel";
    public static final String SUBSCRIBER_DATA_CHANNEL_PROPERTIES = "subscriber_data_channel";
    private static final String CLIENT_CHANNEL_PROPERTY_PREFIX = "ClientChannelProperties_";
    private static final String CONTROL_CHANNEL_PROPERTY_PREFIX = "ControlChannelProperties_";
    private static final String PUBLISHER_DATA_CHANNEL_PROPERTY_PREFIX = "PublisherChannelProperties_";
    private static final String SUBSCRIBER_DATA_CHANNEL_PROPERTY_PREFIX = "SubscriberChannelProperties_";
    @SolReserved
    public static final String CLIENT_CHANNEL_PROPERTIES_CONNECT_TIMEOUT_IN_MILLIS = "ClientChannelProperties_ConnectTimeoutInMillis";
    @SolReserved
    public static final String CLIENT_CHANNEL_PROPERTIES_SMF_PORT = "ClientChannelProperties_SmfPort";
    @SolReserved
    public static final String CLIENT_CHANNEL_PROPERTIES_KEEP_ALIVE_INTERVAL_IN_MILLIS = "ClientChannelProperties_KeepAliveIntervalInMillis";
    @SolReserved
    public static final String CLIENT_CHANNEL_PROPERTIES_KEEP_ALIVE_LIMIT = "ClientChannelProperties_KeepAliveLimit";
    @SolReserved
    public static final String CLIENT_CHANNEL_PROPERTIES_READ_TIMEOUT_IN_MILLIS = "ClientChannelProperties_ReadTimeoutInMillis";
    @SolReserved
    public static final String CLIENT_CHANNEL_PROPERTIES_CONNECT_RETRIES = "ClientChannelProperties_ConnectRetries";
    @SolReserved
    public static final String CLIENT_CHANNEL_PROPERTIES_RECONNECT_RETRIES = "ClientChannelProperties_ReconnectRetries";
    @SolReserved
    public static final String CLIENT_CHANNEL_PROPERTIES_RECONNECT_RETRY_WAIT_IN_MILLIS = "ClientChannelProperties_ReconnectRetryWaitInMillis";
    @SolReserved
    public static final String CLIENT_CHANNEL_PROPERTIES_STACK = "ClientChannelProperties_Stack";
    @SolReserved
    public static final String CLIENT_CHANNEL_PROPERTIES_TCP_NO_DELAY = "ClientChannelProperties_TcpNoDelay";
    @SolReserved
    public static final String CLIENT_CHANNEL_PROPERTIES_SEND_BUFFER = "ClientChannelProperties_SendBuffer";
    @SolReserved
    public static final String CLIENT_CHANNEL_PROPERTIES_RECEIVE_BUFFER = "ClientChannelProperties_ReceiveBuffer";
    @SolReserved
    public static final String CLIENT_CHANNEL_PROPERTIES_COMPRESSION_LEVEL = "ClientChannelProperties_CompressionLevel";
    @SolReserved
    public static final String CLIENT_CHANNEL_PROPERTIES_CONNECT_RETRIES_PER_HOST = "ClientChannelProperties_ConnectRetriesPerHost";
    @Deprecated
    @SolReserved
    public static final String CONTROL_CHANNEL_PROPERTIES_CONNECT_TIMEOUT_IN_MILLIS = "ControlChannelProperties_ConnectTimeoutInMillis";
    @Deprecated
    @SolReserved
    public static final String CONTROL_CHANNEL_PROPERTIES_SMF_PORT = "ControlChannelProperties_SmfPort";
    @Deprecated
    @SolReserved
    public static final String CONTROL_CHANNEL_PROPERTIES_KEEP_ALIVE_INTERVAL_IN_MILLIS = "ControlChannelProperties_KeepAliveIntervalInMillis";
    @Deprecated
    @SolReserved
    public static final String CONTROL_CHANNEL_PROPERTIES_KEEP_ALIVE_LIMIT = "ControlChannelProperties_KeepAliveLimit";
    @Deprecated
    @SolReserved
    public static final String CONTROL_CHANNEL_PROPERTIES_READ_TIMEOUT_IN_MILLIS = "ControlChannelProperties_ReadTimeoutInMillis";
    @Deprecated
    @SolReserved
    public static final String CONTROL_CHANNEL_PROPERTIES_CONNECT_RETRIES = "ControlChannelProperties_ConnectRetries";
    @Deprecated
    @SolReserved
    public static final String CONTROL_CHANNEL_PROPERTIES_RECONNECT_RETRIES = "ControlChannelProperties_ReconnectRetries";
    @Deprecated
    @SolReserved
    public static final String CONTROL_CHANNEL_PROPERTIES_RECONNECT_RETRY_WAIT_IN_MILLIS = "ControlChannelProperties_ReconnectRetryWaitInMillis";
    @Deprecated
    @SolReserved
    public static final String CONTROL_CHANNEL_PROPERTIES_STACK = "ControlChannelProperties_Stack";
    @Deprecated
    @SolReserved
    public static final String CONTROL_CHANNEL_PROPERTIES_TCP_NO_DELAY = "ControlChannelProperties_TcpNoDelay";
    @Deprecated
    @SolReserved
    public static final String CONTROL_CHANNEL_PROPERTIES_SEND_BUFFER = "ControlChannelProperties_SendBuffer";
    @Deprecated
    @SolReserved
    public static final String CONTROL_CHANNEL_PROPERTIES_RECEIVE_BUFFER = "ControlChannelProperties_ReceiveBuffer";
    @Deprecated
    @SolReserved
    public static final String CONTROL_CHANNEL_PROPERTIES_COMPRESSION_LEVEL = "ControlChannelProperties_CompressionLevel";
    @Deprecated
    @SolReserved
    public static final String CONTROL_CHANNEL_PROPERTIES_CONNECT_RETRIES_PER_HOST = "ControlChannelProperties_ConnectRetriesPerHost";
    @Deprecated
    @SolReserved
    public static final String PUBLISHER_DATA_CHANNEL_PROPERTIES_CONNECT_TIMEOUT_IN_MILLIS = "PublisherChannelProperties_ConnectTimeoutInMillis";
    @Deprecated
    @SolReserved
    public static final String PUBLISHER_DATA_CHANNEL_PROPERTIES_SMF_PORT = "PublisherChannelProperties_SmfPort";
    @Deprecated
    @SolReserved
    public static final String PUBLISHER_DATA_CHANNEL_PROPERTIES_KEEP_ALIVE_INTERVAL_IN_MILLIS = "PublisherChannelProperties_KeepAliveIntervalInMillis";
    @Deprecated
    @SolReserved
    public static final String PUBLISHER_DATA_CHANNEL_PROPERTIES_KEEP_ALIVE_LIMIT = "PublisherChannelProperties_KeepAliveLimit";
    @Deprecated
    @SolReserved
    public static final String PUBLISHER_DATA_CHANNEL_PROPERTIES_READ_TIMEOUT_IN_MILLIS = "PublisherChannelProperties_ReadTimeoutInMillis";
    @Deprecated
    @SolReserved
    public static final String PUBLISHER_DATA_CHANNEL_PROPERTIES_CONNECT_RETRIES = "PublisherChannelProperties_ConnectRetries";
    @Deprecated
    @SolReserved
    public static final String PUBLISHER_DATA_CHANNEL_PROPERTIES_RECONNECT_RETRIES = "PublisherChannelProperties_ReconnectRetries";
    @Deprecated
    @SolReserved
    public static final String PUBLISHER_DATA_CHANNEL_PROPERTIES_RECONNECT_RETRY_WAIT_IN_MILLIS = "PublisherChannelProperties_ReconnectRetryWaitInMillis";
    @Deprecated
    @SolReserved
    public static final String PUBLISHER_DATA_CHANNEL_PROPERTIES_STACK = "PublisherChannelProperties_Stack";
    @Deprecated
    @SolReserved
    public static final String PUBLISHER_DATA_CHANNEL_PROPERTIES_TCP_NO_DELAY = "PublisherChannelProperties_TcpNoDelay";
    @Deprecated
    @SolReserved
    public static final String PUBLISHER_DATA_CHANNEL_PROPERTIES_SEND_BUFFER = "PublisherChannelProperties_SendBuffer";
    @Deprecated
    @SolReserved
    public static final String PUBLISHER_DATA_CHANNEL_PROPERTIES_RECEIVE_BUFFER = "PublisherChannelProperties_ReceiveBuffer";
    @Deprecated
    @SolReserved
    public static final String PUBLISHER_DATA_CHANNEL_PROPERTIES_COMPRESSION_LEVEL = "PublisherChannelProperties_CompressionLevel";
    @Deprecated
    @SolReserved
    public static final String PUBLISHER_DATA_CHANNEL_PROPERTIES_CONNECT_RETRIES_PER_HOST = "PublisherChannelProperties_ConnectRetriesPerHost";
    @Deprecated
    @SolReserved
    public static final String SUBSCRIBER_DATA_CHANNEL_PROPERTIES_CONNECT_TIMEOUT_IN_MILLIS = "SubscriberChannelProperties_ConnectTimeoutInMillis";
    @Deprecated
    @SolReserved
    public static final String SUBSCRIBER_DATA_CHANNEL_PROPERTIES_SMF_PORT = "SubscriberChannelProperties_SmfPort";
    @Deprecated
    @SolReserved
    public static final String SUBSCRIBER_DATA_CHANNEL_PROPERTIES_KEEP_ALIVE_INTERVAL_IN_MILLIS = "SubscriberChannelProperties_KeepAliveIntervalInMillis";
    @Deprecated
    @SolReserved
    public static final String SUBSCRIBER_DATA_CHANNEL_PROPERTIES_KEEP_ALIVE_LIMIT = "SubscriberChannelProperties_KeepAliveLimit";
    @Deprecated
    @SolReserved
    public static final String SUBSCRIBER_DATA_CHANNEL_PROPERTIES_READ_TIMEOUT_IN_MILLIS = "SubscriberChannelProperties_ReadTimeoutInMillis";
    @Deprecated
    @SolReserved
    public static final String SUBSCRIBER_DATA_CHANNEL_PROPERTIES_CONNECT_RETRIES = "SubscriberChannelProperties_ConnectRetries";
    @Deprecated
    @SolReserved
    public static final String SUBSCRIBER_DATA_CHANNEL_PROPERTIES_RECONNECT_RETRIES = "SubscriberChannelProperties_ReconnectRetries";
    @Deprecated
    @SolReserved
    public static final String SUBSCRIBER_DATA_CHANNEL_PROPERTIES_RECONNECT_RETRY_WAIT_IN_MILLIS = "SubscriberChannelProperties_ReconnectRetryWaitInMillis";
    @Deprecated
    @SolReserved
    public static final String SUBSCRIBER_DATA_CHANNEL_PROPERTIES_STACK = "SubscriberChannelProperties_Stack";
    @Deprecated
    @SolReserved
    public static final String SUBSCRIBER_DATA_CHANNEL_PROPERTIES_TCP_NO_DELAY = "SubscriberChannelProperties_TcpNoDelay";
    @Deprecated
    @SolReserved
    public static final String SUBSCRIBER_DATA_CHANNEL_PROPERTIES_SEND_BUFFER = "SubscriberChannelProperties_SendBuffer";
    @Deprecated
    @SolReserved
    public static final String SUBSCRIBER_DATA_CHANNEL_PROPERTIES_RECEIVE_BUFFER = "SubscriberChannelProperties_ReceiveBuffer";
    @Deprecated
    @SolReserved
    public static final String SUBSCRIBER_DATA_CHANNEL_PROPERTIES_COMPRESSION_LEVEL = "SubscriberChannelProperties_CompressionLevel";
    @Deprecated
    @SolReserved
    public static final String SUBSCRIBER_DATA_CHANNEL_PROPERTIES_CONNECT_RETRIES_PER_HOST = "SubscriberChannelProperties_ConnectRetriesPerHost";
    public static final String SUB_ACK_WINDOW_SIZE = "sub_ack_window_size";
    public static final String PUB_ACK_WINDOW_SIZE = "pub_ack_window_size";
    public static final String SUB_ACK_TIME = "sub_ack_time";
    public static final String PUB_ACK_TIME = "pub_ack_time";
    public static final String SUB_ACK_WINDOW_THRESHOLD = "sub_ack_window_threshold";
    @Deprecated
    public static final String MAX_RESENDS = "max_resends";
    @SolReserved
    public static final String LARGE_MESSAGING = "large_messaging";
    @SolReserved
    public static final String LARGE_MESSAGING_SEGMENT_SIZE = "large_message_segment_size";
    @SolReserved
    public static final String LARGE_MESSAGING_CONSUME_TIMEOUT = "large_message_consume_timeout";
    @SolReserved
    public static final String LARGE_MESSAGING_MAX_MSG_SIZE = "large_message_max_size";
    @SolReserved
    public static final String MESSAGE_CONSUMER_INTERCEPTOR_CLASS_NAME = "Message_Consume_Interceptor_Class_Name";
    @SolReserved
    public static final String MESSAGE_CONSUMER_INTERCEPTOR_CONSTRUCTOR_ARGUMENT = "Message_Consume_Interceptor_Constructor_Argument";
    public static final String MAX_AD_FLOWCTRL_RETRIES = "max_ad_flowctrl_retries";
    public static final String DEFAULT_SESSION_NAME = "JCSMPSession";
    public static final String KRB_SERVICE_DEFAULT = "solace";
    public static final String JAAS_CONFIG_FILE_RELOAD_ENABLED = "JaasConfigFileReloadEnabled";
    public static final String JAAS_LOGIN_CONTEXT = "JaasLoginContext";

    private static HashMap<String, Object> getDefaultProperties() {
        HashMap<String, Object> _defaultProperties = new HashMap<String, Object>();
        _defaultProperties.clear();
        _defaultProperties.put(SESSION_NAME, DEFAULT_SESSION_NAME);
        _defaultProperties.put(LOCALHOST, "");
        _defaultProperties.put(HOST, "");
        _defaultProperties.put(USERNAME, "");
        _defaultProperties.put(PASSWORD, "");
        _defaultProperties.put(MESSAGE_ACK_MODE, SUPPORTED_MESSAGE_ACK_AUTO);
        _defaultProperties.put(SUB_ACK_WINDOW_SIZE, 255);
        _defaultProperties.put(SUB_ACK_TIME, 1000);
        _defaultProperties.put(SUB_ACK_WINDOW_THRESHOLD, 60);
        _defaultProperties.put(PUB_ACK_WINDOW_SIZE, 1);
        _defaultProperties.put(PUB_ACK_TIME, 2000);
        _defaultProperties.put(MAX_RESENDS, 30);
        _defaultProperties.put(MAX_AD_FLOWCTRL_RETRIES, 15);
        _defaultProperties.put(CLIENT_MODE, false);
        _defaultProperties.put(APPLICATION_DESCRIPTION, "");
        _defaultProperties.put(GENERATE_SENDER_ID, Boolean.FALSE);
        _defaultProperties.put(GENERATE_SEND_TIMESTAMPS, Boolean.FALSE);
        _defaultProperties.put(GENERATE_RCV_TIMESTAMPS, Boolean.FALSE);
        _defaultProperties.put(GENERATE_SEQUENCE_NUMBERS, Boolean.FALSE);
        _defaultProperties.put(CALCULATE_MESSAGE_EXPIRATION, Boolean.FALSE);
        _defaultProperties.put(VPN_NAME, "");
        _defaultProperties.put(VPN_NAME_IN_USE, "");
        _defaultProperties.put(VIRTUAL_ROUTER_NAME, "");
        _defaultProperties.put(SUBSCRIBER_LOCAL_PRIORITY, 1);
        _defaultProperties.put(SUBSCRIBER_NETWORK_PRIORITY, 1);
        _defaultProperties.put(REAPPLY_SUBSCRIPTIONS, Boolean.FALSE);
        _defaultProperties.put(TOPIC_DISPATCH, Boolean.FALSE);
        _defaultProperties.put(TOPIC_DISPATCH_OPTIMIZE_DIRECT, Boolean.FALSE);
        _defaultProperties.put(PUB_MULTI_THREAD, Boolean.TRUE);
        _defaultProperties.put(PUB_USE_INTERMEDIATE_DIRECT_BUF, Boolean.TRUE);
        _defaultProperties.put(MESSAGE_CALLBACK_ON_REACTOR, Boolean.FALSE);
        _defaultProperties.put(IGNORE_DUPLICATE_SUBSCRIPTION_ERROR, Boolean.FALSE);
        _defaultProperties.put(IGNORE_SUBSCRIPTION_NOT_FOUND_ERROR, Boolean.FALSE);
        _defaultProperties.put(NO_LOCAL, Boolean.FALSE);
        _defaultProperties.put(AD_PUB_ROUTER_WINDOWED_ACK, Boolean.TRUE);
        _defaultProperties.put(ACK_EVENT_MODE, SUPPORTED_ACK_EVENT_MODE_PER_MSG);
        _defaultProperties.put(SSL_PROTOCOL, "SSLv3,TLSv1,TLSv1.1,TLSv1.2");
        _defaultProperties.put(SSL_EXCLUDED_PROTOCOLS, "");
        _defaultProperties.put(SSL_VALIDATE_CERTIFICATE, true);
        _defaultProperties.put(SSL_VALIDATE_CERTIFICATE_DATE, true);
        _defaultProperties.put(SSL_CIPHER_SUITES, SecureProperties.SupportedJSSECipherNamesString);
        _defaultProperties.put(SSL_TRUST_STORE, "");
        _defaultProperties.put(SSL_TRUST_STORE_FORMAT, KeyStore.getDefaultType());
        _defaultProperties.put(SSL_KEY_STORE, "");
        _defaultProperties.put(SSL_KEY_STORE_FORMAT, KeyStore.getDefaultType());
        _defaultProperties.put(SSL_KEY_STORE_NORMALIZED_FORMAT, "");
        _defaultProperties.put(SSL_TRUSTED_COMMON_NAME_LIST, "");
        _defaultProperties.put(AUTHENTICATION_SCHEME, AUTHENTICATION_SCHEME_BASIC);
        _defaultProperties.put(KRB_MUTUAL_AUTHENTICATION, Boolean.TRUE);
        _defaultProperties.put(KRB_SERVICE_NAME, KRB_SERVICE_DEFAULT);
        _defaultProperties.put(LARGE_MESSAGING, Boolean.FALSE);
        _defaultProperties.put(LARGE_MESSAGING_SEGMENT_SIZE, 0x900000);
        _defaultProperties.put(LARGE_MESSAGING_CONSUME_TIMEOUT, 100000);
        _defaultProperties.put(LARGE_MESSAGING_MAX_MSG_SIZE, 0xC800000);
        _defaultProperties.put(CONNECTION_TYPE, CONNECTION_TYPE_BASIC);
        _defaultProperties.put(SSL_CONNECTION_DOWNGRADE_TO, "");
        _defaultProperties.put(SSL_VALIDATE_CERTIFICATE_HOST, true);
        _defaultProperties.put(GD_RECONNECT_FAIL_ACTION, GD_RECONNECT_FAIL_ACTION_AUTO_RETRY);
        _defaultProperties.put(JAAS_CONFIG_FILE_RELOAD_ENABLED, Boolean.FALSE);
        _defaultProperties.put(JAAS_LOGIN_CONTEXT, "SolaceGSS");
        _defaultProperties.put(MESSAGE_CONSUMER_INTERCEPTOR_CLASS_NAME, "");
        JCSMPChannelProperties cprops = new JCSMPChannelProperties();
        cprops.setReadTimeoutInMillis(120000);
        _defaultProperties.put(CONTROL_CHANNEL_PROPERTIES, cprops);
        JCSMPChannelProperties pprops = new JCSMPChannelProperties();
        _defaultProperties.put(PUBLISHER_DATA_CHANNEL_PROPERTIES, pprops);
        JCSMPChannelProperties sprops = new JCSMPChannelProperties();
        _defaultProperties.put(SUBSCRIBER_DATA_CHANNEL_PROPERTIES, sprops);
        JCSMPChannelProperties clientprops = new JCSMPChannelProperties();
        _defaultProperties.put(CLIENT_CHANNEL_PROPERTIES, clientprops);
        return _defaultProperties;
    }

    public JCSMPProperties() {
        this(JCSMPProperties.getDefaultProperties());
    }

    protected JCSMPProperties(Map<String, Object> defaults) {
        this._properties.putAll(defaults);
        this.getSystemPropertyValues();
    }

    @SolReserved
    protected JCSMPProperties(PropertyMap defaults) {
        this(defaults.getProperties());
    }

    private void getSystemPropertyValues() {
        String loginCtxName;
        String reconnectAction;
        String envKeyStorePwd;
        String envKeyStoreNormalizedFmt;
        String envKeyStoreFmt;
        String envKeyStore;
        String envTrustStoreFmt;
        String envTrustStorePwd;
        String envTrustStore = System.getProperty("javax.net.ssl.trustStore");
        if (envTrustStore != null) {
            this._properties.put(SSL_TRUST_STORE, envTrustStore);
            this._isTrustStoreSet = true;
        }
        if ((envTrustStorePwd = System.getProperty("javax.net.ssl.trustStorePassword")) != null) {
            this._properties.put(SSL_TRUST_STORE_PASSWORD, envTrustStorePwd);
        }
        if ((envTrustStoreFmt = System.getProperty("javax.net.ssl.trustStoreType")) != null) {
            this._properties.put(SSL_TRUST_STORE_FORMAT, envTrustStoreFmt);
        }
        if ((envKeyStore = System.getProperty("javax.net.ssl.keyStore")) != null) {
            this._properties.put(SSL_KEY_STORE, envKeyStore);
        }
        if ((envKeyStoreFmt = System.getProperty("javax.net.ssl.keyStoreType")) != null) {
            this._properties.put(SSL_KEY_STORE_FORMAT, envKeyStoreFmt);
        }
        if ((envKeyStoreNormalizedFmt = System.getProperty("javax.net.ssl.keyStoreNormalizedType")) != null) {
            this._properties.put(SSL_KEY_STORE_NORMALIZED_FORMAT, envKeyStoreNormalizedFmt);
        }
        if ((envKeyStorePwd = System.getProperty("javax.net.ssl.keyStorePassword")) != null) {
            this._properties.put(SSL_KEY_STORE_PASSWORD, envKeyStorePwd);
        }
        if ((reconnectAction = System.getProperty(GD_RECONNECT_FAIL_ACTION)) != null) {
            this._properties.put(GD_RECONNECT_FAIL_ACTION, reconnectAction);
        }
        if ((loginCtxName = System.getProperty("JAAS_LOGIN_CONTEXT")) != null) {
            this._properties.put(JAAS_LOGIN_CONTEXT, loginCtxName);
        }
    }

    public JCSMPProperties(String host, int port, String username, String password, SecureSessionProperties secureProps) {
        this();
        this.setProperty(HOST, host);
        JCSMPChannelProperties channelProperties = (JCSMPChannelProperties)this.getProperty(CONTROL_CHANNEL_PROPERTIES);
        channelProperties.setSmfPort(port);
        channelProperties = (JCSMPChannelProperties)this.getProperty(PUBLISHER_DATA_CHANNEL_PROPERTIES);
        channelProperties.setSmfPort(port);
        channelProperties = (JCSMPChannelProperties)this.getProperty(SUBSCRIBER_DATA_CHANNEL_PROPERTIES);
        channelProperties.setSmfPort(port);
        channelProperties = (JCSMPChannelProperties)this.getProperty(CLIENT_CHANNEL_PROPERTIES);
        channelProperties.setSmfPort(port);
        this.setProperty(USERNAME, username);
        this.setProperty(PASSWORD, password);
    }

    public String toString() {
        Iterator iter = this._properties.keySet().iterator();
        StringBuffer result = new StringBuffer("\n");
        boolean first = true;
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (key.equals(PASSWORD) || key.equals(SSL_TRUST_STORE_PASSWORD) || key.equals(SSL_KEY_STORE_PASSWORD) || key.equals(SSL_PRIVATE_KEY_PASSWORD) || key.equals(OAUTH2_ACCESS_TOKEN) || key.equals(OIDC_ID_TOKEN) || key.equals(CONTROL_CHANNEL_PROPERTIES) || key.equals(PUBLISHER_DATA_CHANNEL_PROPERTIES) || key.equals(SUBSCRIBER_DATA_CHANNEL_PROPERTIES)) continue;
            if (first) {
                result.append(" {").append(key).append(", ").append(this._properties.get(key)).append("}");
                first = false;
                continue;
            }
            result.append(",\n ").append("{").append(key).append(", ").append(this._properties.get(key)).append(" }");
        }
        return result.toString();
    }

    public Properties toProperties() {
        return JCSMPPropertiesTextMarshaling.toProperties(this);
    }

    public static JCSMPProperties fromProperties(Properties p) {
        return JCSMPPropertiesTextMarshaling.fromProperties(p);
    }

    @Override
    public Object setProperty(String key, Object value) {
        if (key != null) {
            if (key.startsWith(CLIENT_CHANNEL_PROPERTY_PREFIX)) {
                String channelKey = key.substring(CLIENT_CHANNEL_PROPERTY_PREFIX.length());
                JCSMPChannelProperties channelProperties = (JCSMPChannelProperties)this.getProperty(CLIENT_CHANNEL_PROPERTIES);
                channelProperties.setProperty(channelKey, value);
            } else if (key.startsWith(CONTROL_CHANNEL_PROPERTY_PREFIX)) {
                String channelKey = key.substring(CONTROL_CHANNEL_PROPERTY_PREFIX.length());
                JCSMPChannelProperties channelProperties = (JCSMPChannelProperties)this.getProperty(CONTROL_CHANNEL_PROPERTIES);
                channelProperties.setProperty(channelKey, value);
            } else if (key.startsWith(PUBLISHER_DATA_CHANNEL_PROPERTY_PREFIX)) {
                String channelKey = key.substring(PUBLISHER_DATA_CHANNEL_PROPERTY_PREFIX.length());
                JCSMPChannelProperties channelProperties = (JCSMPChannelProperties)this.getProperty(PUBLISHER_DATA_CHANNEL_PROPERTIES);
                channelProperties.setProperty(channelKey, value);
            } else if (key.startsWith(SUBSCRIBER_DATA_CHANNEL_PROPERTY_PREFIX)) {
                String channelKey = key.substring(SUBSCRIBER_DATA_CHANNEL_PROPERTY_PREFIX.length());
                JCSMPChannelProperties channelProperties = (JCSMPChannelProperties)this.getProperty(SUBSCRIBER_DATA_CHANNEL_PROPERTIES);
                channelProperties.setProperty(channelKey, value);
            }
        }
        return super.setProperty(key, value);
    }
}

