/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.expect;

import com.solacesystems.common.expect.Expect;
import com.solacesystems.common.expect.ExpectConfig;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ExpectConfigMgr {
    private static HashMap<String, ExpectConfig> configMap = new HashMap();

    public static void addConfig(ExpectConfig config) {
        configMap.put(config.getName(), config);
    }

    public static ExpectConfig removeConfig(String name) {
        return configMap.remove(name);
    }

    public static void clearConfig() {
        configMap.clear();
    }

    public static ExpectConfig handleSuccess(Object ctx, int stackDepth) {
        List<ExpectConfig> expectConfigs = ExpectConfigMgr.getExpectConfigs(stackDepth + 1);
        for (ExpectConfig config : expectConfigs) {
            if (config.handleSuccess(ctx)) continue;
            return config;
        }
        return null;
    }

    public static ExpectConfig handleFailure(Object ctx, int stackDepth, Exception e) {
        List<ExpectConfig> expectConfigs = ExpectConfigMgr.getExpectConfigs(stackDepth + 1);
        for (ExpectConfig config : expectConfigs) {
            if (!config.handleFailure(ctx, e)) continue;
            return config;
        }
        return null;
    }

    public static List<ExpectConfig> getExpectConfigs(int stackDepth) {
        ArrayList<ExpectConfig> expectConfigs = new ArrayList<ExpectConfig>();
        try {
            Throwable t = new Throwable();
            t.fillInStackTrace();
            StackTraceElement[] elements = t.getStackTrace();
            Class<?> testClass = Class.forName(elements[stackDepth].getClassName());
            Method testMethod = testClass.getMethod(elements[stackDepth].getMethodName(), new Class[0]);
            ExpectConfigMgr.getExpectConfigs(testMethod.getAnnotation(Expect.class), expectConfigs);
            if (expectConfigs.size() == 0) {
                ExpectConfigMgr.getExpectConfigs(testClass.getAnnotation(Expect.class), expectConfigs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return expectConfigs;
    }

    public static void getExpectConfigs(Expect expect, List<ExpectConfig> expectConfigs) {
        String[] configStrs;
        if (expect != null && (configStrs = expect.value()) != null) {
            for (int i = 0; i < configStrs.length; ++i) {
                ExpectConfig config = configMap.get(configStrs[i]);
                if (config == null) continue;
                expectConfigs.add(config);
            }
        }
    }
}

