/*
 * Decompiled with CFR 0.152.
 */
package com.solace.serdes.version;

import com.solace.serdes.version.VersionInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

class VersionInfoImpl
implements VersionInfo {
    private static final String UNKNOWN = "--";
    private static final Attributes.Name MF_IMPLEMENTATION_VERSION = Attributes.Name.IMPLEMENTATION_VERSION;
    private static final String MF_BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String MF_SCM_REVISION = "SCM-Revision";
    private final String version;
    private final String revision;
    private final String module;

    VersionInfoImpl() {
        String[] versionInfo = VersionInfoImpl.lookupVersionInfo();
        this.version = versionInfo[0];
        this.revision = versionInfo[1];
        this.module = versionInfo[2];
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getRevision() {
        return this.revision;
    }

    @Override
    public String getModule() {
        return this.module;
    }

    static String[] lookupVersionInfo() {
        String foundVersion = UNKNOWN;
        String foundRevision = UNKNOWN;
        String foundModule = UNKNOWN;
        try {
            Class<VersionInfoImpl> clazz = VersionInfoImpl.class;
            ProtectionDomain protectionDomain = clazz.getProtectionDomain();
            if (protectionDomain == null) {
                return new String[]{foundVersion, foundRevision, foundModule};
            }
            CodeSource cs = protectionDomain.getCodeSource();
            if (cs == null) {
                return new String[]{foundVersion, foundRevision, foundModule};
            }
            URL locationUrl = cs.getLocation();
            if (locationUrl == null) {
                return new String[]{foundVersion, foundRevision, foundModule};
            }
            Manifest manifest = VersionInfoImpl.readManifest(locationUrl);
            if (manifest == null) {
                return new String[]{foundVersion, foundRevision, foundModule};
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            if (mainAttributes == null) {
                return new String[]{foundVersion, foundRevision, foundModule};
            }
            String implVersion = mainAttributes.getValue(MF_IMPLEMENTATION_VERSION);
            String scmRevision = mainAttributes.getValue(MF_SCM_REVISION);
            String bundleSymbolicName = mainAttributes.getValue(MF_BUNDLE_SYMBOLIC_NAME);
            foundVersion = implVersion != null ? implVersion : UNKNOWN;
            foundRevision = scmRevision != null ? scmRevision : UNKNOWN;
            foundModule = bundleSymbolicName != null ? bundleSymbolicName : UNKNOWN;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new String[]{foundVersion, foundRevision, foundModule};
    }

    static Manifest readManifest(URL locationUrl) {
        Manifest manifest;
        block12: {
            String urlString = locationUrl.toString();
            URL manifestUrl = null;
            if (urlString.endsWith("/")) {
                manifestUrl = new URL(locationUrl, "META-INF/MANIFEST.MF");
            } else if (urlString.endsWith(".jar")) {
                manifestUrl = new URL("jar:" + urlString + "!/META-INF/MANIFEST.MF");
            }
            if (manifestUrl == null) {
                return null;
            }
            InputStream manifestStream = manifestUrl.openStream();
            try {
                manifest = new Manifest(manifestStream);
                if (manifestStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (manifestStream != null) {
                        try {
                            manifestStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    return null;
                }
            }
            manifestStream.close();
        }
        return manifest;
    }

    public String toString() {
        return "VersionInfo[version=" + this.version + ", revision=" + this.revision + ", module=" + this.module + "]";
    }
}

