/*
 * Decompiled with CFR 0.152.
 */
package com.solace.serdes;

import com.solace.serdes.EncodingUtil;
import com.solace.serdes.Serializer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class StringSerializer
implements Serializer<String> {
    private Charset encoding = StandardCharsets.UTF_8;
    public static final String SOLACE_SERIALIZER_STRING_ENCODING = "solace.serializer.string.encoding";

    @Override
    public void configure(Map<String, ?> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties must not be null");
        }
        Object encodingValue = properties.get(SOLACE_SERIALIZER_STRING_ENCODING);
        if (encodingValue == null) {
            return;
        }
        this.encoding = EncodingUtil.getEncoding(encodingValue);
    }

    @Override
    public byte[] serialize(String destinationName, String data) {
        if (data == null) {
            return null;
        }
        return data.getBytes(this.encoding);
    }
}

