/*
 * Decompiled with CFR 0.152.
 */
package sttp.tapir.server.http4s;

import cats.Applicative;
import cats.Functor;
import cats.Monad;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.std.Queue;
import cats.effect.std.Queue$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import org.http4s.websocket.WebSocketFrame;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;
import sttp.capabilities.fs2.Fs2Streams;
import sttp.tapir.DecodeResult;
import sttp.tapir.WebSocketBodyOutput;
import sttp.tapir.model.WebSocketFrameDecodeFailure;
import sttp.ws.WebSocketFrame;
import sttp.ws.WebSocketFrame$;

public final class Http4sWebSockets$ {
    public static Http4sWebSockets$ MODULE$;

    static {
        new Http4sWebSockets$();
    }

    public <F, REQ, RESP> F pipeToBody(Function1<Stream<F, REQ>, Stream<F, RESP>> pipe, WebSocketBodyOutput<Function1<Stream<F, REQ>, Stream<F, RESP>>, REQ, RESP, ?, Fs2Streams<F>> o, GenTemporal<F, Throwable> evidence$1) {
        return (F)package.all$.MODULE$.toFunctorOps(Queue$.MODULE$.bounded(1, evidence$1), evidence$1).map((Function1 & Serializable & scala.Serializable)pongs -> (Function1 & Serializable & scala.Serializable)in -> {
            Stream stream;
            Some some;
            Tuple2 tuple2;
            Stream sttpFrames = in.map((Function1 & Serializable & scala.Serializable)f -> MODULE$.http4sFrameToFrame((org.http4s.websocket.WebSocketFrame)f));
            Stream concatenated = MODULE$.optionallyConcatenateFrames(sttpFrames, o.concatenateFragmentedFrames());
            Stream ignorePongs = MODULE$.optionallyIgnorePong(concatenated, o.ignorePong());
            Stream autoPongs = MODULE$.optionallyAutoPong(ignorePongs, (Queue)pongs, o.autoPongOnPing(), (Monad)evidence$1);
            Option option = o.autoPing();
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                FiniteDuration interval = (FiniteDuration)tuple2._1();
                WebSocketFrame.Ping frame = (WebSocketFrame.Ping)tuple2._2();
                stream = Stream$.MODULE$.awakeEvery(interval, evidence$1).map((Function1 & Serializable & scala.Serializable)x$1 -> frame);
            } else if (None$.MODULE$.equals(option)) {
                stream = Stream$.MODULE$.empty();
            } else {
                throw new MatchError((Object)option);
            }
            Stream autoPings = stream;
            return Stream.OptionStreamOps$.MODULE$.unNoneTerminate$extension(Stream$.MODULE$.OptionStreamOps(autoPongs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                WebSocketFrame webSocketFrame = x0$1;
                if (webSocketFrame instanceof WebSocketFrame.Close && !o.decodeCloseRequests()) {
                    return None$.MODULE$;
                }
                DecodeResult decodeResult = o.requests().decode((Object)webSocketFrame);
                if (decodeResult instanceof DecodeResult.Failure) {
                    DecodeResult.Failure failure = (DecodeResult.Failure)decodeResult;
                    throw new WebSocketFrameDecodeFailure(webSocketFrame, failure);
                }
                if (decodeResult instanceof DecodeResult.Value) {
                    DecodeResult.Value value = (DecodeResult.Value)decodeResult;
                    Object v = value.v();
                    return new Some(v);
                }
                throw new MatchError((Object)decodeResult);
            }))).through(pipe).map((Function1 & Serializable & scala.Serializable)h -> (WebSocketFrame)o.responses().encode(h)).mergeHaltL(Stream$.MODULE$.repeatEval(pongs.take()), (GenConcurrent)evidence$1).mergeHaltL(autoPings, (GenConcurrent)evidence$1).$plus$plus((Function0 & Serializable & scala.Serializable)() -> Stream$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WebSocketFrame.Close[]{WebSocketFrame$.MODULE$.close()}))).map((Function1 & Serializable & scala.Serializable)w -> MODULE$.frameToHttp4sFrame((WebSocketFrame)w));
        });
    }

    private WebSocketFrame http4sFrameToFrame(org.http4s.websocket.WebSocketFrame f) {
        org.http4s.websocket.WebSocketFrame webSocketFrame = f;
        if (webSocketFrame instanceof WebSocketFrame.Text) {
            WebSocketFrame.Text text2 = (WebSocketFrame.Text)webSocketFrame;
            return new WebSocketFrame.Text(text2.str(), text2.last(), (Option)None$.MODULE$);
        }
        if (webSocketFrame instanceof WebSocketFrame.Ping) {
            WebSocketFrame.Ping ping = (WebSocketFrame.Ping)webSocketFrame;
            ByteVector data = ping.data();
            return new WebSocketFrame.Ping(data.toArray());
        }
        if (webSocketFrame instanceof WebSocketFrame.Pong) {
            WebSocketFrame.Pong pong = (WebSocketFrame.Pong)webSocketFrame;
            ByteVector data = pong.data();
            return new WebSocketFrame.Pong(data.toArray());
        }
        if (webSocketFrame instanceof WebSocketFrame.Close) {
            WebSocketFrame.Close close = (WebSocketFrame.Close)webSocketFrame;
            return new WebSocketFrame.Close(close.closeCode(), "");
        }
        return new WebSocketFrame.Binary(f.data().toArray(), f.last(), (Option)None$.MODULE$);
    }

    private org.http4s.websocket.WebSocketFrame frameToHttp4sFrame(WebSocketFrame w) {
        WebSocketFrame webSocketFrame = w;
        if (webSocketFrame instanceof WebSocketFrame.Text) {
            WebSocketFrame.Text text2 = (WebSocketFrame.Text)webSocketFrame;
            String p = text2.payload();
            boolean finalFragment = text2.finalFragment();
            return WebSocketFrame.Text$.MODULE$.apply(p, finalFragment);
        }
        if (webSocketFrame instanceof WebSocketFrame.Binary) {
            WebSocketFrame.Binary binary = (WebSocketFrame.Binary)webSocketFrame;
            byte[] p = binary.payload();
            boolean finalFragment = binary.finalFragment();
            return new WebSocketFrame.Binary(ByteVector$.MODULE$.apply(p), finalFragment);
        }
        if (webSocketFrame instanceof WebSocketFrame.Ping) {
            WebSocketFrame.Ping ping = (WebSocketFrame.Ping)webSocketFrame;
            byte[] p = ping.payload();
            return new WebSocketFrame.Ping(ByteVector$.MODULE$.apply(p));
        }
        if (webSocketFrame instanceof WebSocketFrame.Pong) {
            WebSocketFrame.Pong pong = (WebSocketFrame.Pong)webSocketFrame;
            byte[] p = pong.payload();
            return new WebSocketFrame.Pong(ByteVector$.MODULE$.apply(p));
        }
        if (webSocketFrame instanceof WebSocketFrame.Close) {
            WebSocketFrame.Close close = (WebSocketFrame.Close)webSocketFrame;
            int code = close.statusCode();
            String reason = close.reasonText();
            return (org.http4s.websocket.WebSocketFrame)WebSocketFrame.Close$.MODULE$.apply(code, reason).fold((Function1 & Serializable & scala.Serializable)x$2 -> {
                throw x$2;
            }, (Function1 & Serializable & scala.Serializable)x -> (WebSocketFrame.Close)Predef$.MODULE$.identity(x));
        }
        throw new MatchError((Object)webSocketFrame);
    }

    private <F> Stream<F, WebSocketFrame> optionallyConcatenateFrames(Stream<F, WebSocketFrame> s, boolean doConcatenate) {
        if (doConcatenate) {
            return s.mapAccumulate((Object)None$.MODULE$, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Option option = (Option)tuple2._1();
                    WebSocketFrame f = (WebSocketFrame)tuple2._2();
                    if (None$.MODULE$.equals(option) && f instanceof WebSocketFrame.Ping) {
                        WebSocketFrame.Ping ping = (WebSocketFrame.Ping)f;
                        return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)ping));
                    }
                }
                if (tuple2 != null) {
                    Option option = (Option)tuple2._1();
                    WebSocketFrame f = (WebSocketFrame)tuple2._2();
                    if (None$.MODULE$.equals(option) && f instanceof WebSocketFrame.Pong) {
                        WebSocketFrame.Pong pong = (WebSocketFrame.Pong)f;
                        return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)pong));
                    }
                }
                if (tuple2 != null) {
                    Option option = (Option)tuple2._1();
                    WebSocketFrame f = (WebSocketFrame)tuple2._2();
                    if (None$.MODULE$.equals(option) && f instanceof WebSocketFrame.Close) {
                        WebSocketFrame.Close close = (WebSocketFrame.Close)f;
                        return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)close));
                    }
                }
                if (tuple2 != null) {
                    WebSocketFrame.Data data;
                    Option option = (Option)tuple2._1();
                    WebSocketFrame f = (WebSocketFrame)tuple2._2();
                    if (None$.MODULE$.equals(option) && f instanceof WebSocketFrame.Data && (data = (WebSocketFrame.Data)f).finalFragment()) {
                        return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)data));
                    }
                }
                if (tuple2 != null) {
                    Some some;
                    Either either;
                    Option option = (Option)tuple2._1();
                    WebSocketFrame f = (WebSocketFrame)tuple2._2();
                    if (option instanceof Some && (either = (Either)(some = (Some)option).value()) instanceof Left) {
                        WebSocketFrame.Binary binary;
                        Left left = (Left)either;
                        byte[] acc = (byte[])left.value();
                        if (f instanceof WebSocketFrame.Binary && (binary = (WebSocketFrame.Binary)f).finalFragment()) {
                            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)binary.copy((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(acc)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(binary.payload())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())), binary.copy$default$2(), binary.copy$default$3())));
                        }
                    }
                }
                if (tuple2 != null) {
                    Some some;
                    Either either;
                    Option option = (Option)tuple2._1();
                    WebSocketFrame f = (WebSocketFrame)tuple2._2();
                    if (option instanceof Some && (either = (Either)(some = (Some)option).value()) instanceof Left) {
                        WebSocketFrame.Binary binary;
                        Left left = (Left)either;
                        byte[] acc = (byte[])left.value();
                        if (f instanceof WebSocketFrame.Binary && !(binary = (WebSocketFrame.Binary)f).finalFragment()) {
                            return new Tuple2((Object)new Some((Object)package$.MODULE$.Left().apply(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(acc)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(binary.payload())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())))), (Object)None$.MODULE$);
                        }
                    }
                }
                if (tuple2 != null) {
                    Some some;
                    Either either;
                    Option option = (Option)tuple2._1();
                    WebSocketFrame f = (WebSocketFrame)tuple2._2();
                    if (option instanceof Some && (either = (Either)(some = (Some)option).value()) instanceof Right) {
                        WebSocketFrame.Text text2;
                        Right right = (Right)either;
                        String acc = (String)right.value();
                        if (f instanceof WebSocketFrame.Text && (text2 = (WebSocketFrame.Text)f).finalFragment()) {
                            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)text2.copy(new StringBuilder(0).append(acc).append(text2.payload()).toString(), text2.copy$default$2(), text2.copy$default$3())));
                        }
                    }
                }
                if (tuple2 != null) {
                    Some some;
                    Either either;
                    Option option = (Option)tuple2._1();
                    WebSocketFrame f = (WebSocketFrame)tuple2._2();
                    if (option instanceof Some && (either = (Either)(some = (Some)option).value()) instanceof Right) {
                        WebSocketFrame.Text text3;
                        Right right = (Right)either;
                        String acc = (String)right.value();
                        if (f instanceof WebSocketFrame.Text && !(text3 = (WebSocketFrame.Text)f).finalFragment()) {
                            return new Tuple2((Object)new Some((Object)package$.MODULE$.Right().apply((Object)new StringBuilder(0).append(acc).append(text3.payload()).toString())), (Object)None$.MODULE$);
                        }
                    }
                }
                if (tuple2 != null) {
                    Option acc = (Option)tuple2._1();
                    WebSocketFrame f = (WebSocketFrame)tuple2._2();
                    throw new IllegalStateException(new StringBuilder(60).append("Cannot accumulate web socket frames. Accumulator: ").append(acc).append(", frame: ").append(f).append(".").toString());
                }
                throw new MatchError((Object)tuple2);
            }).collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<Option<Either<byte[], String>>, Option<WebSocketFrame>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Option option;
                    A1 A1 = x1;
                    if (A1 != null && (option = (Option)A1._2()) instanceof Some) {
                        Some some = (Some)option;
                        WebSocketFrame f = (WebSocketFrame)some.value();
                        return (B1)f;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<Option<Either<byte[], String>>, Option<WebSocketFrame>> x1) {
                    Option option;
                    Tuple2<Option<Either<byte[], String>>, Option<WebSocketFrame>> tuple2 = x1;
                    return tuple2 != null && (option = (Option)tuple2._2()) instanceof Some;
                }
            });
        }
        return s;
    }

    private <F> Stream<F, WebSocketFrame> optionallyIgnorePong(Stream<F, WebSocketFrame> s, boolean doIgnore) {
        if (doIgnore) {
            return s.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Http4sWebSockets$.$anonfun$optionallyIgnorePong$1(x0$1)));
        }
        return s;
    }

    private <F> Stream<F, WebSocketFrame> optionallyAutoPong(Stream<F, WebSocketFrame> s, Queue<F, WebSocketFrame> pongs, boolean doAuto, Monad<F> evidence$2) {
        if (doAuto) {
            return s.evalMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                WebSocketFrame webSocketFrame = x0$1;
                if (webSocketFrame instanceof WebSocketFrame.Ping) {
                    WebSocketFrame.Ping ping = (WebSocketFrame.Ping)webSocketFrame;
                    byte[] payload = ping.payload();
                    return package.all$.MODULE$.toFunctorOps(pongs.offer((Object)new WebSocketFrame.Pong(payload)), (Functor)evidence$2).map((Function1 & Serializable & scala.Serializable)x$3 -> package.all$.MODULE$.none());
                }
                return ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)OptionIdOps$.MODULE$.some$extension(package.all$.MODULE$.catsSyntaxOptionId((Object)webSocketFrame))), (Applicative)evidence$2);
            }).collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Option<WebSocketFrame>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof Some) {
                        Some some = (Some)A1;
                        WebSocketFrame f = (WebSocketFrame)some.value();
                        return (B1)f;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Option<WebSocketFrame> x1) {
                    Option<WebSocketFrame> option = x1;
                    return option instanceof Some;
                }
            });
        }
        return s;
    }

    public static final /* synthetic */ boolean $anonfun$optionallyIgnorePong$1(WebSocketFrame x0$1) {
        WebSocketFrame webSocketFrame = x0$1;
        return !(webSocketFrame instanceof WebSocketFrame.Pong);
    }

    private Http4sWebSockets$() {
        MODULE$ = this;
    }
}

