/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.extensions.profiler.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.apache.maven.plugins.surefire.report.SurefireReportParser;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class LifecycleEventSpy
extends AbstractEventSpy {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static Comparator<ReportTestSuite> ELAPSED_TIME_LARGEST_FIRST = new Comparator<ReportTestSuite>(){

        @Override
        public int compare(ReportTestSuite o1, ReportTestSuite o2) {
            if (o1.getTimeElapsed() < o2.getTimeElapsed()) {
                return 1;
            }
            if (o1.getTimeElapsed() > o2.getTimeElapsed()) {
                return -1;
            }
            return 0;
        }
    };

    public LifecycleEventSpy() {
        this.logger.debug("LifeCycleProfiler ctor called.");
    }

    public void init(EventSpy.Context context) throws Exception {
        this.logger.info("Maven Test Profiler 0.1.0 started.");
    }

    public void onEvent(Object event) throws Exception {
        try {
            if (event instanceof MavenExecutionResult) {
                this.executionResultEventHandler((MavenExecutionResult)event);
            }
        }
        catch (Exception e) {
            this.logger.error("Exception", (Throwable)e);
        }
    }

    public void close() {
        this.logger.debug("Profiler: done.");
    }

    private List<ReportTestSuite> getAllTestReports(File reportDirectory) throws MavenReportException {
        SurefireReportParser report = new SurefireReportParser();
        report.setLocale(Locale.ENGLISH);
        report.setReportsDirectory(reportDirectory);
        List parseXMLReportFiles = report.parseXMLReportFiles();
        return parseXMLReportFiles;
    }

    private void executionResultEventHandler(MavenExecutionResult event) throws MavenReportException {
        ArrayList<ReportTestSuite> unitTestsResults = new ArrayList<ReportTestSuite>();
        for (MavenProject project : event.getTopologicallySortedProjects()) {
            File reportDirectory = new File(project.getBuild().getDirectory(), "surefire-reports");
            if (!reportDirectory.exists()) continue;
            unitTestsResults.addAll(this.getAllTestReports(reportDirectory));
        }
        if (!unitTestsResults.isEmpty()) {
            this.unitTestSummary(unitTestsResults);
        }
    }

    private void unitTestSummary(List<ReportTestSuite> unitTestsResults) {
        this.logger.info("UNIT TEST SUMMARY");
        this.printResult(unitTestsResults);
        this.printSummary(unitTestsResults);
        this.sortLongestTestTimeFirst(unitTestsResults);
        List<ReportTestSuite> worstUnitTests = unitTestsResults.subList(0, Math.min(unitTestsResults.size(), 5));
        this.logger.info("------------------------------------------------------------------------");
        this.logger.info("SLOWEST UNIT TEST SUMMARY");
        this.printResult(worstUnitTests);
        ArrayList testCases = new ArrayList();
        for (ReportTestSuite reportTestSuite : unitTestsResults) {
            testCases.addAll(reportTestSuite.getTestCases());
        }
        for (ReportTestCase reportTestCase : testCases) {
            if (reportTestCase.getFailure() == null || reportTestCase.getFailure().isEmpty()) continue;
            Map failure = reportTestCase.getFailure();
            String message = (String)failure.get("message");
            String type = (String)failure.get("type");
            this.logger.warn("Failed Test case: {}({})", (Object)reportTestCase.getName(), (Object)reportTestCase.getFullClassName());
            this.logger.warn("       {} {}", (Object)message, (Object)type);
        }
    }

    private void sortLongestTestTimeFirst(List<ReportTestSuite> unitTestsResults) {
        Collections.sort(unitTestsResults, ELAPSED_TIME_LARGEST_FIRST);
    }

    private void printSummary(List<ReportTestSuite> unitTestsResults) {
        SurefireReportParser report = new SurefireReportParser();
        report.setLocale(Locale.ENGLISH);
        Map summary = report.getSummary(unitTestsResults);
        this.logger.info("--------- -------- ------ ------- ----------");
        String totalTests = (String)summary.get("totalTests");
        String totalErrors = (String)summary.get("totalErrors");
        String totalSkipped = (String)summary.get("totalSkipped");
        String totalFailures = (String)summary.get("totalFailures");
        Float totalElapsedTime = Float.valueOf(Float.parseFloat((String)summary.get("totalElapsedTime")));
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%9s", totalTests));
        sb.append(" ");
        sb.append(String.format("%8s", totalFailures));
        sb.append(" ");
        sb.append(String.format("%6s", totalErrors));
        sb.append(" ");
        sb.append(String.format("%7s", totalSkipped));
        sb.append(" ");
        sb.append(String.format("%10.3f", totalElapsedTime));
        this.logger.info(sb.toString());
        this.logger.info("========= ======== ====== ======= ==========");
        this.logger.info("");
        this.logger.info("Rate: {} %", summary.get("totalPercentage"));
        Float averageTimePerTest = Float.valueOf(totalElapsedTime.floatValue() / Float.parseFloat(totalTests));
        this.logger.info("Average Time per Test: {}", (Object)String.format("%6.6f", averageTimePerTest));
    }

    private void printResult(List<ReportTestSuite> unitTestsResults) {
        this.logger.info("Tests run Failures Errors Skipped Elapsed    ClassName");
        this.logger.info("                                  Time (sec)");
        for (ReportTestSuite testSuite : unitTestsResults) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%9d", testSuite.getNumberOfTests()));
            sb.append(" ");
            sb.append(String.format("%8d", testSuite.getNumberOfFailures()));
            sb.append(" ");
            sb.append(String.format("%6d", testSuite.getNumberOfErrors()));
            sb.append(" ");
            sb.append(String.format("%7d", testSuite.getNumberOfSkipped()));
            sb.append(" ");
            sb.append(String.format("%10.3f", Float.valueOf(testSuite.getTimeElapsed())));
            sb.append(" ");
            sb.append(testSuite.getFullClassName());
            this.logger.info("{}", (Object)sb.toString());
        }
    }
}

