package com.smartystreets.api.international_street;

import com.google.api.client.util.Key;

/**
 * @see "https://smartystreets.com/docs/cloud/international-street-api#components"
 */
public class Components {
    //region [ Fields ]

    @Key("country_iso_3")
    private String countryIso3;

    @Key("super_administrative_area")
    private String superAdministrativeArea;

    @Key("administrative_area")
    private String administrativeArea;

    @Key("sub_administrative_area")
    private String subAdministrativeArea;

    @Key("dependent_locality")
    private String dependentLocality;

    @Key("dependent_locality_name")
    private String dependentLocalityName;

    @Key("double_dependent_locality")
    private String doubleDependentLocality;

    @Key("locality")
    private String locality;

    @Key("postal_code")
    private String postalCode;

    @Key("postal_code_short")
    private String postalCodeShort;

    @Key("postal_code_extra")
    private String postalCodeExtra;

    @Key("premise")
    private String premise;

    @Key("premise_extra")
    private String premiseExtra;

    @Key("premise_number")
    private String premiseNumber;

    @Key("premise_type")
    private String premiseType;

    @Key("thoroughfare")
    private String thoroughfare;

    @Key("thoroughfare_predirection")
    private String thoroughfarePredirection;

    @Key("thoroughfare_postdirection")
    private String thoroughfarePostdirection;

    @Key("thoroughfare_name")
    private String thoroughfareName;

    @Key("thoroughfare_trailing_type")
    private String thoroughfareTrailingType;

    @Key("thoroughfare_type")
    private String thoroughfareType;

    @Key("dependent_thoroughfare")
    private String dependentThoroughfare;

    @Key("dependent_thoroughfare_predirection")
    private String dependentThoroughfarePredirection;

    @Key("dependent_thoroughfare_postdirection")
    private String dependentThoroughfarePostdirection;

    @Key("dependent_thoroughfare_name")
    private String dependentThoroughfareName;

    @Key("dependent_thoroughfare_trailing_type")
    private String dependentThoroughfareTrailingType;

    @Key("dependent_thoroughfare_type")
    private String dependentThoroughfareType;

    @Key("building")
    private String building;

    @Key("building_leading_type")
    private String buildingLeadingType;

    @Key("building_name")
    private String buildingName;

    @Key("building_trailing_type")
    private String buildingTrailingType;

    @Key("sub_building_type")
    private String subBuildingType;

    @Key("sub_building_number")
    private String subBuildingNumber;

    @Key("sub_building_name")
    private String subBuildingName;

    @Key("sub_building")
    private String subBuilding;

    @Key("post_box")
    private String postBox;

    @Key("post_box_type")
    private String postBoxType;

    @Key("post_box_number")
    private String postBoxNumber;

    //endregion

    //region [ Getters ]

    public String getCountryIso3() {
        return countryIso3;
    }

    public String getSuperAdministrativeArea() {
        return superAdministrativeArea;
    }

    public String getAdministrativeArea() {
        return administrativeArea;
    }

    public String getSubAdministrativeArea() {
        return subAdministrativeArea;
    }

    public String getDependentLocality() {
        return dependentLocality;
    }

    public String getDependentLocalityName() {
        return dependentLocalityName;
    }

    public String getDoubleDependentLocality() {
        return doubleDependentLocality;
    }

    public String getLocality() {
        return locality;
    }

    public String getPostalCode() {
        return postalCode;
    }

    public String getPostalCodeShort() {
        return postalCodeShort;
    }

    public String getPostalCodeExtra() {
        return postalCodeExtra;
    }

    public String getPremise() {
        return premise;
    }

    public String getPremiseExtra() {
        return premiseExtra;
    }

    public String getPremiseNumber() {
        return premiseNumber;
    }

    public String getPremiseType() {
        return premiseType;
    }

    public String getThoroughfare() {
        return thoroughfare;
    }

    public String getThoroughfarePredirection() {
        return thoroughfarePredirection;
    }

    public String getThoroughfarePostdirection() {
        return thoroughfarePostdirection;
    }

    public String getThoroughfareName() {
        return thoroughfareName;
    }

    public String getThoroughfareTrailingType() {
        return thoroughfareTrailingType;
    }

    public String getThoroughfareType() {
        return thoroughfareType;
    }

    public String getDependentThoroughfare() {
        return dependentThoroughfare;
    }

    public String getDependentThoroughfarePredirection() {
        return dependentThoroughfarePredirection;
    }

    public String getDependentThoroughfarePostdirection() {
        return dependentThoroughfarePostdirection;
    }

    public String getDependentThoroughfareName() {
        return dependentThoroughfareName;
    }

    public String getDependentThoroughfareTrailingType() {
        return dependentThoroughfareTrailingType;
    }

    public String getDependentThoroughfareType() {
        return dependentThoroughfareType;
    }

    public String getBuilding() {
        return building;
    }

    public String getBuildingLeadingType() {
        return buildingLeadingType;
    }

    public String getBuildingName() {
        return buildingName;
    }

    public String getBuildingTrailingType() {
        return buildingTrailingType;
    }

    public String getSubBuildingType() {
        return subBuildingType;
    }

    public String getSubBuildingNumber() {
        return subBuildingNumber;
    }

    public String getSubBuildingName() {
        return subBuildingName;
    }

    public String getSubBuilding() {
        return subBuilding;
    }

    public String getPostBox() {
        return postBox;
    }

    public String getPostBoxType() {
        return postBoxType;
    }

    public String getPostBoxNumber() {
        return postBoxNumber;
    }

    //endregion
}
