/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc;

import com.singlestore.jdbc.BasePreparedStatement;
import com.singlestore.jdbc.Connection;
import com.singlestore.jdbc.ParameterMetaData;
import com.singlestore.jdbc.client.Completion;
import com.singlestore.jdbc.client.result.CompleteResult;
import com.singlestore.jdbc.client.result.Result;
import com.singlestore.jdbc.client.result.ResultSetMetaData;
import com.singlestore.jdbc.client.util.Parameters;
import com.singlestore.jdbc.export.ExceptionFactory;
import com.singlestore.jdbc.message.ClientMessage;
import com.singlestore.jdbc.message.client.PreparePacket;
import com.singlestore.jdbc.message.client.QueryWithParametersPacket;
import com.singlestore.jdbc.message.server.ColumnDefinitionPacket;
import com.singlestore.jdbc.message.server.OkPacket;
import com.singlestore.jdbc.util.ClientParser;
import com.singlestore.jdbc.util.ParameterList;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;

public class ClientPreparedStatement
extends BasePreparedStatement {
    private final ClientParser parser;
    public static final Pattern INSERT_STATEMENT_PATTERN = Pattern.compile("^(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*(INSERT)", 2);
    public static final Pattern INSERT_ON_DUPLICATE_KEY_UPDATE_STATEMENT_PATTERN = Pattern.compile("^.+[^`](ON)\\s.*(DUPLICATE)\\s.*(KEY)\\s.*(UPDATE)[^`].+", 2);

    public ClientPreparedStatement(String sql, Connection con, ReentrantLock lock, boolean canUseServerTimeout, boolean canUseServerMaxRows, int autoGeneratedKeys, int resultSetType, int resultSetConcurrency, int defaultFetchSize) throws SQLException {
        super(sql, con, lock, canUseServerTimeout, canUseServerMaxRows, autoGeneratedKeys, resultSetType, resultSetConcurrency, defaultFetchSize);
        this.parser = ClientParser.parameterParts(sql, this.isNoBackslashEscapesApplied());
        this.parameters = new ParameterList(this.parser.getParamCount());
    }

    protected String preSqlCmd() {
        if (this.queryTimeout != 0 && this.canUseServerTimeout) {
            return "SET STATEMENT max_statement_time=" + this.queryTimeout + " FOR ";
        }
        return null;
    }

    private void executeInternal() throws SQLException {
        this.checkNotClosed();
        this.validParameters();
        this.lock.lock();
        try {
            QueryWithParametersPacket query = new QueryWithParametersPacket(this.preSqlCmd(), this.parser, this.parameters, this.localInfileInputStream);
            this.results = this.con.getClient().execute(query, this, this.fetchSize, this.maxRows, this.resultSetConcurrency, this.resultSetType, this.closeOnCompletion, false);
        }
        finally {
            this.localInfileInputStream = null;
            this.lock.unlock();
        }
    }

    private boolean isRewriteBatchedApplicable(String sql) {
        return INSERT_STATEMENT_PATTERN.matcher(sql).find() && !INSERT_ON_DUPLICATE_KEY_UPDATE_STATEMENT_PATTERN.matcher(sql).find();
    }

    private void executeInternalPreparedBatch() throws SQLException {
        this.checkNotClosed();
        if (this.con.getContext().getConf().rewriteBatchedStatements() && this.isRewriteBatchedApplicable(this.sql) && this.autoGeneratedKeys != 1) {
            this.executeBatchWithInsertRewrite();
        } else {
            this.executeBatchPipeline();
        }
    }

    private void executeBatchWithInsertRewrite() throws SQLException {
        try {
            this.results = this.con.getClient().executePipeline(this.getClientMessageForRewriteBatchedStatement(), this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion, false);
        }
        catch (SQLException bue) {
            this.results = null;
            throw bue;
        }
    }

    private ClientMessage[] getClientMessageForRewriteBatchedStatement() {
        ParameterList parameterList = new ParameterList();
        StringBuilder builder = new StringBuilder(this.parser.getSql());
        int index = 0;
        for (int batchCount = 0; batchCount < this.batchParameters.size(); ++batchCount) {
            if (batchCount != 0) {
                builder.append(",(");
            }
            for (int paramCount = 0; paramCount < this.parser.getParamCount(); ++paramCount) {
                if (batchCount != 0) {
                    builder.append("?");
                    if (paramCount != this.parser.getParamCount() - 1) {
                        builder.append(",");
                    } else {
                        builder.append(")");
                    }
                }
                parameterList.set(index++, ((Parameters)this.batchParameters.get(batchCount)).get(paramCount));
            }
        }
        ClientParser parserWithRewriteBatchedStatement = ClientParser.parameterParts(builder.toString(), this.isNoBackslashEscapesApplied());
        return new ClientMessage[]{new QueryWithParametersPacket(this.preSqlCmd(), parserWithRewriteBatchedStatement, parameterList, null)};
    }

    private boolean isNoBackslashEscapesApplied() {
        return (this.con.getContext().getServerStatus() & 0x200) > 0;
    }

    private void executeBatchPipeline() throws SQLException {
        ClientMessage[] packets = new ClientMessage[this.batchParameters.size()];
        for (int i = 0; i < this.batchParameters.size(); ++i) {
            packets[i] = new QueryWithParametersPacket(this.preSqlCmd(), this.parser, (Parameters)this.batchParameters.get(i), null);
        }
        try {
            this.results = this.con.getClient().executePipeline(packets, this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion, false);
        }
        catch (SQLException bue) {
            this.results = null;
            throw bue;
        }
    }

    private void executeBatchStd() throws SQLException {
        try {
            this.results = new ArrayList();
            for (int i = 0; i < this.batchParameters.size(); ++i) {
                this.results.addAll(this.con.getClient().execute(new QueryWithParametersPacket(this.preSqlCmd(), this.parser, (Parameters)this.batchParameters.get(i), this.localInfileInputStream), this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion, false));
            }
        }
        catch (SQLException bue) {
            BatchUpdateException exception = this.exceptionFactory().createBatchUpdate(this.results, this.batchParameters.size(), bue);
            this.results = null;
            throw exception;
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.executeInternal();
        this.currResult = (Completion)this.results.remove(0);
        return this.currResult instanceof Result;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeInternal();
        this.currResult = (Completion)this.results.remove(0);
        if (this.currResult instanceof Result) {
            return (Result)this.currResult;
        }
        return new CompleteResult(new ColumnDefinitionPacket[0], new byte[0][], this.con.getContext());
    }

    private ExceptionFactory exceptionFactory() {
        return this.con.getExceptionFactory().of(this);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return (int)this.executeLargeUpdate();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.executeInternal();
        this.currResult = (Completion)this.results.remove(0);
        if (this.currResult instanceof Result) {
            throw this.exceptionFactory().create("the given SQL statement produces an unexpected ResultSet object", "HY000");
        }
        return ((OkPacket)this.currResult).getAffectedRows();
    }

    @Override
    public void addBatch() throws SQLException {
        this.validParameters();
        if (this.batchParameters == null) {
            this.batchParameters = new ArrayList();
        }
        this.batchParameters.add(this.parameters);
        this.parameters = this.parameters.clone();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batchParameters == null) {
            this.batchParameters = new ArrayList();
        } else {
            this.batchParameters.clear();
        }
    }

    protected void validParameters() throws SQLException {
        for (int i = 0; i < this.parser.getParamCount(); ++i) {
            if (this.parameters.containsKey(i)) continue;
            throw this.exceptionFactory().create("Parameter at position " + (i + 1) + " is not set", "07004");
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        super.setQueryTimeout(seconds);
        if (this.canUseServerTimeout && this.prepareResult != null) {
            this.prepareResult.close(this.con.getClient());
            this.prepareResult = null;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        super.setMaxRows(max);
        if (this.canUseServerMaxRows && this.prepareResult != null) {
            this.prepareResult.close(this.con.getClient());
            this.prepareResult = null;
        }
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        super.setLargeMaxRows(max);
        if (this.canUseServerMaxRows && this.prepareResult != null) {
            this.prepareResult.close(this.con.getClient());
            this.prepareResult = null;
        }
    }

    @Override
    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        if (this.prepareResult == null) {
            this.con.getClient().execute(new PreparePacket(this.escapeTimeout(this.sql)), this, true);
        }
        return new ResultSetMetaData(this.exceptionFactory(), this.prepareResult.getColumns(), this.con.getContext().getConf(), false);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.prepareResult == null) {
            this.con.getClient().execute(new PreparePacket(this.escapeTimeout(this.sql)), this, true);
        }
        return new ParameterMetaData(this.exceptionFactory(), this.prepareResult.getParameters());
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batchParameters == null || this.batchParameters.isEmpty()) {
            return new int[0];
        }
        this.lock.lock();
        try {
            this.executeInternalPreparedBatch();
            int[] updates = new int[this.results.size()];
            for (int i = 0; i < this.results.size(); ++i) {
                updates[i] = this.results.get(i) instanceof OkPacket ? (int)((OkPacket)this.results.get(i)).getAffectedRows() : -2;
            }
            this.currResult = (Completion)this.results.remove(0);
            int[] nArray = updates;
            return nArray;
        }
        finally {
            this.batchParameters.clear();
            this.lock.unlock();
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batchParameters == null || this.batchParameters.isEmpty()) {
            return new long[0];
        }
        this.lock.lock();
        try {
            this.executeInternalPreparedBatch();
            long[] updates = new long[this.results.size()];
            for (int i = 0; i < this.results.size(); ++i) {
                updates[i] = ((OkPacket)this.results.get(i)).getAffectedRows();
            }
            this.currResult = (Completion)this.results.remove(0);
            long[] lArray = updates;
            return lArray;
        }
        finally {
            this.batchParameters.clear();
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.prepareResult != null) {
            this.prepareResult.close(this.con.getClient());
        }
        this.con.fireStatementClosed(this);
        super.close();
    }

    public ClientParser test_getParser() {
        return this.parser;
    }

    @Override
    public String toString() {
        return "ClientPreparedStatement{" + super.toString() + '}';
    }
}

