/*
 * Decompiled with CFR 0.152.
 */
package com.signaturit.api.java_sdk;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestHelper {
    public static final String USER_AGENT = "signaturit-java-sdk 1.0.1";

    protected static String putGetParamsToUrl(String route, Map<String, Object> parameters) {
        if (parameters != null) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                StringBuilder routeBuilder = new StringBuilder();
                if (entry.getKey().equals("ids")) {
                    String delim = "";
                    for (CharSequence i : (CharSequence[])entry.getValue()) {
                        routeBuilder.append(delim).append(i);
                        delim = ",";
                    }
                }
                route = route + String.format("&%s=%s", entry.getKey(), routeBuilder.toString());
            }
        }
        return route;
    }

    protected static void parseParameters(MultipartBody.Builder bodyBuilder, Object recipients, String key) {
        block10: {
            block13: {
                block12: {
                    block11: {
                        block9: {
                            if (!(recipients instanceof String)) break block9;
                            bodyBuilder.addFormDataPart(key, recipients.toString());
                            break block10;
                        }
                        if (!(recipients instanceof int[])) break block11;
                        int[] listArray = (int[])recipients;
                        int i = 0;
                        int[] nArray = listArray;
                        int n = nArray.length;
                        for (int j = 0; j < n; ++j) {
                            Integer item = nArray[j];
                            bodyBuilder.addFormDataPart(key + "[" + i + "]", ((Object)item).toString());
                            ++i;
                        }
                        break block10;
                    }
                    if (!(recipients instanceof String[])) break block12;
                    String[] listArray = (String[])recipients;
                    int i = 0;
                    for (String item : listArray) {
                        bodyBuilder.addFormDataPart(key + "[" + i + "]", item.toString());
                        ++i;
                    }
                    break block10;
                }
                if (!(recipients instanceof ArrayList)) break block13;
                int i = 0;
                for (HashMap recipient : (ArrayList)recipients) {
                    for (Map.Entry entry : recipient.entrySet()) {
                        if (entry.getValue() instanceof ArrayList || entry.getValue() instanceof HashMap) {
                            RequestHelper.parseParameters(bodyBuilder, entry.getValue(), key + "[" + i + "][" + (String)entry.getKey() + "]");
                            continue;
                        }
                        if (entry.getValue() instanceof HashMap) {
                            RequestHelper.parseParameters(bodyBuilder, entry.getValue(), key + "[" + i + "][" + (String)entry.getKey() + "]");
                            continue;
                        }
                        RequestHelper.parseParameters(bodyBuilder, entry.getValue(), key + "[" + (String)entry.getKey() + "]");
                    }
                    ++i;
                }
                break block10;
            }
            if (!(recipients instanceof HashMap)) break block10;
            for (Map.Entry entry : ((Map)recipients).entrySet()) {
                if (entry.getValue() instanceof ArrayList || entry.getValue() instanceof HashMap) {
                    RequestHelper.parseParameters(bodyBuilder, entry.getValue(), key + "[" + (String)entry.getKey() + "]");
                    continue;
                }
                if (entry.getValue() instanceof HashMap) {
                    RequestHelper.parseParameters(bodyBuilder, entry.getValue(), key + "[" + (String)entry.getKey() + "]");
                    continue;
                }
                RequestHelper.parseParameters(bodyBuilder, entry.getValue(), key + "[" + (String)entry.getKey() + "]");
            }
        }
    }

    protected static Response requestPost(String route, String token, Map<String, Object> parameters, ArrayList<String> files) throws IOException {
        OkHttpClient client = new OkHttpClient();
        MultipartBody.Builder requestPostBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            RequestHelper.parseParameters(requestPostBuilder, entry.getValue(), entry.getKey());
        }
        if (files != null) {
            int i = 0;
            for (String temp : files) {
                File file = new File(temp);
                requestPostBuilder.addFormDataPart("files[" + i + "]", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (File)file));
                ++i;
            }
        }
        MultipartBody requestBody = requestPostBuilder.build();
        Request request = new Request.Builder().post((RequestBody)requestBody).addHeader("Authorization", token).addHeader("user-agent", USER_AGENT).url(route).build();
        Response response = client.newCall(request).execute();
        return response;
    }

    protected static Response requestGet(String route, String token) throws IOException {
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().get().addHeader("Authorization", token).addHeader("user-agent", USER_AGENT).url(route).build();
        Response response = client.newCall(request).execute();
        return response;
    }

    protected static InputStream requestGetFile(String route, String token) throws IOException {
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().get().addHeader("Authorization", token).addHeader("user-agent", USER_AGENT).url(route).build();
        Response response = client.newCall(request).execute();
        return response.body().byteStream();
    }

    protected static Response requestPatch(String route, String token, HashMap<String, Object> parameters) throws IOException {
        OkHttpClient client = new OkHttpClient();
        MultipartBody.Builder requestPostBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            RequestHelper.parseParameters(requestPostBuilder, entry.getValue(), entry.getKey());
        }
        MultipartBody requestBody = requestPostBuilder.build();
        Request request = new Request.Builder().post((RequestBody)requestBody).addHeader("Authorization", token).addHeader("user-agent", USER_AGENT).url(route).build();
        Response response = client.newCall(request).execute();
        return response;
    }
}

