/*
 * Decompiled with CFR 0.152.
 */
package com.signaturit.api.java_sdk;

import com.signaturit.api.java_sdk.RequestHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client {
    public static final String PROD_BASE_URL = "https://api.signaturit.com";
    public static final String SANDBOX_BASE_URL = "https://api.sandbox.signaturit.com";
    public static final String API_VERSION = "/v3/";
    private String accessToken;
    private String url;

    public Client(String accesToken, boolean production) {
        this.accessToken = "Bearer " + accesToken;
        this.url = production ? PROD_BASE_URL : SANDBOX_BASE_URL;
        this.url = this.url + API_VERSION;
    }

    public Client(String accesToken) {
        this.accessToken = "Bearer " + accesToken;
        this.url = SANDBOX_BASE_URL;
        this.url = this.url + API_VERSION;
    }

    public Response countSignatures() throws IOException {
        String route = "signatures/count.json";
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }

    public Response countSignatures(Map<String, Object> parameters) throws IOException {
        String route = RequestHelper.putGetParamsToUrl("signatures/count.json?", parameters);
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }

    public Response getSignature(String signatureId) throws IOException {
        String route = String.format("signatures/%s.json", signatureId);
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }

    public Response getSignatures() throws IOException {
        String route = "signatures.json";
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }

    public Response getSignatures(int limit) throws IOException {
        String route = String.format("signatures.json?limit=%d", limit);
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }

    public Response getSignatures(int limit, int offset) throws IOException {
        String route = String.format("signatures.json?limit=%doffset=%d", limit, offset);
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }

    public Response getSignatures(Map<String, Object> parameters) throws IOException {
        String route = "signatures.json?";
        route = RequestHelper.putGetParamsToUrl(route, parameters);
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }

    public Response getSignatures(int limit, int offset, Map<String, Object> parameters) throws IOException {
        String route = String.format("signatures.json?limit=%doffset=%d", limit, offset);
        route = RequestHelper.putGetParamsToUrl(route, parameters);
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }

    public Response downloadAuditTrail(String signatureId, String documentId) throws IOException {
        String route = String.format("signatures/%s/documents/%s/download/audit_trail", signatureId, documentId);
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }

    public Response downloadSignedDocument(String signatureId, String documentId) throws IOException {
        String route = String.format("signatures/%s/documents/%s/download/signed", signatureId, documentId);
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }

    public Response createSignature(ArrayList<String> files, ArrayList<HashMap<String, Object>> recipients) throws IOException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        return this.createSignature(files, recipients, parameters);
    }

    public Response createSignature(ArrayList<String> files, ArrayList<HashMap<String, Object>> recipients, Map<String, Object> parameters) throws IOException {
        String route = "signatures.json";
        parameters.put("recipients", recipients);
        return RequestHelper.requestPost(this.url + route, this.accessToken, parameters, files);
    }

    public Response cancelSignature(String signatureId) throws IOException {
        String route = String.format("signatures/%s/cancel.json", signatureId);
        return RequestHelper.requestPatch(this.url + route, this.accessToken, null);
    }

    public Response sendSignatureReminder(String signatureId) throws IOException {
        String route = String.format("signatures/%s/reminder.json", signatureId);
        return RequestHelper.requestPost(this.url + route, this.accessToken, null, null);
    }

    public Response getBranding(String brandingId) throws IOException {
        String route = String.format("brandings/%s.json", brandingId);
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }

    public Response getBrandings() throws IOException {
        String route = "brandings.json";
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }

    public Response createBranding(HashMap<String, Object> parameters) throws IOException {
        String route = "brandings.json";
        return RequestHelper.requestPost(this.url + route, this.accessToken, parameters, null);
    }

    public Response updateBranding(String brandingId, HashMap<String, Object> parameters) throws IOException {
        String route = String.format("brandings/%s.json", brandingId);
        return RequestHelper.requestPatch(this.url + route, this.accessToken, parameters);
    }

    public Response getTemplates() throws IOException {
        String route = String.format("templates.json", new Object[0]);
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }

    public Response getEmails() throws IOException {
        String route = "emails.json";
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }

    public Response getEmails(int limit) throws IOException {
        String route = String.format("emails.json?limit=%d", limit);
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }

    public Response getEmails(int limit, int offset) throws IOException {
        String route = String.format("emails.json?limit=%doffset=%d", limit, offset);
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }

    public Response getEmails(Map<String, Object> parameters) throws IOException {
        String route = "emails.json?";
        route = RequestHelper.putGetParamsToUrl(route, parameters);
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }

    public Response getEmails(int limit, int offset, Map<String, Object> parameters) throws IOException {
        String route = String.format("emails.json?limit=%doffset=%d", limit, offset);
        route = RequestHelper.putGetParamsToUrl(route, parameters);
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }

    public Response countEmails() throws IOException {
        String route = "emails/count.json";
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }

    public Response countEmails(Map<String, Object> parameters) throws IOException {
        String route = "emails/count.json?";
        route = RequestHelper.putGetParamsToUrl(route, parameters);
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }

    public Response getEmail(String emailId) throws IOException {
        String route = String.format("emails/%s.json", emailId);
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }

    public Response createEmail(ArrayList<String> files, ArrayList<HashMap<String, Object>> recipients) throws IOException {
        String route = "emails.json";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("recipients", recipients);
        return RequestHelper.requestPost(this.url + route, this.accessToken, parameters, files);
    }

    public Response createEmail(ArrayList<String> files, ArrayList<HashMap<String, Object>> recipients, String subject, String body) throws IOException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        return this.createEmail(files, recipients, subject, body, parameters);
    }

    public Response createEmail(ArrayList<String> files, ArrayList<HashMap<String, Object>> recipients, HashMap<String, Object> parameters) throws IOException {
        String route = "emails.json";
        if (parameters == null) {
            parameters = new HashMap();
        }
        parameters.put("recipients", recipients);
        return RequestHelper.requestPost(this.url + route, this.accessToken, parameters, files);
    }

    public Response createEmail(ArrayList<String> files, ArrayList<HashMap<String, Object>> recipients, String subject, String body, HashMap<String, Object> parameters) throws IOException {
        String route = "emails.json";
        if (parameters == null) {
            parameters = new HashMap();
        }
        parameters.put("body", body);
        parameters.put("subject", subject);
        parameters.put("recipients", recipients);
        return RequestHelper.requestPost(this.url + route, this.accessToken, parameters, files);
    }

    public Response downloadEmailAuditTrail(String emailId, String certificateId) throws IOException {
        String route = String.format("emails/%s/certificates/%s/download/audit_trail", emailId, certificateId);
        return RequestHelper.requestGet(this.url + route, this.accessToken);
    }
}

