/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.visitor;

import com.shapesecurity.shift.ast.Block;
import com.shapesecurity.shift.ast.CatchClause;
import com.shapesecurity.shift.ast.Directive;
import com.shapesecurity.shift.ast.Expression;
import com.shapesecurity.shift.ast.FunctionBody;
import com.shapesecurity.shift.ast.Identifier;
import com.shapesecurity.shift.ast.Script;
import com.shapesecurity.shift.ast.Statement;
import com.shapesecurity.shift.ast.SwitchCase;
import com.shapesecurity.shift.ast.SwitchDefault;
import com.shapesecurity.shift.ast.VariableDeclaration;
import com.shapesecurity.shift.ast.VariableDeclarator;
import com.shapesecurity.shift.ast.directive.UnknownDirective;
import com.shapesecurity.shift.ast.directive.UseStrictDirective;
import com.shapesecurity.shift.ast.expression.ArrayExpression;
import com.shapesecurity.shift.ast.expression.AssignmentExpression;
import com.shapesecurity.shift.ast.expression.BinaryExpression;
import com.shapesecurity.shift.ast.expression.CallExpression;
import com.shapesecurity.shift.ast.expression.ComputedMemberExpression;
import com.shapesecurity.shift.ast.expression.ConditionalExpression;
import com.shapesecurity.shift.ast.expression.FunctionExpression;
import com.shapesecurity.shift.ast.expression.IdentifierExpression;
import com.shapesecurity.shift.ast.expression.LiteralBooleanExpression;
import com.shapesecurity.shift.ast.expression.LiteralInfinityExpression;
import com.shapesecurity.shift.ast.expression.LiteralNullExpression;
import com.shapesecurity.shift.ast.expression.LiteralNumericExpression;
import com.shapesecurity.shift.ast.expression.LiteralRegExpExpression;
import com.shapesecurity.shift.ast.expression.LiteralStringExpression;
import com.shapesecurity.shift.ast.expression.NewExpression;
import com.shapesecurity.shift.ast.expression.ObjectExpression;
import com.shapesecurity.shift.ast.expression.PostfixExpression;
import com.shapesecurity.shift.ast.expression.PrefixExpression;
import com.shapesecurity.shift.ast.expression.StaticMemberExpression;
import com.shapesecurity.shift.ast.expression.ThisExpression;
import com.shapesecurity.shift.ast.property.DataProperty;
import com.shapesecurity.shift.ast.property.Getter;
import com.shapesecurity.shift.ast.property.ObjectProperty;
import com.shapesecurity.shift.ast.property.PropertyName;
import com.shapesecurity.shift.ast.property.Setter;
import com.shapesecurity.shift.ast.statement.BlockStatement;
import com.shapesecurity.shift.ast.statement.BreakStatement;
import com.shapesecurity.shift.ast.statement.ContinueStatement;
import com.shapesecurity.shift.ast.statement.DebuggerStatement;
import com.shapesecurity.shift.ast.statement.DoWhileStatement;
import com.shapesecurity.shift.ast.statement.EmptyStatement;
import com.shapesecurity.shift.ast.statement.ExpressionStatement;
import com.shapesecurity.shift.ast.statement.ForInStatement;
import com.shapesecurity.shift.ast.statement.ForStatement;
import com.shapesecurity.shift.ast.statement.FunctionDeclaration;
import com.shapesecurity.shift.ast.statement.IfStatement;
import com.shapesecurity.shift.ast.statement.LabeledStatement;
import com.shapesecurity.shift.ast.statement.ReturnStatement;
import com.shapesecurity.shift.ast.statement.SwitchStatement;
import com.shapesecurity.shift.ast.statement.SwitchStatementWithDefault;
import com.shapesecurity.shift.ast.statement.ThrowStatement;
import com.shapesecurity.shift.ast.statement.TryCatchStatement;
import com.shapesecurity.shift.ast.statement.TryFinallyStatement;
import com.shapesecurity.shift.ast.statement.VariableDeclarationStatement;
import com.shapesecurity.shift.ast.statement.WhileStatement;
import com.shapesecurity.shift.ast.statement.WithStatement;
import org.jetbrains.annotations.NotNull;

public interface TransformerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> {
    @NotNull
    default public StatementState transform(@NotNull Statement node) {
        switch (node.type()) {
            case BlockStatement: {
                return this.transform((BlockStatement)node);
            }
            case BreakStatement: {
                return this.transform((BreakStatement)node);
            }
            case ContinueStatement: {
                return this.transform((ContinueStatement)node);
            }
            case DebuggerStatement: {
                return this.transform((DebuggerStatement)node);
            }
            case DoWhileStatement: {
                return this.transform((DoWhileStatement)node);
            }
            case EmptyStatement: {
                return this.transform((EmptyStatement)node);
            }
            case ExpressionStatement: {
                return this.transform((ExpressionStatement)node);
            }
            case ForInStatement: {
                return this.transform((ForInStatement)node);
            }
            case ForStatement: {
                return this.transform((ForStatement)node);
            }
            case IfStatement: {
                return this.transform((IfStatement)node);
            }
            case LabeledStatement: {
                return this.transform((LabeledStatement)node);
            }
            case ReturnStatement: {
                return this.transform((ReturnStatement)node);
            }
            case SwitchStatement: {
                return this.transform((SwitchStatement)node);
            }
            case SwitchStatementWithDefault: {
                return this.transform((SwitchStatementWithDefault)node);
            }
            case ThrowStatement: {
                return this.transform((ThrowStatement)node);
            }
            case TryCatchStatement: {
                return this.transform((TryCatchStatement)node);
            }
            case TryFinallyStatement: {
                return this.transform((TryFinallyStatement)node);
            }
            case VariableDeclarationStatement: {
                return this.transform((VariableDeclarationStatement)node);
            }
            case WhileStatement: {
                return this.transform((WhileStatement)node);
            }
            case WithStatement: {
                return this.transform((WithStatement)node);
            }
            case FunctionDeclaration: {
                return this.transform((FunctionDeclaration)node);
            }
        }
        throw new RuntimeException("not reached");
    }

    @NotNull
    default public ExpressionState transform(@NotNull Expression node) {
        switch (node.type()) {
            case LiteralBooleanExpression: {
                return this.transform((LiteralBooleanExpression)node);
            }
            case LiteralNullExpression: {
                return this.transform((LiteralNullExpression)node);
            }
            case LiteralInfinityExpression: {
                return this.transform((LiteralInfinityExpression)node);
            }
            case LiteralNumericExpression: {
                return this.transform((LiteralNumericExpression)node);
            }
            case LiteralRegExpExpression: {
                return this.transform((LiteralRegExpExpression)node);
            }
            case LiteralStringExpression: {
                return this.transform((LiteralStringExpression)node);
            }
            case ArrayExpression: {
                return this.transform((ArrayExpression)node);
            }
            case ObjectExpression: {
                return this.transform((ObjectExpression)node);
            }
            case AssignmentExpression: {
                return this.transform((AssignmentExpression)node);
            }
            case BinaryExpression: {
                return this.transform((BinaryExpression)node);
            }
            case CallExpression: {
                return this.transform((CallExpression)node);
            }
            case ComputedMemberExpression: {
                return this.transform((ComputedMemberExpression)node);
            }
            case ConditionalExpression: {
                return this.transform((ConditionalExpression)node);
            }
            case IdentifierExpression: {
                return this.transform((IdentifierExpression)node);
            }
            case NewExpression: {
                return this.transform((NewExpression)node);
            }
            case PostfixExpression: {
                return this.transform((PostfixExpression)node);
            }
            case PrefixExpression: {
                return this.transform((PrefixExpression)node);
            }
            case StaticMemberExpression: {
                return this.transform((StaticMemberExpression)node);
            }
            case ThisExpression: {
                return this.transform((ThisExpression)node);
            }
            case FunctionExpression: {
                return this.transform((FunctionExpression)node);
            }
        }
        throw new RuntimeException("not reached");
    }

    @NotNull
    default public PropertyState transform(@NotNull ObjectProperty node) {
        if (node instanceof DataProperty) {
            return this.transform((DataProperty)node);
        }
        if (node instanceof Getter) {
            return this.transform((Getter)node);
        }
        return this.transform((Setter)node);
    }

    @NotNull
    default public DirectiveState transform(@NotNull Directive node) {
        if (node instanceof UnknownDirective) {
            return this.transform((UnknownDirective)node);
        }
        return this.transform((UseStrictDirective)node);
    }

    @NotNull
    public CatchClauseState transform(@NotNull CatchClause var1);

    @NotNull
    public DeclaratorState transform(@NotNull VariableDeclarator var1);

    @NotNull
    public DirectiveState transform(@NotNull UnknownDirective var1);

    @NotNull
    public DirectiveState transform(@NotNull UseStrictDirective var1);

    @NotNull
    public ExpressionState transform(@NotNull ArrayExpression var1);

    @NotNull
    public ExpressionState transform(@NotNull BinaryExpression var1);

    @NotNull
    public ExpressionState transform(@NotNull AssignmentExpression var1);

    @NotNull
    public ExpressionState transform(@NotNull CallExpression var1);

    @NotNull
    public ExpressionState transform(@NotNull ComputedMemberExpression var1);

    @NotNull
    public ExpressionState transform(@NotNull ConditionalExpression var1);

    @NotNull
    public ExpressionState transform(@NotNull FunctionExpression var1);

    @NotNull
    public ExpressionState transform(@NotNull IdentifierExpression var1);

    @NotNull
    public ExpressionState transform(@NotNull LiteralBooleanExpression var1);

    @NotNull
    public ExpressionState transform(@NotNull LiteralNullExpression var1);

    @NotNull
    public ExpressionState transform(@NotNull LiteralInfinityExpression var1);

    @NotNull
    public ExpressionState transform(@NotNull LiteralNumericExpression var1);

    @NotNull
    public ExpressionState transform(@NotNull LiteralRegExpExpression var1);

    @NotNull
    public ExpressionState transform(@NotNull LiteralStringExpression var1);

    @NotNull
    public ExpressionState transform(@NotNull NewExpression var1);

    @NotNull
    public ExpressionState transform(@NotNull ObjectExpression var1);

    @NotNull
    public ExpressionState transform(@NotNull PostfixExpression var1);

    @NotNull
    public ExpressionState transform(@NotNull PrefixExpression var1);

    @NotNull
    public ExpressionState transform(@NotNull StaticMemberExpression var1);

    @NotNull
    public ExpressionState transform(@NotNull ThisExpression var1);

    @NotNull
    public IdentifierState transform(@NotNull Identifier var1);

    @NotNull
    public ProgramBodyState transform(@NotNull FunctionBody var1);

    @NotNull
    public ScriptState transform(@NotNull Script var1);

    @NotNull
    public PropertyNameState transform(@NotNull PropertyName var1);

    @NotNull
    public PropertyState transform(@NotNull Getter var1);

    @NotNull
    public PropertyState transform(@NotNull DataProperty var1);

    @NotNull
    public PropertyState transform(@NotNull Setter var1);

    @NotNull
    public StatementState transform(@NotNull BlockStatement var1);

    @NotNull
    public StatementState transform(@NotNull BreakStatement var1);

    @NotNull
    public StatementState transform(@NotNull ContinueStatement var1);

    @NotNull
    public StatementState transform(@NotNull DebuggerStatement var1);

    @NotNull
    public StatementState transform(@NotNull DoWhileStatement var1);

    @NotNull
    public StatementState transform(@NotNull EmptyStatement var1);

    @NotNull
    public StatementState transform(@NotNull ExpressionStatement var1);

    @NotNull
    public StatementState transform(@NotNull ForInStatement var1);

    @NotNull
    public StatementState transform(@NotNull ForStatement var1);

    @NotNull
    public StatementState transform(@NotNull FunctionDeclaration var1);

    @NotNull
    public StatementState transform(@NotNull IfStatement var1);

    @NotNull
    public StatementState transform(@NotNull LabeledStatement var1);

    @NotNull
    public StatementState transform(@NotNull ReturnStatement var1);

    @NotNull
    public StatementState transform(@NotNull SwitchStatement var1);

    @NotNull
    public StatementState transform(@NotNull SwitchStatementWithDefault var1);

    @NotNull
    public StatementState transform(@NotNull ThrowStatement var1);

    @NotNull
    public StatementState transform(@NotNull TryCatchStatement var1);

    @NotNull
    public StatementState transform(@NotNull TryFinallyStatement var1);

    @NotNull
    public StatementState transform(@NotNull VariableDeclarationStatement var1);

    @NotNull
    public BlockState transform(@NotNull Block var1);

    @NotNull
    public DeclarationState transform(@NotNull VariableDeclaration var1);

    @NotNull
    public StatementState transform(@NotNull WhileStatement var1);

    @NotNull
    public StatementState transform(@NotNull WithStatement var1);

    @NotNull
    public SwitchCaseState transform(@NotNull SwitchCase var1);

    @NotNull
    public SwitchDefaultState transform(@NotNull SwitchDefault var1);
}

