/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.visitor;

import com.shapesecurity.functional.data.Either;
import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.functional.data.Maybe;
import com.shapesecurity.functional.data.Monoid;
import com.shapesecurity.functional.data.NonEmptyImmutableList;
import com.shapesecurity.shift.ast.Block;
import com.shapesecurity.shift.ast.CatchClause;
import com.shapesecurity.shift.ast.FunctionBody;
import com.shapesecurity.shift.ast.Identifier;
import com.shapesecurity.shift.ast.Script;
import com.shapesecurity.shift.ast.SwitchCase;
import com.shapesecurity.shift.ast.SwitchDefault;
import com.shapesecurity.shift.ast.VariableDeclaration;
import com.shapesecurity.shift.ast.VariableDeclarator;
import com.shapesecurity.shift.ast.directive.UnknownDirective;
import com.shapesecurity.shift.ast.directive.UseStrictDirective;
import com.shapesecurity.shift.ast.expression.ArrayExpression;
import com.shapesecurity.shift.ast.expression.AssignmentExpression;
import com.shapesecurity.shift.ast.expression.BinaryExpression;
import com.shapesecurity.shift.ast.expression.CallExpression;
import com.shapesecurity.shift.ast.expression.ComputedMemberExpression;
import com.shapesecurity.shift.ast.expression.ConditionalExpression;
import com.shapesecurity.shift.ast.expression.FunctionExpression;
import com.shapesecurity.shift.ast.expression.IdentifierExpression;
import com.shapesecurity.shift.ast.expression.LiteralBooleanExpression;
import com.shapesecurity.shift.ast.expression.LiteralInfinityExpression;
import com.shapesecurity.shift.ast.expression.LiteralNullExpression;
import com.shapesecurity.shift.ast.expression.LiteralNumericExpression;
import com.shapesecurity.shift.ast.expression.LiteralRegExpExpression;
import com.shapesecurity.shift.ast.expression.LiteralStringExpression;
import com.shapesecurity.shift.ast.expression.NewExpression;
import com.shapesecurity.shift.ast.expression.ObjectExpression;
import com.shapesecurity.shift.ast.expression.PostfixExpression;
import com.shapesecurity.shift.ast.expression.PrefixExpression;
import com.shapesecurity.shift.ast.expression.StaticMemberExpression;
import com.shapesecurity.shift.ast.expression.ThisExpression;
import com.shapesecurity.shift.ast.property.DataProperty;
import com.shapesecurity.shift.ast.property.Getter;
import com.shapesecurity.shift.ast.property.PropertyName;
import com.shapesecurity.shift.ast.property.Setter;
import com.shapesecurity.shift.ast.statement.BlockStatement;
import com.shapesecurity.shift.ast.statement.BreakStatement;
import com.shapesecurity.shift.ast.statement.ContinueStatement;
import com.shapesecurity.shift.ast.statement.DebuggerStatement;
import com.shapesecurity.shift.ast.statement.DoWhileStatement;
import com.shapesecurity.shift.ast.statement.EmptyStatement;
import com.shapesecurity.shift.ast.statement.ExpressionStatement;
import com.shapesecurity.shift.ast.statement.ForInStatement;
import com.shapesecurity.shift.ast.statement.ForStatement;
import com.shapesecurity.shift.ast.statement.FunctionDeclaration;
import com.shapesecurity.shift.ast.statement.IfStatement;
import com.shapesecurity.shift.ast.statement.LabeledStatement;
import com.shapesecurity.shift.ast.statement.ReturnStatement;
import com.shapesecurity.shift.ast.statement.SwitchStatement;
import com.shapesecurity.shift.ast.statement.SwitchStatementWithDefault;
import com.shapesecurity.shift.ast.statement.ThrowStatement;
import com.shapesecurity.shift.ast.statement.TryCatchStatement;
import com.shapesecurity.shift.ast.statement.TryFinallyStatement;
import com.shapesecurity.shift.ast.statement.VariableDeclarationStatement;
import com.shapesecurity.shift.ast.statement.WhileStatement;
import com.shapesecurity.shift.ast.statement.WithStatement;
import com.shapesecurity.shift.path.Branch;
import com.shapesecurity.shift.visitor.Reducer;
import org.jetbrains.annotations.NotNull;

public class MonoidalReducer<State>
implements Reducer<State> {
    @NotNull
    protected final Monoid<State> monoidClass;
    private final State identity;

    protected MonoidalReducer(@NotNull Monoid<State> monoidClass) {
        this.monoidClass = monoidClass;
        this.identity = this.monoidClass.identity();
    }

    @Override
    @NotNull
    public State reduceScript(@NotNull Script node, @NotNull ImmutableList<Branch> path, @NotNull State body) {
        return body;
    }

    @Override
    @NotNull
    public State reduceIdentifier(@NotNull Identifier node, @NotNull ImmutableList<Branch> path) {
        return this.identity;
    }

    @Override
    @NotNull
    public State reduceIdentifierExpression(@NotNull IdentifierExpression node, @NotNull ImmutableList<Branch> path, @NotNull State identifier) {
        return identifier;
    }

    @Override
    @NotNull
    public State reduceThisExpression(@NotNull ThisExpression node, @NotNull ImmutableList<Branch> path) {
        return this.identity;
    }

    @Override
    @NotNull
    public State reduceLiteralBooleanExpression(@NotNull LiteralBooleanExpression node, @NotNull ImmutableList<Branch> path) {
        return this.identity;
    }

    @Override
    @NotNull
    public State reduceLiteralStringExpression(@NotNull LiteralStringExpression node, @NotNull ImmutableList<Branch> path) {
        return this.identity;
    }

    @Override
    @NotNull
    public State reduceLiteralRegExpExpression(@NotNull LiteralRegExpExpression node, @NotNull ImmutableList<Branch> path) {
        return this.identity;
    }

    @Override
    @NotNull
    public State reduceLiteralNumericExpression(@NotNull LiteralNumericExpression node, @NotNull ImmutableList<Branch> path) {
        return this.identity;
    }

    @Override
    @NotNull
    public State reduceLiteralInfinityExpression(@NotNull LiteralInfinityExpression node, @NotNull ImmutableList<Branch> path) {
        return this.identity;
    }

    @Override
    @NotNull
    public State reduceLiteralNullExpression(@NotNull LiteralNullExpression node, @NotNull ImmutableList<Branch> path) {
        return this.identity;
    }

    @Override
    @NotNull
    public State reduceFunctionExpression(@NotNull FunctionExpression node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<State> name, @NotNull ImmutableList<State> parameters, @NotNull State body) {
        return this.append(this.fold1(parameters, this.o(name)), body);
    }

    private State append(State a, State b) {
        return this.monoidClass.append(a, b);
    }

    private State fold1(ImmutableList<State> as, State a) {
        return (State)as.foldLeft(this::append, a);
    }

    @NotNull
    private State o(@NotNull Maybe<State> s) {
        return s.orJust(this.identity);
    }

    @Override
    @NotNull
    public State reduceStaticMemberExpression(@NotNull StaticMemberExpression node, @NotNull ImmutableList<Branch> path, @NotNull State object, @NotNull State property) {
        return this.append(object, property);
    }

    @Override
    @NotNull
    public State reduceComputedMemberExpression(@NotNull ComputedMemberExpression node, @NotNull ImmutableList<Branch> path, @NotNull State object, @NotNull State expression) {
        return this.append(object, expression);
    }

    @Override
    @NotNull
    public State reduceObjectExpression(@NotNull ObjectExpression node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<State> properties) {
        return this.fold(properties);
    }

    private State fold(ImmutableList<State> as) {
        return (State)as.foldLeft(this::append, this.identity);
    }

    @Override
    @NotNull
    public State reduceBinaryExpression(@NotNull BinaryExpression node, @NotNull ImmutableList<Branch> path, @NotNull State left, @NotNull State right) {
        return this.append(left, right);
    }

    @Override
    @NotNull
    public State reduceAssignmentExpression(@NotNull AssignmentExpression node, @NotNull ImmutableList<Branch> path, @NotNull State binding, @NotNull State expression) {
        return this.append(binding, expression);
    }

    @Override
    @NotNull
    public State reduceArrayExpression(@NotNull ArrayExpression node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<Maybe<State>> elements) {
        return (State)this.fold(Maybe.catMaybes(elements));
    }

    @Override
    @NotNull
    public State reduceNewExpression(@NotNull NewExpression node, @NotNull ImmutableList<Branch> path, @NotNull State callee, @NotNull ImmutableList<State> arguments) {
        return this.fold1(arguments, callee);
    }

    @Override
    @NotNull
    public State reduceCallExpression(@NotNull CallExpression node, @NotNull ImmutableList<Branch> path, @NotNull State callee, @NotNull ImmutableList<State> arguments) {
        return this.fold1(arguments, callee);
    }

    @Override
    @NotNull
    public State reducePostfixExpression(@NotNull PostfixExpression node, @NotNull ImmutableList<Branch> path, @NotNull State operand) {
        return operand;
    }

    @Override
    @NotNull
    public State reducePrefixExpression(@NotNull PrefixExpression node, @NotNull ImmutableList<Branch> path, @NotNull State operand) {
        return operand;
    }

    @Override
    @NotNull
    public State reduceConditionalExpression(@NotNull ConditionalExpression node, @NotNull ImmutableList<Branch> path, @NotNull State test, @NotNull State consequent, @NotNull State alternate) {
        return this.append(test, consequent, alternate);
    }

    private State append(State a, State b, State c) {
        return this.append(this.append(a, b), c);
    }

    @Override
    @NotNull
    public State reduceFunctionDeclaration(@NotNull FunctionDeclaration node, @NotNull ImmutableList<Branch> path, @NotNull State name, @NotNull ImmutableList<State> params, @NotNull State body) {
        return this.append(this.fold1(params, name), body);
    }

    @Override
    @NotNull
    public State reduceUseStrictDirective(@NotNull UseStrictDirective node, @NotNull ImmutableList<Branch> path) {
        return this.identity;
    }

    @Override
    @NotNull
    public State reduceUnknownDirective(@NotNull UnknownDirective node, @NotNull ImmutableList<Branch> path) {
        return this.identity;
    }

    @Override
    @NotNull
    public State reduceBlockStatement(@NotNull BlockStatement node, @NotNull ImmutableList<Branch> path, @NotNull State block) {
        return block;
    }

    @Override
    @NotNull
    public State reduceBreakStatement(@NotNull BreakStatement node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<State> label) {
        return this.o(label);
    }

    @Override
    @NotNull
    public State reduceCatchClause(@NotNull CatchClause node, @NotNull ImmutableList<Branch> path, @NotNull State binding, @NotNull State body) {
        return this.append(binding, body);
    }

    @Override
    @NotNull
    public State reduceContinueStatement(@NotNull ContinueStatement node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<State> label) {
        return this.o(label);
    }

    @Override
    @NotNull
    public State reduceDebuggerStatement(@NotNull DebuggerStatement node, @NotNull ImmutableList<Branch> path) {
        return this.identity;
    }

    @Override
    @NotNull
    public State reduceDoWhileStatement(@NotNull DoWhileStatement node, @NotNull ImmutableList<Branch> path, @NotNull State body, @NotNull State test) {
        return this.append(body, test);
    }

    @Override
    @NotNull
    public State reduceEmptyStatement(@NotNull EmptyStatement node, @NotNull ImmutableList<Branch> path) {
        return this.identity;
    }

    @Override
    @NotNull
    public State reduceExpressionStatement(@NotNull ExpressionStatement node, @NotNull ImmutableList<Branch> path, @NotNull State expression) {
        return expression;
    }

    @Override
    @NotNull
    public State reduceForInStatement(@NotNull ForInStatement node, @NotNull ImmutableList<Branch> path, @NotNull Either<State, State> left, @NotNull State right, @NotNull State body) {
        return (State)this.append(Either.extract(left), right, body);
    }

    @Override
    @NotNull
    public State reduceForStatement(@NotNull ForStatement node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<Either<State, State>> init, @NotNull Maybe<State> test, @NotNull Maybe<State> update, @NotNull State body) {
        return (State)this.append(this.o(init.map(Either::extract)), this.o(test), this.o(update), body);
    }

    private State append(State a, State b, State c, State d) {
        return this.append(this.append(a, b, c), d);
    }

    @Override
    @NotNull
    public State reduceIfStatement(@NotNull IfStatement node, @NotNull ImmutableList<Branch> path, @NotNull State test, @NotNull State consequent, @NotNull Maybe<State> alternate) {
        return this.append(test, consequent, this.o(alternate));
    }

    @Override
    @NotNull
    public State reduceLabeledStatement(@NotNull LabeledStatement node, @NotNull ImmutableList<Branch> path, @NotNull State label, @NotNull State body) {
        return this.append(label, body);
    }

    @Override
    @NotNull
    public State reduceReturnStatement(@NotNull ReturnStatement node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<State> expression) {
        return this.o(expression);
    }

    @Override
    @NotNull
    public State reduceSwitchCase(@NotNull SwitchCase node, @NotNull ImmutableList<Branch> path, @NotNull State test, @NotNull ImmutableList<State> consequent) {
        return this.fold1(consequent, test);
    }

    @Override
    @NotNull
    public State reduceSwitchDefault(@NotNull SwitchDefault node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<State> consequent) {
        return this.fold(consequent);
    }

    @Override
    @NotNull
    public State reduceSwitchStatement(@NotNull SwitchStatement node, @NotNull ImmutableList<Branch> path, @NotNull State discriminant, @NotNull ImmutableList<State> cases) {
        return this.fold1(cases, discriminant);
    }

    @Override
    @NotNull
    public State reduceSwitchStatementWithDefault(@NotNull SwitchStatementWithDefault node, @NotNull ImmutableList<Branch> path, @NotNull State discriminant, @NotNull ImmutableList<State> preDefaultCases, @NotNull State defaultCase, @NotNull ImmutableList<State> postDefaultCases) {
        return this.append(discriminant, this.fold(preDefaultCases), defaultCase, this.fold(postDefaultCases));
    }

    @Override
    @NotNull
    public State reduceThrowStatement(@NotNull ThrowStatement node, @NotNull ImmutableList<Branch> path, @NotNull State expression) {
        return expression;
    }

    @Override
    @NotNull
    public State reduceTryCatchStatement(@NotNull TryCatchStatement node, @NotNull ImmutableList<Branch> path, @NotNull State block, @NotNull State catchClause) {
        return this.append(block, catchClause);
    }

    @Override
    @NotNull
    public State reduceTryFinallyStatement(@NotNull TryFinallyStatement node, @NotNull ImmutableList<Branch> path, @NotNull State block, @NotNull Maybe<State> catchClause, @NotNull State finalizer) {
        return this.append(block, this.o(catchClause), finalizer);
    }

    @Override
    @NotNull
    public State reduceVariableDeclarationStatement(@NotNull VariableDeclarationStatement node, @NotNull ImmutableList<Branch> path, @NotNull State declaration) {
        return declaration;
    }

    @Override
    @NotNull
    public State reduceVariableDeclaration(@NotNull VariableDeclaration node, @NotNull ImmutableList<Branch> path, @NotNull NonEmptyImmutableList<State> declarators) {
        return this.fold(declarators);
    }

    @Override
    @NotNull
    public State reduceWhileStatement(@NotNull WhileStatement node, @NotNull ImmutableList<Branch> path, @NotNull State test, @NotNull State body) {
        return this.append(test, body);
    }

    @Override
    @NotNull
    public State reduceWithStatement(@NotNull WithStatement node, @NotNull ImmutableList<Branch> path, @NotNull State object, @NotNull State body) {
        return this.append(object, body);
    }

    @Override
    @NotNull
    public State reduceDataProperty(@NotNull DataProperty node, @NotNull ImmutableList<Branch> path, @NotNull State name, @NotNull State value) {
        return this.append(name, value);
    }

    @Override
    @NotNull
    public State reduceGetter(@NotNull Getter node, @NotNull ImmutableList<Branch> path, @NotNull State name, @NotNull State body) {
        return this.append(name, body);
    }

    @Override
    @NotNull
    public State reduceSetter(@NotNull Setter node, @NotNull ImmutableList<Branch> path, @NotNull State name, @NotNull State parameter, @NotNull State body) {
        return this.append(name, parameter, body);
    }

    @Override
    @NotNull
    public State reducePropertyName(@NotNull PropertyName node, @NotNull ImmutableList<Branch> path) {
        return this.identity;
    }

    @Override
    @NotNull
    public State reduceFunctionBody(@NotNull FunctionBody node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<State> directives, @NotNull ImmutableList<State> statements) {
        return this.append(this.fold(directives), this.fold(statements));
    }

    @Override
    @NotNull
    public State reduceVariableDeclarator(@NotNull VariableDeclarator node, @NotNull ImmutableList<Branch> path, @NotNull State binding, @NotNull Maybe<State> init) {
        return this.append(binding, this.o(init));
    }

    @Override
    @NotNull
    public State reduceBlock(@NotNull Block node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<State> statements) {
        return this.fold(statements);
    }
}

