/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.visitor;

import com.shapesecurity.functional.F;
import com.shapesecurity.functional.Thunk;
import com.shapesecurity.functional.data.Either;
import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.functional.data.Maybe;
import com.shapesecurity.functional.data.NonEmptyImmutableList;
import com.shapesecurity.shift.ast.Block;
import com.shapesecurity.shift.ast.CatchClause;
import com.shapesecurity.shift.ast.Directive;
import com.shapesecurity.shift.ast.Expression;
import com.shapesecurity.shift.ast.FunctionBody;
import com.shapesecurity.shift.ast.Identifier;
import com.shapesecurity.shift.ast.Script;
import com.shapesecurity.shift.ast.Statement;
import com.shapesecurity.shift.ast.SwitchCase;
import com.shapesecurity.shift.ast.SwitchDefault;
import com.shapesecurity.shift.ast.VariableDeclaration;
import com.shapesecurity.shift.ast.VariableDeclarator;
import com.shapesecurity.shift.ast.directive.UnknownDirective;
import com.shapesecurity.shift.ast.directive.UseStrictDirective;
import com.shapesecurity.shift.ast.expression.ArrayExpression;
import com.shapesecurity.shift.ast.expression.AssignmentExpression;
import com.shapesecurity.shift.ast.expression.BinaryExpression;
import com.shapesecurity.shift.ast.expression.CallExpression;
import com.shapesecurity.shift.ast.expression.ComputedMemberExpression;
import com.shapesecurity.shift.ast.expression.ConditionalExpression;
import com.shapesecurity.shift.ast.expression.FunctionExpression;
import com.shapesecurity.shift.ast.expression.IdentifierExpression;
import com.shapesecurity.shift.ast.expression.LiteralBooleanExpression;
import com.shapesecurity.shift.ast.expression.LiteralInfinityExpression;
import com.shapesecurity.shift.ast.expression.LiteralNullExpression;
import com.shapesecurity.shift.ast.expression.LiteralNumericExpression;
import com.shapesecurity.shift.ast.expression.LiteralRegExpExpression;
import com.shapesecurity.shift.ast.expression.LiteralStringExpression;
import com.shapesecurity.shift.ast.expression.NewExpression;
import com.shapesecurity.shift.ast.expression.ObjectExpression;
import com.shapesecurity.shift.ast.expression.PostfixExpression;
import com.shapesecurity.shift.ast.expression.PrefixExpression;
import com.shapesecurity.shift.ast.expression.StaticMemberExpression;
import com.shapesecurity.shift.ast.expression.ThisExpression;
import com.shapesecurity.shift.ast.property.DataProperty;
import com.shapesecurity.shift.ast.property.Getter;
import com.shapesecurity.shift.ast.property.ObjectProperty;
import com.shapesecurity.shift.ast.property.PropertyName;
import com.shapesecurity.shift.ast.property.Setter;
import com.shapesecurity.shift.ast.statement.BlockStatement;
import com.shapesecurity.shift.ast.statement.BreakStatement;
import com.shapesecurity.shift.ast.statement.ContinueStatement;
import com.shapesecurity.shift.ast.statement.DebuggerStatement;
import com.shapesecurity.shift.ast.statement.DoWhileStatement;
import com.shapesecurity.shift.ast.statement.EmptyStatement;
import com.shapesecurity.shift.ast.statement.ExpressionStatement;
import com.shapesecurity.shift.ast.statement.ForInStatement;
import com.shapesecurity.shift.ast.statement.ForStatement;
import com.shapesecurity.shift.ast.statement.FunctionDeclaration;
import com.shapesecurity.shift.ast.statement.IfStatement;
import com.shapesecurity.shift.ast.statement.LabeledStatement;
import com.shapesecurity.shift.ast.statement.ReturnStatement;
import com.shapesecurity.shift.ast.statement.SwitchStatement;
import com.shapesecurity.shift.ast.statement.SwitchStatementWithDefault;
import com.shapesecurity.shift.ast.statement.ThrowStatement;
import com.shapesecurity.shift.ast.statement.TryCatchStatement;
import com.shapesecurity.shift.ast.statement.TryFinallyStatement;
import com.shapesecurity.shift.ast.statement.VariableDeclarationStatement;
import com.shapesecurity.shift.ast.statement.WhileStatement;
import com.shapesecurity.shift.ast.statement.WithStatement;
import com.shapesecurity.shift.path.Branch;
import com.shapesecurity.shift.visitor.CloneReducer;
import com.shapesecurity.shift.visitor.DirtyState;
import com.shapesecurity.shift.visitor.ReducerP;
import org.jetbrains.annotations.NotNull;

public class LazyCloner
implements ReducerP<DirtyState<Script>, DirtyState<FunctionBody>, DirtyState<ObjectProperty>, DirtyState<PropertyName>, DirtyState<Identifier>, DirtyState<Expression>, DirtyState<Directive>, DirtyState<Statement>, DirtyState<Block>, DirtyState<VariableDeclarator>, DirtyState<VariableDeclaration>, DirtyState<SwitchCase>, DirtyState<SwitchDefault>, DirtyState<CatchClause>> {
    public static final LazyCloner INSTANCE = new LazyCloner();

    protected LazyCloner() {
    }

    private static <T> DirtyState<ImmutableList<Maybe<T>>> lo(ImmutableList<Maybe<DirtyState<T>>> elements) {
        return LazyCloner.l(elements.map(LazyCloner::op));
    }

    private static <T> DirtyState<ImmutableList<T>> l(@NotNull ImmutableList<DirtyState<T>> node) {
        return new DirtyState<ImmutableList<T>>(node.map(tDirtyState -> tDirtyState.node), node.exists(tDirtyState -> tDirtyState.dirty));
    }

    private static <T> DirtyState<Maybe<T>> op(@NotNull Maybe<DirtyState<T>> node) {
        if (node.isJust()) {
            DirtyState<T> s = node.just();
            return new DirtyState(Maybe.just(s.node), s.dirty);
        }
        return LazyCloner.clean(Maybe.nothing());
    }

    private static <U> DirtyState<U> get(@NotNull U def, @NotNull DirtyState<Thunk<U>> s) {
        return s.dirty ? LazyCloner.dirty(((Thunk)s.node).get()) : LazyCloner.clean(def);
    }

    private static <T> DirtyState<T> dirty(@NotNull T node) {
        return new DirtyState<T>(node, true);
    }

    private static <T> DirtyState<T> clean(@NotNull T node) {
        return new DirtyState<T>(node, false);
    }

    private static <T> DirtyState<NonEmptyImmutableList<T>> l(@NotNull NonEmptyImmutableList<DirtyState<T>> node) {
        return new DirtyState<ImmutableList>(node.map(tDirtyState -> tDirtyState.node), node.exists((F<DirtyState<DirtyState>, Boolean>)((F<DirtyState, Boolean>)tDirtyState -> tDirtyState.dirty)));
    }

    @Override
    @NotNull
    public DirtyState<Script> reduceScript(@NotNull Script node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<FunctionBody> body) {
        if (body.dirty) {
            return LazyCloner.dirty(new Script((FunctionBody)body.node));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Identifier> reduceIdentifier(@NotNull Identifier node, @NotNull ImmutableList<Branch> path) {
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Expression> reduceIdentifierExpression(@NotNull IdentifierExpression node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Identifier> identifier) {
        if (identifier.dirty) {
            return LazyCloner.dirty(new IdentifierExpression(node.identifier));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Expression> reduceThisExpression(@NotNull ThisExpression node, @NotNull ImmutableList<Branch> path) {
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Expression> reduceLiteralBooleanExpression(@NotNull LiteralBooleanExpression node, @NotNull ImmutableList<Branch> path) {
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Expression> reduceLiteralStringExpression(@NotNull LiteralStringExpression node, @NotNull ImmutableList<Branch> path) {
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Expression> reduceLiteralRegExpExpression(@NotNull LiteralRegExpExpression node, @NotNull ImmutableList<Branch> path) {
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Expression> reduceLiteralNumericExpression(@NotNull LiteralNumericExpression node, @NotNull ImmutableList<Branch> path) {
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Expression> reduceLiteralInfinityExpression(@NotNull LiteralInfinityExpression node, @NotNull ImmutableList<Branch> path) {
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Expression> reduceLiteralNullExpression(@NotNull LiteralNullExpression node, @NotNull ImmutableList<Branch> path) {
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Expression> reduceFunctionExpression(@NotNull FunctionExpression node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<DirtyState<Identifier>> name, @NotNull ImmutableList<DirtyState<Identifier>> parameters, @NotNull DirtyState<FunctionBody> body) {
        DirtyState i = LazyCloner.op(name);
        DirtyState p = LazyCloner.l(parameters);
        if (i.dirty || p.dirty || body.dirty) {
            return LazyCloner.dirty(new FunctionExpression((Maybe)i.node, (ImmutableList)p.node, (FunctionBody)body.node));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Expression> reduceStaticMemberExpression(@NotNull StaticMemberExpression node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Expression> object, @NotNull DirtyState<Identifier> property) {
        if (object.dirty || property.dirty) {
            return LazyCloner.dirty(new StaticMemberExpression((Expression)object.node, (Identifier)property.node));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Expression> reduceComputedMemberExpression(@NotNull ComputedMemberExpression node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Expression> object, @NotNull DirtyState<Expression> expression) {
        if (object.dirty || expression.dirty) {
            return LazyCloner.dirty(new ComputedMemberExpression((Expression)object.node, (Expression)expression.node));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Expression> reduceObjectExpression(@NotNull ObjectExpression node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<DirtyState<ObjectProperty>> properties) {
        DirtyState p = LazyCloner.l(properties);
        if (p.dirty) {
            return LazyCloner.dirty(new ObjectExpression((ImmutableList)p.node));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Expression> reduceBinaryExpression(@NotNull BinaryExpression node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Expression> left, @NotNull DirtyState<Expression> right) {
        return LazyCloner.get(node, left.bind(l -> right.bindLast(r -> new BinaryExpression(binaryExpression.operator, (Expression)l, (Expression)r))));
    }

    @Override
    @NotNull
    public DirtyState<Expression> reduceAssignmentExpression(@NotNull AssignmentExpression node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Expression> binding, @NotNull DirtyState<Expression> expression) {
        return LazyCloner.get(node, binding.bind(l -> expression.bindLast(r -> new AssignmentExpression(assignmentExpression.operator, (Expression)l, (Expression)r))));
    }

    @Override
    @NotNull
    public DirtyState<Expression> reduceArrayExpression(@NotNull ArrayExpression node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<Maybe<DirtyState<Expression>>> elements) {
        return LazyCloner.get(node, LazyCloner.lo(elements).bindLast(ArrayExpression::new));
    }

    @Override
    @NotNull
    public DirtyState<Expression> reduceNewExpression(@NotNull NewExpression node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Expression> callee, @NotNull ImmutableList<DirtyState<Expression>> arguments) {
        DirtyState args = LazyCloner.l(arguments);
        if (callee.dirty || args.dirty) {
            return LazyCloner.dirty(new NewExpression((Expression)callee.node, (ImmutableList)args.node));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Expression> reduceCallExpression(@NotNull CallExpression node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Expression> callee, @NotNull ImmutableList<DirtyState<Expression>> arguments) {
        DirtyState args = LazyCloner.l(arguments);
        if (callee.dirty || args.dirty) {
            return LazyCloner.dirty(new CallExpression((Expression)callee.node, (ImmutableList)args.node));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Expression> reducePostfixExpression(@NotNull PostfixExpression node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Expression> operand) {
        if (operand.dirty) {
            return LazyCloner.dirty(new PostfixExpression(node.operator, (Expression)operand.node));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Expression> reducePrefixExpression(@NotNull PrefixExpression node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Expression> operand) {
        if (operand.dirty) {
            return LazyCloner.dirty(new PrefixExpression(node.operator, (Expression)operand.node));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Expression> reduceConditionalExpression(@NotNull ConditionalExpression node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Expression> test, @NotNull DirtyState<Expression> consequent, @NotNull DirtyState<Expression> alternate) {
        return LazyCloner.get(node, test.bind(t -> consequent.bind(c -> alternate.bindLast(a -> new ConditionalExpression((Expression)t, (Expression)c, (Expression)a)))));
    }

    @Override
    @NotNull
    public DirtyState<Statement> reduceFunctionDeclaration(@NotNull FunctionDeclaration node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Identifier> name, @NotNull ImmutableList<DirtyState<Identifier>> params, @NotNull DirtyState<FunctionBody> body) {
        return LazyCloner.get(node, name.bind(id1 -> LazyCloner.l(params).bind(params1 -> body.bindLast(body1 -> new FunctionDeclaration((Identifier)id1, (ImmutableList<Identifier>)params1, (FunctionBody)body1)))));
    }

    @Override
    @NotNull
    public DirtyState<Directive> reduceUseStrictDirective(@NotNull UseStrictDirective node, @NotNull ImmutableList<Branch> path) {
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Directive> reduceUnknownDirective(@NotNull UnknownDirective node, @NotNull ImmutableList<Branch> path) {
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Statement> reduceBlockStatement(@NotNull BlockStatement node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Block> block) {
        if (block.dirty) {
            return LazyCloner.dirty(new BlockStatement((Block)block.node));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Statement> reduceBreakStatement(@NotNull BreakStatement node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<DirtyState<Identifier>> label) {
        if (label.isJust() && label.just().dirty) {
            return LazyCloner.dirty(new BreakStatement(Maybe.just(label.just().node)));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<CatchClause> reduceCatchClause(@NotNull CatchClause node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Identifier> binding, @NotNull DirtyState<Block> body) {
        return LazyCloner.get(node, binding.bind(p -> body.bindLast(s -> new CatchClause((Identifier)p, (Block)s))));
    }

    @Override
    @NotNull
    public DirtyState<Statement> reduceContinueStatement(@NotNull ContinueStatement node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<DirtyState<Identifier>> label) {
        if (label.isJust() && label.just().dirty) {
            return LazyCloner.dirty(new ContinueStatement(Maybe.just(label.just().node)));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Statement> reduceDebuggerStatement(@NotNull DebuggerStatement node, @NotNull ImmutableList<Branch> path) {
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Statement> reduceDoWhileStatement(@NotNull DoWhileStatement node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Statement> body, @NotNull DirtyState<Expression> test) {
        return LazyCloner.get(node, body.bind(body1 -> test.bindLast(test1 -> new DoWhileStatement((Statement)body1, (Expression)test1))));
    }

    @Override
    @NotNull
    public DirtyState<Statement> reduceEmptyStatement(@NotNull EmptyStatement node, @NotNull ImmutableList<Branch> path) {
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Statement> reduceExpressionStatement(@NotNull ExpressionStatement node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Expression> expression) {
        if (expression.dirty) {
            return LazyCloner.dirty(new ExpressionStatement((Expression)expression.node));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Statement> reduceForInStatement(@NotNull ForInStatement node, @NotNull ImmutableList<Branch> path, @NotNull Either<DirtyState<VariableDeclaration>, DirtyState<Expression>> left, @NotNull DirtyState<Expression> right, @NotNull DirtyState<Statement> body) {
        boolean leftDirty = left.either(x -> x.dirty, x -> x.dirty);
        Either<VariableDeclaration, Expression> leftNode = left.map(x -> (VariableDeclaration)x.node, x -> (Expression)x.node);
        if (leftDirty || right.dirty || body.dirty) {
            return LazyCloner.dirty(new ForInStatement(leftNode, (Expression)right.node, (Statement)body.node));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Statement> reduceForStatement(@NotNull ForStatement node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<Either<DirtyState<VariableDeclaration>, DirtyState<Expression>>> init, @NotNull Maybe<DirtyState<Expression>> test, @NotNull Maybe<DirtyState<Expression>> update, @NotNull DirtyState<Statement> body) {
        boolean iDirty = init.map(x -> x.either(y -> y.dirty, y -> y.dirty)).orJust(false);
        Maybe<Either<VariableDeclaration, Expression>> iNode = init.map(x -> x.map(y -> (VariableDeclaration)y.node, y -> (Expression)y.node));
        DirtyState t = LazyCloner.op(test);
        DirtyState u = LazyCloner.op(update);
        if (iDirty || t.dirty || u.dirty || body.dirty) {
            return LazyCloner.dirty(new ForStatement(iNode, (Maybe)t.node, (Maybe)u.node, (Statement)body.node));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Statement> reduceIfStatement(@NotNull IfStatement node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Expression> test, @NotNull DirtyState<Statement> consequent, @NotNull Maybe<DirtyState<Statement>> alternate) {
        return LazyCloner.get(node, test.bind(test1 -> consequent.bind(consequent1 -> LazyCloner.op(alternate).bindLast(alternate1 -> new IfStatement((Expression)test1, (Statement)consequent1, (Maybe<Statement>)alternate1)))));
    }

    @Override
    @NotNull
    public DirtyState<Statement> reduceLabeledStatement(@NotNull LabeledStatement node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Identifier> label, @NotNull DirtyState<Statement> body) {
        return LazyCloner.get(node, label.bind(label1 -> body.bindLast(body1 -> new LabeledStatement((Identifier)label1, (Statement)body1))));
    }

    @Override
    @NotNull
    public DirtyState<Statement> reduceReturnStatement(@NotNull ReturnStatement node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<DirtyState<Expression>> expression) {
        if (expression.isNothing() || !expression.just().dirty) {
            return LazyCloner.clean(node);
        }
        return DirtyState.dirty(new ReturnStatement(Maybe.just(expression.just().node)));
    }

    @Override
    @NotNull
    public DirtyState<SwitchCase> reduceSwitchCase(@NotNull SwitchCase node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Expression> test, @NotNull ImmutableList<DirtyState<Statement>> consequent) {
        return LazyCloner.get(node, test.bind(test1 -> LazyCloner.l(consequent).bindLast(consequent1 -> new SwitchCase((Expression)test1, (ImmutableList<Statement>)consequent1))));
    }

    @Override
    @NotNull
    public DirtyState<SwitchDefault> reduceSwitchDefault(@NotNull SwitchDefault node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<DirtyState<Statement>> consequent) {
        return LazyCloner.get(node, LazyCloner.l(consequent).bindLast(SwitchDefault::new));
    }

    @Override
    @NotNull
    public DirtyState<Statement> reduceSwitchStatement(@NotNull SwitchStatement node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Expression> discriminant, @NotNull ImmutableList<DirtyState<SwitchCase>> cases) {
        return LazyCloner.get(node, discriminant.bind(discriminant1 -> LazyCloner.l(cases).bindLast(cases1 -> CloneReducer.INSTANCE.reduceSwitchStatement(node, path, (Expression)discriminant1, (ImmutableList<SwitchCase>)cases1))));
    }

    @Override
    @NotNull
    public DirtyState<Statement> reduceSwitchStatementWithDefault(@NotNull SwitchStatementWithDefault node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Expression> discriminant, @NotNull ImmutableList<DirtyState<SwitchCase>> preDefaultCases, @NotNull DirtyState<SwitchDefault> defaultCase, @NotNull ImmutableList<DirtyState<SwitchCase>> postDefaultCases) {
        DirtyState cs = LazyCloner.l(preDefaultCases);
        DirtyState pcs = LazyCloner.l(postDefaultCases);
        if (discriminant.dirty || cs.dirty || defaultCase.dirty || pcs.dirty) {
            return LazyCloner.dirty(new SwitchStatementWithDefault((Expression)discriminant.node, (ImmutableList)cs.node, (SwitchDefault)defaultCase.node, (ImmutableList)pcs.node));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Statement> reduceThrowStatement(@NotNull ThrowStatement node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Expression> expression) {
        return LazyCloner.get(node, expression.bindLast(ThrowStatement::new));
    }

    @Override
    @NotNull
    public DirtyState<Statement> reduceTryCatchStatement(@NotNull TryCatchStatement node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Block> block, @NotNull DirtyState<CatchClause> catchClause) {
        if (block.dirty || catchClause.dirty) {
            return DirtyState.dirty(new TryCatchStatement((Block)block.node, (CatchClause)catchClause.node));
        }
        return DirtyState.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Statement> reduceTryFinallyStatement(@NotNull TryFinallyStatement node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Block> block, @NotNull Maybe<DirtyState<CatchClause>> catchClause, @NotNull DirtyState<Block> finalizer) {
        DirtyState op = LazyCloner.op(catchClause);
        if (block.dirty || op.dirty || finalizer.dirty) {
            return LazyCloner.dirty(new TryFinallyStatement((Block)block.node, (Maybe)op.node, (Block)finalizer.node));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Statement> reduceVariableDeclarationStatement(@NotNull VariableDeclarationStatement node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<VariableDeclaration> declaration) {
        if (declaration.dirty) {
            return LazyCloner.dirty(new VariableDeclarationStatement((VariableDeclaration)declaration.node));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<VariableDeclaration> reduceVariableDeclaration(@NotNull VariableDeclaration node, @NotNull ImmutableList<Branch> path, @NotNull NonEmptyImmutableList<DirtyState<VariableDeclarator>> declarators) {
        DirtyState ds = LazyCloner.l(declarators);
        if (ds.dirty) {
            return LazyCloner.dirty(new VariableDeclaration(node.kind, (NonEmptyImmutableList)ds.node));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Statement> reduceWhileStatement(@NotNull WhileStatement node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Expression> test, @NotNull DirtyState<Statement> body) {
        if (test.dirty || body.dirty) {
            return LazyCloner.dirty(new WhileStatement((Expression)test.node, (Statement)body.node));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Statement> reduceWithStatement(@NotNull WithStatement node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Expression> object, @NotNull DirtyState<Statement> body) {
        return LazyCloner.get(node, object.bind(object1 -> body.bindLast(body1 -> new WithStatement((Expression)object1, (Statement)body1))));
    }

    @Override
    @NotNull
    public DirtyState<ObjectProperty> reduceDataProperty(@NotNull DataProperty node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<PropertyName> name, @NotNull DirtyState<Expression> value) {
        if (name.dirty || value.dirty) {
            return LazyCloner.dirty(new DataProperty((PropertyName)name.node, (Expression)value.node));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<ObjectProperty> reduceGetter(@NotNull Getter node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<PropertyName> name, @NotNull DirtyState<FunctionBody> body) {
        return LazyCloner.get(node, name.bind(propertyName -> body.bindLast(programBody -> new Getter((PropertyName)propertyName, (FunctionBody)programBody))));
    }

    @Override
    @NotNull
    public DirtyState<ObjectProperty> reduceSetter(@NotNull Setter node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<PropertyName> name, @NotNull DirtyState<Identifier> parameter, @NotNull DirtyState<FunctionBody> body) {
        if (name.dirty || parameter.dirty || body.dirty) {
            return LazyCloner.dirty(new Setter((PropertyName)name.node, (Identifier)parameter.node, (FunctionBody)body.node));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<PropertyName> reducePropertyName(@NotNull PropertyName node, @NotNull ImmutableList<Branch> path) {
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<FunctionBody> reduceFunctionBody(@NotNull FunctionBody node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<DirtyState<Directive>> directives, @NotNull ImmutableList<DirtyState<Statement>> statements) {
        DirtyState dirs = LazyCloner.l(directives);
        DirtyState ses = LazyCloner.l(statements);
        if (dirs.dirty || ses.dirty) {
            return DirtyState.dirty(new FunctionBody((ImmutableList)dirs.node, (ImmutableList)ses.node));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<VariableDeclarator> reduceVariableDeclarator(@NotNull VariableDeclarator node, @NotNull ImmutableList<Branch> path, @NotNull DirtyState<Identifier> binding, @NotNull Maybe<DirtyState<Expression>> init) {
        if (binding.dirty) {
            return LazyCloner.dirty(new VariableDeclarator((Identifier)binding.node, init.map(expr -> (Expression)expr.node)));
        }
        if (init.isJust() && init.just().dirty) {
            return LazyCloner.dirty(new VariableDeclarator((Identifier)binding.node, Maybe.just(init.just().node)));
        }
        return LazyCloner.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Block> reduceBlock(@NotNull Block node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<DirtyState<Statement>> statements) {
        DirtyState ds = LazyCloner.l(statements);
        if (ds.dirty) {
            return DirtyState.dirty(new Block((ImmutableList)ds.node));
        }
        return DirtyState.clean(node);
    }
}

