/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.visitor;

import com.shapesecurity.functional.F;
import com.shapesecurity.functional.Thunk;
import org.jetbrains.annotations.NotNull;

public class DirtyState<T> {
    @NotNull
    public final T node;
    public final boolean dirty;

    public DirtyState(@NotNull T node, boolean dirty) {
        this.node = node;
        this.dirty = dirty;
    }

    public static <T> DirtyState<T> clean(@NotNull T node) {
        return new DirtyState<T>(node, false);
    }

    public static <T> DirtyState<T> dirty(@NotNull T node) {
        return new DirtyState<T>(node, true);
    }

    public <U> DirtyState<U> bind(@NotNull F<T, DirtyState<U>> f) {
        if (this.dirty) {
            DirtyState<U> b = f.apply(this.node);
            if (b.dirty) {
                return b;
            }
            return new DirtyState<T>(b.node, true);
        }
        return f.apply(this.node);
    }

    public <U> DirtyState<Thunk<U>> bindLast(@NotNull F<T, U> f) {
        return new DirtyState<Thunk<U>>(Thunk.from(() -> f.apply(this.node)), this.dirty);
    }

    public DirtyState<T> onDirty(@NotNull F<T, DirtyState<T>> f) {
        if (this.dirty) {
            return f.apply(this.node);
        }
        return this;
    }

    @NotNull
    public DirtyState<T> setDirty() {
        if (this.dirty) {
            return this;
        }
        return new DirtyState<T>(this.node, true);
    }
}

