/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.visitor;

import com.shapesecurity.functional.data.Either;
import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.functional.data.Maybe;
import com.shapesecurity.functional.data.NonEmptyImmutableList;
import com.shapesecurity.shift.ast.Block;
import com.shapesecurity.shift.ast.CatchClause;
import com.shapesecurity.shift.ast.Directive;
import com.shapesecurity.shift.ast.Expression;
import com.shapesecurity.shift.ast.FunctionBody;
import com.shapesecurity.shift.ast.Identifier;
import com.shapesecurity.shift.ast.Node;
import com.shapesecurity.shift.ast.Script;
import com.shapesecurity.shift.ast.Statement;
import com.shapesecurity.shift.ast.SwitchCase;
import com.shapesecurity.shift.ast.SwitchDefault;
import com.shapesecurity.shift.ast.VariableDeclaration;
import com.shapesecurity.shift.ast.VariableDeclarator;
import com.shapesecurity.shift.ast.directive.UnknownDirective;
import com.shapesecurity.shift.ast.directive.UseStrictDirective;
import com.shapesecurity.shift.ast.expression.ArrayExpression;
import com.shapesecurity.shift.ast.expression.AssignmentExpression;
import com.shapesecurity.shift.ast.expression.BinaryExpression;
import com.shapesecurity.shift.ast.expression.CallExpression;
import com.shapesecurity.shift.ast.expression.ComputedMemberExpression;
import com.shapesecurity.shift.ast.expression.ConditionalExpression;
import com.shapesecurity.shift.ast.expression.FunctionExpression;
import com.shapesecurity.shift.ast.expression.IdentifierExpression;
import com.shapesecurity.shift.ast.expression.LiteralBooleanExpression;
import com.shapesecurity.shift.ast.expression.LiteralInfinityExpression;
import com.shapesecurity.shift.ast.expression.LiteralNullExpression;
import com.shapesecurity.shift.ast.expression.LiteralNumericExpression;
import com.shapesecurity.shift.ast.expression.LiteralRegExpExpression;
import com.shapesecurity.shift.ast.expression.LiteralStringExpression;
import com.shapesecurity.shift.ast.expression.NewExpression;
import com.shapesecurity.shift.ast.expression.ObjectExpression;
import com.shapesecurity.shift.ast.expression.PostfixExpression;
import com.shapesecurity.shift.ast.expression.PrefixExpression;
import com.shapesecurity.shift.ast.expression.StaticMemberExpression;
import com.shapesecurity.shift.ast.expression.ThisExpression;
import com.shapesecurity.shift.ast.property.DataProperty;
import com.shapesecurity.shift.ast.property.Getter;
import com.shapesecurity.shift.ast.property.ObjectProperty;
import com.shapesecurity.shift.ast.property.PropertyName;
import com.shapesecurity.shift.ast.property.Setter;
import com.shapesecurity.shift.ast.statement.BlockStatement;
import com.shapesecurity.shift.ast.statement.BreakStatement;
import com.shapesecurity.shift.ast.statement.ContinueStatement;
import com.shapesecurity.shift.ast.statement.DebuggerStatement;
import com.shapesecurity.shift.ast.statement.DoWhileStatement;
import com.shapesecurity.shift.ast.statement.EmptyStatement;
import com.shapesecurity.shift.ast.statement.ExpressionStatement;
import com.shapesecurity.shift.ast.statement.ForInStatement;
import com.shapesecurity.shift.ast.statement.ForStatement;
import com.shapesecurity.shift.ast.statement.FunctionDeclaration;
import com.shapesecurity.shift.ast.statement.IfStatement;
import com.shapesecurity.shift.ast.statement.LabeledStatement;
import com.shapesecurity.shift.ast.statement.ReturnStatement;
import com.shapesecurity.shift.ast.statement.SwitchStatement;
import com.shapesecurity.shift.ast.statement.SwitchStatementWithDefault;
import com.shapesecurity.shift.ast.statement.ThrowStatement;
import com.shapesecurity.shift.ast.statement.TryCatchStatement;
import com.shapesecurity.shift.ast.statement.TryFinallyStatement;
import com.shapesecurity.shift.ast.statement.VariableDeclarationStatement;
import com.shapesecurity.shift.ast.statement.WhileStatement;
import com.shapesecurity.shift.ast.statement.WithStatement;
import com.shapesecurity.shift.path.Branch;
import com.shapesecurity.shift.path.IndexedBranch;
import com.shapesecurity.shift.path.StaticBranch;
import com.shapesecurity.shift.visitor.Reducer;
import com.shapesecurity.shift.visitor.ReducerP;
import org.jetbrains.annotations.NotNull;

public final class Director {
    private Director() {
    }

    @NotNull
    public static <State> State reduce(@NotNull Reducer<State> reducer, @NotNull Node node, @NotNull ImmutableList<Branch> path) {
        if (node instanceof Script) {
            return (State)Director.reduceScript(reducer, (Script)node, path);
        }
        if (node instanceof FunctionBody) {
            return (State)Director.reduceFunctionBody(reducer, (FunctionBody)node, path);
        }
        if (node instanceof ObjectProperty) {
            return (State)Director.reduceObjectProperty(reducer, (ObjectProperty)node, path);
        }
        if (node instanceof PropertyName) {
            return (State)Director.reducePropertyName(reducer, (PropertyName)node, path);
        }
        if (node instanceof Identifier) {
            return (State)Director.reduceIdentifier(reducer, (Identifier)node, path);
        }
        if (node instanceof Expression) {
            return (State)Director.reduceExpression(reducer, (Expression)node, path);
        }
        if (node instanceof Directive) {
            return (State)Director.reduceDirective(reducer, (Directive)node, path);
        }
        if (node instanceof Statement) {
            return (State)Director.reduceStatement(reducer, (Statement)node, path);
        }
        if (node instanceof Block) {
            return (State)Director.reduceBlock(reducer, (Block)node, path);
        }
        if (node instanceof VariableDeclarator) {
            return (State)Director.reduceVariableDeclarator(reducer, (VariableDeclarator)node, path);
        }
        if (node instanceof VariableDeclaration) {
            return (State)Director.reduceVariableDeclaration(reducer, (VariableDeclaration)node, path);
        }
        if (node instanceof SwitchCase) {
            return (State)Director.reduceSwitchCase(reducer, (SwitchCase)node, path);
        }
        if (node instanceof SwitchDefault) {
            return (State)Director.reduceSwitchDefault(reducer, (SwitchDefault)node, path);
        }
        if (node instanceof CatchClause) {
            return (State)Director.reduceCatchClause(reducer, (CatchClause)node, path);
        }
        throw new RuntimeException("not reached");
    }

    @NotNull
    private static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> Maybe<ExpressionState> reduceOptionExpression(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull Maybe<Expression> node, @NotNull ImmutableList<Branch> path) {
        NonEmptyImmutableList<Branch> just_path = path.cons(StaticBranch.JUST);
        return node.map(n -> Director.reduceExpression(reducer, n, just_path));
    }

    @NotNull
    private static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> Maybe<StatementState> reduceOptionStatement(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull Maybe<Statement> node, @NotNull ImmutableList<Branch> path) {
        NonEmptyImmutableList<Branch> just_path = path.cons(StaticBranch.JUST);
        return node.map(n -> Director.reduceStatement(reducer, n, just_path));
    }

    @NotNull
    private static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> ImmutableList<StatementState> reduceListStatement(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull ImmutableList<Statement> list, @NotNull ImmutableList<Branch> path) {
        return list.mapWithIndex((i, el) -> Director.reduceStatement(reducer, el, path.cons(IndexedBranch.from(i))));
    }

    @NotNull
    private static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> ImmutableList<ExpressionState> reduceListExpression(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull ImmutableList<Expression> list, @NotNull ImmutableList<Branch> path) {
        return list.mapWithIndex((i, el) -> Director.reduceExpression(reducer, el, path.cons(IndexedBranch.from(i))));
    }

    @NotNull
    private static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> ImmutableList<IdentifierState> reduceListIdentifier(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull ImmutableList<Identifier> list, @NotNull ImmutableList<Branch> path) {
        return list.mapWithIndex((i, el) -> Director.reduceIdentifier(reducer, el, path.cons(IndexedBranch.from(i))));
    }

    private static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> ImmutableList<DirectiveState> reducerListDirective(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull ImmutableList<Directive> directives, @NotNull ImmutableList<Branch> path) {
        return directives.mapWithIndex((i, el) -> Director.reduceDirective(reducer, el, path.cons(IndexedBranch.from(i))));
    }

    private static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> ImmutableList<PropertyState> reducerListProperty(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull ImmutableList<ObjectProperty> properties, @NotNull ImmutableList<Branch> path) {
        return properties.mapWithIndex((i, el) -> Director.reduceObjectProperty(reducer, el, path.cons(IndexedBranch.from(i))));
    }

    private static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> Either<DeclarationState, ExpressionState> reduceEitherVariableDeclarationExpression(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull Either<VariableDeclaration, Expression> node, @NotNull NonEmptyImmutableList<Branch> path) {
        return node.map(n -> Director.reduceVariableDeclaration(reducer, n, path.cons(StaticBranch.LEFT)), n -> Director.reduceExpression(reducer, n, path.cons(StaticBranch.RIGHT)));
    }

    private static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> ImmutableList<SwitchCaseState> reduceListSwitchCase(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull ImmutableList<SwitchCase> node, @NotNull NonEmptyImmutableList<Branch> path) {
        return node.mapWithIndex((i, el) -> Director.reduceSwitchCase(reducer, el, path.cons(IndexedBranch.from(i))));
    }

    private static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> Maybe<IdentifierState> reducerMaybeIdentifier(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull Maybe<Identifier> node, @NotNull NonEmptyImmutableList<Branch> path) {
        return node.map(n -> Director.reduceIdentifier(reducer, n, path.cons(StaticBranch.JUST)));
    }

    @NotNull
    public static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> ScriptState reduceScript(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull Script node, @NotNull ImmutableList<Branch> path) {
        return reducer.reduceScript(node, path, Director.reduceFunctionBody(reducer, node.body, path.cons(StaticBranch.BODY)));
    }

    @NotNull
    public static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> ProgramBodyState reduceFunctionBody(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull FunctionBody node, @NotNull ImmutableList<Branch> path) {
        return reducer.reduceFunctionBody(node, path, Director.reducerListDirective(reducer, node.directives, path.cons(StaticBranch.DIRECTIVES)), Director.reduceListStatement(reducer, node.statements, path.cons(StaticBranch.STATEMENTS)));
    }

    @NotNull
    public static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> PropertyState reduceObjectProperty(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull ObjectProperty node, @NotNull ImmutableList<Branch> path) {
        PropertyNameState nameState = Director.reducePropertyName(reducer, node.name, path.cons(StaticBranch.NAME));
        switch (node.type()) {
            case DataProperty: {
                DataProperty tNode = (DataProperty)node;
                return reducer.reduceDataProperty(tNode, path, nameState, Director.reduceExpression(reducer, tNode.value, path.cons(StaticBranch.VALUE)));
            }
            case Getter: {
                Getter tNode = (Getter)node;
                return reducer.reduceGetter(tNode, path, nameState, Director.reduceFunctionBody(reducer, tNode.body, path.cons(StaticBranch.BODY)));
            }
            case Setter: {
                Setter tNode = (Setter)node;
                return reducer.reduceSetter(tNode, path, nameState, Director.reduceIdentifier(reducer, tNode.parameter, path.cons(StaticBranch.PARAMETER)), Director.reduceFunctionBody(reducer, tNode.body, path.cons(StaticBranch.BODY)));
            }
        }
        throw new RuntimeException("Not reached");
    }

    @NotNull
    public static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> PropertyNameState reducePropertyName(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull PropertyName node, @NotNull ImmutableList<Branch> path) {
        return reducer.reducePropertyName(node, path);
    }

    @NotNull
    public static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> IdentifierState reduceIdentifier(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull Identifier node, @NotNull ImmutableList<Branch> path) {
        return reducer.reduceIdentifier(node, path);
    }

    @NotNull
    public static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> ExpressionState reduceExpression(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull Expression node, @NotNull ImmutableList<Branch> path) {
        switch (node.type()) {
            case FunctionExpression: {
                FunctionExpression tNode = (FunctionExpression)node;
                return reducer.reduceFunctionExpression(tNode, path, Director.reducerMaybeIdentifier(reducer, tNode.name, path.cons(StaticBranch.NAME)), Director.reduceListIdentifier(reducer, tNode.parameters, path.cons(StaticBranch.PARAMETERS)), Director.reduceFunctionBody(reducer, tNode.body, path.cons(StaticBranch.BODY)));
            }
            case LiteralBooleanExpression: {
                LiteralBooleanExpression tNode = (LiteralBooleanExpression)node;
                return reducer.reduceLiteralBooleanExpression(tNode, path);
            }
            case LiteralNullExpression: {
                LiteralNullExpression tNode = (LiteralNullExpression)node;
                return reducer.reduceLiteralNullExpression(tNode, path);
            }
            case LiteralInfinityExpression: {
                LiteralInfinityExpression tNode = (LiteralInfinityExpression)node;
                return reducer.reduceLiteralInfinityExpression(tNode, path);
            }
            case LiteralNumericExpression: {
                LiteralNumericExpression tNode = (LiteralNumericExpression)node;
                return reducer.reduceLiteralNumericExpression(tNode, path);
            }
            case LiteralRegExpExpression: {
                LiteralRegExpExpression tNode = (LiteralRegExpExpression)node;
                return reducer.reduceLiteralRegExpExpression(tNode, path);
            }
            case LiteralStringExpression: {
                LiteralStringExpression tNode = (LiteralStringExpression)node;
                return reducer.reduceLiteralStringExpression(tNode, path);
            }
            case ArrayExpression: {
                ArrayExpression tNode = (ArrayExpression)node;
                NonEmptyImmutableList<Branch> elementsPath = path.cons(StaticBranch.ELEMENTS);
                return reducer.reduceArrayExpression(tNode, path, tNode.elements.mapWithIndex((i, el) -> Director.reduceOptionExpression(reducer, el, elementsPath.cons(IndexedBranch.from(i)))));
            }
            case AssignmentExpression: {
                AssignmentExpression tNode = (AssignmentExpression)node;
                return reducer.reduceAssignmentExpression(tNode, path, Director.reduceExpression(reducer, tNode.binding, path.cons(StaticBranch.BINDING)), Director.reduceExpression(reducer, tNode.expression, path.cons(StaticBranch.EXPRESSION)));
            }
            case BinaryExpression: {
                BinaryExpression tNode = (BinaryExpression)node;
                return reducer.reduceBinaryExpression(tNode, path, Director.reduceExpression(reducer, tNode.left, path.cons(StaticBranch.LEFT)), Director.reduceExpression(reducer, tNode.right, path.cons(StaticBranch.RIGHT)));
            }
            case CallExpression: {
                CallExpression tNode = (CallExpression)node;
                return reducer.reduceCallExpression(tNode, path, Director.reduceExpression(reducer, tNode.callee, path.cons(StaticBranch.CALLEE)), Director.reduceListExpression(reducer, tNode.arguments, path.cons(StaticBranch.ARGUMENTS)));
            }
            case ComputedMemberExpression: {
                ComputedMemberExpression tNode = (ComputedMemberExpression)node;
                return reducer.reduceComputedMemberExpression(tNode, path, Director.reduceExpression(reducer, tNode.object, path.cons(StaticBranch.OBJECT)), Director.reduceExpression(reducer, tNode.expression, path.cons(StaticBranch.EXPRESSION)));
            }
            case ConditionalExpression: {
                ConditionalExpression tNode = (ConditionalExpression)node;
                return reducer.reduceConditionalExpression(tNode, path, Director.reduceExpression(reducer, tNode.test, path.cons(StaticBranch.TEST)), Director.reduceExpression(reducer, tNode.consequent, path.cons(StaticBranch.CONSEQUENT)), Director.reduceExpression(reducer, tNode.alternate, path.cons(StaticBranch.ALTERNATE)));
            }
            case IdentifierExpression: {
                IdentifierExpression tNode = (IdentifierExpression)node;
                return reducer.reduceIdentifierExpression(tNode, path, Director.reduceIdentifier(reducer, tNode.identifier, path.cons(StaticBranch.IDENTIFIER)));
            }
            case NewExpression: {
                NewExpression tNode = (NewExpression)node;
                return reducer.reduceNewExpression(tNode, path, Director.reduceExpression(reducer, tNode.callee, path.cons(StaticBranch.CALLEE)), Director.reduceListExpression(reducer, tNode.arguments, path.cons(StaticBranch.ARGUMENTS)));
            }
            case PostfixExpression: {
                PostfixExpression tNode = (PostfixExpression)node;
                return reducer.reducePostfixExpression(tNode, path, Director.reduceExpression(reducer, tNode.operand, path.cons(StaticBranch.OPERAND)));
            }
            case ObjectExpression: {
                ObjectExpression tNode = (ObjectExpression)node;
                return reducer.reduceObjectExpression(tNode, path, Director.reducerListProperty(reducer, tNode.properties, path.cons(StaticBranch.PROPERTIES)));
            }
            case PrefixExpression: {
                PrefixExpression tNode = (PrefixExpression)node;
                return reducer.reducePrefixExpression(tNode, path, Director.reduceExpression(reducer, tNode.operand, path.cons(StaticBranch.OPERAND)));
            }
            case StaticMemberExpression: {
                StaticMemberExpression tNode = (StaticMemberExpression)node;
                return reducer.reduceStaticMemberExpression(tNode, path, Director.reduceExpression(reducer, tNode.object, path.cons(StaticBranch.OBJECT)), Director.reduceIdentifier(reducer, tNode.property, path.cons(StaticBranch.PROPERTY)));
            }
            case ThisExpression: {
                ThisExpression tNode = (ThisExpression)node;
                return reducer.reduceThisExpression(tNode, path);
            }
        }
        throw new RuntimeException("Not reached");
    }

    @NotNull
    public static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> DirectiveState reduceDirective(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull Directive node, @NotNull ImmutableList<Branch> path) {
        if (node instanceof UseStrictDirective) {
            return reducer.reduceUseStrictDirective((UseStrictDirective)node, path);
        }
        return reducer.reduceUnknownDirective((UnknownDirective)node, path);
    }

    @NotNull
    public static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> StatementState reduceStatement(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull Statement node, @NotNull ImmutableList<Branch> path) {
        switch (node.type()) {
            case FunctionDeclaration: {
                FunctionDeclaration tNode = (FunctionDeclaration)node;
                return reducer.reduceFunctionDeclaration(tNode, path, Director.reduceIdentifier(reducer, tNode.name, path.cons(StaticBranch.NAME)), Director.reduceListIdentifier(reducer, tNode.parameters, path.cons(StaticBranch.PARAMETERS)), Director.reduceFunctionBody(reducer, tNode.body, path.cons(StaticBranch.BODY)));
            }
            case BlockStatement: {
                BlockStatement tNode = (BlockStatement)node;
                return reducer.reduceBlockStatement(tNode, path, Director.reduceBlock(reducer, tNode.block, path.cons(StaticBranch.BLOCK)));
            }
            case BreakStatement: {
                BreakStatement tNode = (BreakStatement)node;
                return reducer.reduceBreakStatement(tNode, path, tNode.label.map(n -> Director.reduceIdentifier(reducer, n, path.cons(StaticBranch.LABEL).cons(StaticBranch.JUST))));
            }
            case ContinueStatement: {
                ContinueStatement tNode = (ContinueStatement)node;
                return reducer.reduceContinueStatement(tNode, path, tNode.label.map(n -> Director.reduceIdentifier(reducer, n, path.cons(StaticBranch.LABEL).cons(StaticBranch.JUST))));
            }
            case DebuggerStatement: {
                DebuggerStatement tNode = (DebuggerStatement)node;
                return reducer.reduceDebuggerStatement(tNode, path);
            }
            case DoWhileStatement: {
                DoWhileStatement tNode = (DoWhileStatement)node;
                return reducer.reduceDoWhileStatement(tNode, path, Director.reduceStatement(reducer, tNode.body, path.cons(StaticBranch.BODY)), Director.reduceExpression(reducer, tNode.test, path.cons(StaticBranch.TEST)));
            }
            case EmptyStatement: {
                EmptyStatement tNode = (EmptyStatement)node;
                return reducer.reduceEmptyStatement(tNode, path);
            }
            case ExpressionStatement: {
                ExpressionStatement tNode = (ExpressionStatement)node;
                return reducer.reduceExpressionStatement(tNode, path, Director.reduceExpression(reducer, tNode.expression, path.cons(StaticBranch.EXPRESSION)));
            }
            case ForInStatement: {
                ForInStatement tNode = (ForInStatement)node;
                NonEmptyImmutableList<Branch> inner_path = path.cons(StaticBranch.LEFT);
                Either<VariableDeclaration, Expression> left_node = tNode.left;
                return reducer.reduceForInStatement(tNode, path, Director.reduceEitherVariableDeclarationExpression(reducer, left_node, inner_path), Director.reduceExpression(reducer, tNode.right, path.cons(StaticBranch.RIGHT)), Director.reduceStatement(reducer, tNode.body, path.cons(StaticBranch.BODY)));
            }
            case ForStatement: {
                ForStatement tNode = (ForStatement)node;
                NonEmptyImmutableList<StaticBranch> inner_path = path.cons(StaticBranch.INIT).cons(StaticBranch.JUST);
                return reducer.reduceForStatement(tNode, path, tNode.init.map(init -> Director.reduceEitherVariableDeclarationExpression(reducer, init, inner_path)), Director.reduceOptionExpression(reducer, tNode.test, path.cons(StaticBranch.TEST)), Director.reduceOptionExpression(reducer, tNode.update, path.cons(StaticBranch.UPDATE)), Director.reduceStatement(reducer, tNode.body, path.cons(StaticBranch.BODY)));
            }
            case IfStatement: {
                IfStatement tNode = (IfStatement)node;
                return reducer.reduceIfStatement(tNode, path, Director.reduceExpression(reducer, tNode.test, path.cons(StaticBranch.TEST)), Director.reduceStatement(reducer, tNode.consequent, path.cons(StaticBranch.CONSEQUENT)), Director.reduceOptionStatement(reducer, tNode.alternate, path.cons(StaticBranch.ALTERNATE)));
            }
            case LabeledStatement: {
                LabeledStatement tNode = (LabeledStatement)node;
                return reducer.reduceLabeledStatement(tNode, path, Director.reduceIdentifier(reducer, tNode.label, path.cons(StaticBranch.LABEL)), Director.reduceStatement(reducer, tNode.body, path.cons(StaticBranch.BODY)));
            }
            case ReturnStatement: {
                ReturnStatement tNode = (ReturnStatement)node;
                return reducer.reduceReturnStatement(tNode, path, Director.reduceOptionExpression(reducer, tNode.expression, path.cons(StaticBranch.EXPRESSION)));
            }
            case SwitchStatement: {
                SwitchStatement tNode = (SwitchStatement)node;
                return reducer.reduceSwitchStatement(tNode, path, Director.reduceExpression(reducer, tNode.discriminant, path.cons(StaticBranch.DISCRIMINANT)), Director.reduceListSwitchCase(reducer, tNode.cases, path.cons(StaticBranch.CASES)));
            }
            case SwitchStatementWithDefault: {
                SwitchStatementWithDefault tNode = (SwitchStatementWithDefault)node;
                return reducer.reduceSwitchStatementWithDefault(tNode, path, Director.reduceExpression(reducer, tNode.discriminant, path.cons(StaticBranch.DISCRIMINANT)), Director.reduceListSwitchCase(reducer, tNode.preDefaultCases, path.cons(StaticBranch.PREDEFAULTCASES)), Director.reduceSwitchDefault(reducer, tNode.defaultCase, path.cons(StaticBranch.DEFAULTCASE)), Director.reduceListSwitchCase(reducer, tNode.postDefaultCases, path.cons(StaticBranch.POSTDEFAULTCASES)));
            }
            case ThrowStatement: {
                ThrowStatement tNode = (ThrowStatement)node;
                return reducer.reduceThrowStatement(tNode, path, Director.reduceExpression(reducer, tNode.expression, path.cons(StaticBranch.EXPRESSION)));
            }
            case TryCatchStatement: {
                TryCatchStatement tNode = (TryCatchStatement)node;
                return reducer.reduceTryCatchStatement(tNode, path, Director.reduceBlock(reducer, tNode.body, path.cons(StaticBranch.BODY)), Director.reduceCatchClause(reducer, tNode.catchClause, path.cons(StaticBranch.CATCHCLAUSE)));
            }
            case TryFinallyStatement: {
                TryFinallyStatement tNode = (TryFinallyStatement)node;
                return reducer.reduceTryFinallyStatement(tNode, path, Director.reduceBlock(reducer, tNode.body, path.cons(StaticBranch.BODY)), tNode.catchClause.map(n -> Director.reduceCatchClause(reducer, n, path.cons(StaticBranch.CATCHCLAUSE).cons(StaticBranch.JUST))), Director.reduceBlock(reducer, tNode.finalizer, path.cons(StaticBranch.FINALIZER)));
            }
            case VariableDeclarationStatement: {
                VariableDeclarationStatement tNode = (VariableDeclarationStatement)node;
                return reducer.reduceVariableDeclarationStatement(tNode, path, Director.reduceVariableDeclaration(reducer, tNode.declaration, path.cons(StaticBranch.DECLARATION)));
            }
            case WhileStatement: {
                WhileStatement tNode = (WhileStatement)node;
                return reducer.reduceWhileStatement(tNode, path, Director.reduceExpression(reducer, tNode.test, path.cons(StaticBranch.TEST)), Director.reduceStatement(reducer, tNode.body, path.cons(StaticBranch.BODY)));
            }
            case WithStatement: {
                WithStatement tNode = (WithStatement)node;
                return reducer.reduceWithStatement(tNode, path, Director.reduceExpression(reducer, tNode.object, path.cons(StaticBranch.OBJECT)), Director.reduceStatement(reducer, tNode.body, path.cons(StaticBranch.BODY)));
            }
        }
        throw new RuntimeException("Not reached");
    }

    @NotNull
    public static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> BlockState reduceBlock(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull Block node, @NotNull ImmutableList<Branch> path) {
        return reducer.reduceBlock(node, path, Director.reduceListStatement(reducer, node.statements, path.cons(StaticBranch.STATEMENTS)));
    }

    @NotNull
    public static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> DeclaratorState reduceVariableDeclarator(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull VariableDeclarator node, @NotNull ImmutableList<Branch> path) {
        return reducer.reduceVariableDeclarator(node, path, Director.reduceIdentifier(reducer, node.binding, path.cons(StaticBranch.BINDING)), Director.reduceOptionExpression(reducer, node.init, path.cons(StaticBranch.INIT)));
    }

    @NotNull
    public static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> DeclarationState reduceVariableDeclaration(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull VariableDeclaration node, @NotNull ImmutableList<Branch> path) {
        NonEmptyImmutableList<Branch> declsPath = path.cons(StaticBranch.DECLARATORS);
        return reducer.reduceVariableDeclaration(node, path, (NonEmptyImmutableList<DeclaratorState>)node.declarators.mapWithIndex((i, el) -> Director.reduceVariableDeclarator(reducer, el, declsPath.cons(IndexedBranch.from(i)))));
    }

    @NotNull
    public static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> SwitchCaseState reduceSwitchCase(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull SwitchCase node, @NotNull ImmutableList<Branch> path) {
        return reducer.reduceSwitchCase(node, path, Director.reduceExpression(reducer, node.test, path.cons(StaticBranch.TEST)), Director.reduceListStatement(reducer, node.consequent, path.cons(StaticBranch.CONSEQUENT)));
    }

    @NotNull
    public static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> SwitchDefaultState reduceSwitchDefault(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull SwitchDefault node, @NotNull ImmutableList<Branch> path) {
        return reducer.reduceSwitchDefault(node, path, Director.reduceListStatement(reducer, node.consequent, path.cons(StaticBranch.CONSEQUENT)));
    }

    @NotNull
    public static <ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> CatchClauseState reduceCatchClause(@NotNull ReducerP<ScriptState, ProgramBodyState, PropertyState, PropertyNameState, IdentifierState, ExpressionState, DirectiveState, StatementState, BlockState, DeclaratorState, DeclarationState, SwitchCaseState, SwitchDefaultState, CatchClauseState> reducer, @NotNull CatchClause node, @NotNull ImmutableList<Branch> path) {
        return reducer.reduceCatchClause(node, path, Director.reduceIdentifier(reducer, node.binding, path.cons(StaticBranch.BINDING)), Director.reduceBlock(reducer, node.body, path.cons(StaticBranch.BODY)));
    }
}

