/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.validator;

import com.shapesecurity.functional.data.Either;
import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.functional.data.Maybe;
import com.shapesecurity.shift.ast.CatchClause;
import com.shapesecurity.shift.ast.FunctionBody;
import com.shapesecurity.shift.ast.Identifier;
import com.shapesecurity.shift.ast.Script;
import com.shapesecurity.shift.ast.VariableDeclarator;
import com.shapesecurity.shift.ast.expression.AssignmentExpression;
import com.shapesecurity.shift.ast.expression.FunctionExpression;
import com.shapesecurity.shift.ast.expression.IdentifierExpression;
import com.shapesecurity.shift.ast.expression.LiteralNumericExpression;
import com.shapesecurity.shift.ast.expression.ObjectExpression;
import com.shapesecurity.shift.ast.expression.PrefixExpression;
import com.shapesecurity.shift.ast.expression.StaticMemberExpression;
import com.shapesecurity.shift.ast.operators.PrefixOperator;
import com.shapesecurity.shift.ast.property.Getter;
import com.shapesecurity.shift.ast.property.ObjectProperty;
import com.shapesecurity.shift.ast.property.PropertyName;
import com.shapesecurity.shift.ast.property.Setter;
import com.shapesecurity.shift.ast.statement.BreakStatement;
import com.shapesecurity.shift.ast.statement.ContinueStatement;
import com.shapesecurity.shift.ast.statement.DoWhileStatement;
import com.shapesecurity.shift.ast.statement.ForInStatement;
import com.shapesecurity.shift.ast.statement.ForStatement;
import com.shapesecurity.shift.ast.statement.FunctionDeclaration;
import com.shapesecurity.shift.ast.statement.LabeledStatement;
import com.shapesecurity.shift.ast.statement.ReturnStatement;
import com.shapesecurity.shift.ast.statement.SwitchStatement;
import com.shapesecurity.shift.ast.statement.SwitchStatementWithDefault;
import com.shapesecurity.shift.ast.statement.WhileStatement;
import com.shapesecurity.shift.ast.statement.WithStatement;
import com.shapesecurity.shift.path.Branch;
import com.shapesecurity.shift.utils.Utils;
import com.shapesecurity.shift.validator.ValidationContext;
import com.shapesecurity.shift.validator.ValidationError;
import com.shapesecurity.shift.visitor.MonoidalReducer;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class Validator
extends MonoidalReducer<ValidationContext> {
    public Validator() {
        super(ValidationContext.MONOID);
    }

    public static ImmutableList<ValidationError> validate(Script node) {
        return node.reduce(new Validator()).errors.toList();
    }

    @Override
    @NotNull
    public ValidationContext reduceBreakStatement(@NotNull BreakStatement node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<ValidationContext> label) {
        ValidationContext v = super.reduceBreakStatement(node, path, label);
        return node.label.maybe(v.addFreeBreakStatement(new ValidationError(node, "break must be nested within switch or iteration statement")), v::addFreeJumpTarget);
    }

    @Override
    @NotNull
    public ValidationContext reduceAssignmentExpression(@NotNull AssignmentExpression node, @NotNull ImmutableList<Branch> path, @NotNull ValidationContext binding, @NotNull ValidationContext expression) {
        ValidationContext v = super.reduceAssignmentExpression(node, path, binding, expression);
        if (node.binding instanceof IdentifierExpression) {
            v = v.checkRestricted(((IdentifierExpression)node.binding).identifier);
        }
        return v;
    }

    @Override
    @NotNull
    public ValidationContext reduceCatchClause(@NotNull CatchClause node, @NotNull ImmutableList<Branch> path, @NotNull ValidationContext binding, @NotNull ValidationContext body) {
        ValidationContext v = super.reduceCatchClause(node, path, binding, body);
        return v.checkRestricted(node.binding);
    }

    @Override
    @NotNull
    public ValidationContext reduceContinueStatement(@NotNull ContinueStatement node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<ValidationContext> label) {
        ValidationContext v = super.reduceContinueStatement(node, path, label).addFreeContinueStatement(node);
        return node.label.maybe(v, v::addFreeJumpTarget);
    }

    @Override
    @NotNull
    public ValidationContext reduceDoWhileStatement(@NotNull DoWhileStatement node, @NotNull ImmutableList<Branch> path, @NotNull ValidationContext body, @NotNull ValidationContext test) {
        return super.reduceDoWhileStatement(node, path, body, test).clearFreeContinueStatements().clearFreeBreakStatements();
    }

    @Override
    @NotNull
    public ValidationContext reduceFunctionDeclaration(@NotNull FunctionDeclaration node, @NotNull ImmutableList<Branch> path, @NotNull ValidationContext name, @NotNull ImmutableList<ValidationContext> params, @NotNull ValidationContext programBody) {
        ValidationContext v = super.reduceFunctionDeclaration(node, path, name, params, programBody).clearUsedLabelNames().clearReturnStatements().clearUsedLabelNames();
        if (!Utils.areUniqueNames(node.parameters)) {
            v = v.addStrictError(new ValidationError(node, "FunctionDeclaration must have unique parameter names"));
        }
        v = node.parameters.foldLeft(ValidationContext::checkRestricted, v.checkRestricted(node.name));
        if (node.body.isStrict()) {
            v = v.invalidateStrictErrors();
        }
        return v;
    }

    @Override
    @NotNull
    public ValidationContext reduceFunctionExpression(@NotNull FunctionExpression node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<ValidationContext> name, @NotNull ImmutableList<ValidationContext> parameters, @NotNull ValidationContext programBody) {
        ValidationContext v = super.reduceFunctionExpression(node, path, name, parameters, programBody).clearReturnStatements();
        if (!Utils.areUniqueNames(node.parameters)) {
            v = v.addStrictError(new ValidationError(node, "FunctionExpression parameter names must be unique"));
        }
        v = node.parameters.foldLeft(ValidationContext::checkRestricted, node.name.map(v::checkRestricted).orJust(v));
        if (node.body.isStrict()) {
            v = v.invalidateStrictErrors();
        }
        return v;
    }

    @Override
    @NotNull
    public ValidationContext reduceIdentifier(@NotNull Identifier node, @NotNull ImmutableList<Branch> path) {
        ValidationContext v = new ValidationContext();
        if (!Utils.isValidIdentifierName(node.name)) {
            v = v.addError(new ValidationError(node, "Identifier `name` must be a valid IdentifierName"));
        }
        return v;
    }

    @Override
    @NotNull
    public ValidationContext reduceIdentifierExpression(@NotNull IdentifierExpression node, @NotNull ImmutableList<Branch> path, @NotNull ValidationContext identifier) {
        return super.reduceIdentifierExpression(node, path, identifier).checkReserved(node.identifier);
    }

    @Override
    @NotNull
    public ValidationContext reduceForInStatement(@NotNull ForInStatement node, @NotNull ImmutableList<Branch> path, @NotNull Either<ValidationContext, ValidationContext> left, @NotNull ValidationContext right, @NotNull ValidationContext body) {
        ValidationContext v = super.reduceForInStatement(node, path, left, right, body).clearFreeBreakStatements().clearFreeContinueStatements();
        if (node.left.isLeft() && !node.left.left().just().declarators.tail().isEmpty()) {
            v = v.addError(new ValidationError(node.left.left().just(), "VariableDeclarationStatement in ForInVarStatement contains more than one VariableDeclarator"));
        }
        return v;
    }

    @Override
    @NotNull
    public ValidationContext reduceForStatement(@NotNull ForStatement node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<Either<ValidationContext, ValidationContext>> init, @NotNull Maybe<ValidationContext> test, @NotNull Maybe<ValidationContext> update, @NotNull ValidationContext body) {
        return super.reduceForStatement(node, path, init, test, update, body).clearFreeBreakStatements().clearFreeContinueStatements();
    }

    @Override
    @NotNull
    public ValidationContext reduceLabeledStatement(@NotNull LabeledStatement node, @NotNull ImmutableList<Branch> path, @NotNull ValidationContext label, @NotNull ValidationContext body) {
        return super.reduceLabeledStatement(node, path, label, body).observeLabelName(node.label);
    }

    @Override
    @NotNull
    public ValidationContext reduceLiteralNumericExpression(@NotNull LiteralNumericExpression node, @NotNull ImmutableList<Branch> path) {
        ValidationContext v = new ValidationContext();
        if (node.value < 0.0 || node.value == 0.0 && 1.0 / node.value < 0.0) {
            v = v.addError(new ValidationError(node, "Numeric Literal node must be non-negative"));
        } else if (Double.isNaN(node.value)) {
            v = v.addError(new ValidationError(node, "Numeric Literal node must not be NaN"));
        } else if (Double.isInfinite(node.value)) {
            v = v.addError(new ValidationError(node, "Numeric Literal node must be finite"));
        }
        return v;
    }

    @Override
    @NotNull
    public ValidationContext reduceObjectExpression(@NotNull ObjectExpression node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<ValidationContext> properties) {
        ValidationContext v = super.reduceObjectExpression(node, path, properties);
        HashSet<String> setKeys = new HashSet<String>();
        HashSet<String> getKeys = new HashSet<String>();
        HashSet<String> dataKeys = new HashSet<String>();
        for (ObjectProperty p : node.properties) {
            String key = p.name.value;
            switch (p.getKind()) {
                case InitProperty: {
                    if (dataKeys.contains(key)) {
                        v = v.addStrictError(new ValidationError(node, "ObjectExpression must not have more that one data property with the same name"));
                    }
                    if (getKeys.contains(key)) {
                        v = v.addError(new ValidationError(node, "ObjectExpression must not have data and getter properties with same name"));
                    }
                    if (setKeys.contains(key)) {
                        v = v.addError(new ValidationError(node, "ObjectExpression must not have data and setter properties with same name"));
                    }
                    dataKeys.add(key);
                    break;
                }
                case GetterProperty: {
                    if (getKeys.contains(key)) {
                        v = v.addError(new ValidationError(node, "ObjectExpression must not have multiple getters with the same name"));
                    }
                    if (dataKeys.contains(key)) {
                        v = v.addError(new ValidationError(node, "ObjectExpression must not have data and getter properties with the same name"));
                    }
                    getKeys.add(key);
                    break;
                }
                case SetterProperty: {
                    if (setKeys.contains(key)) {
                        v = v.addError(new ValidationError(node, "ObjectExpression must not have multiple setters with the same name"));
                    }
                    if (dataKeys.contains(key)) {
                        v = v.addError(new ValidationError(node, "ObjectExpression must not have data and setter properties with the same name"));
                    }
                    setKeys.add(key);
                    break;
                }
            }
        }
        return v;
    }

    @Override
    @NotNull
    public ValidationContext reducePrefixExpression(@NotNull PrefixExpression node, @NotNull ImmutableList<Branch> path, @NotNull ValidationContext operand) {
        ValidationContext v = super.reducePrefixExpression(node, path, operand);
        if (node.operator == PrefixOperator.Delete && node.operand instanceof IdentifierExpression) {
            return v.addStrictError(new ValidationError(node, "`delete` with unqualified identifier not allowed in strict mode"));
        }
        return v;
    }

    @Override
    @NotNull
    public ValidationContext reduceScript(@NotNull Script node, @NotNull ImmutableList<Branch> path, @NotNull ValidationContext body) {
        return super.reduceScript(node, path, body).invalidateFreeReturnErrors();
    }

    @Override
    @NotNull
    public ValidationContext reduceFunctionBody(@NotNull FunctionBody node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<ValidationContext> directives, @NotNull ImmutableList<ValidationContext> statements) {
        ValidationContext v = super.reduceFunctionBody(node, path, directives, statements).checkFreeJumpTargets();
        if (node.isStrict()) {
            v = v.invalidateStrictErrors();
        }
        return v.invalidateFreeContinueAndBreakErrors();
    }

    @Override
    @NotNull
    public ValidationContext reduceReturnStatement(@NotNull ReturnStatement node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<ValidationContext> expression) {
        return super.reduceReturnStatement(node, path, expression).addFreeReturnStatement(node);
    }

    @Override
    @NotNull
    public ValidationContext reduceSetter(@NotNull Setter node, @NotNull ImmutableList<Branch> path, @NotNull ValidationContext name, @NotNull ValidationContext param, @NotNull ValidationContext body) {
        return super.reduceSetter(node, path, name, param, body).checkRestricted(node.parameter).clearReturnStatements();
    }

    @Override
    @NotNull
    public ValidationContext reduceGetter(@NotNull Getter node, @NotNull ImmutableList<Branch> path, @NotNull ValidationContext name, @NotNull ValidationContext body) {
        return super.reduceGetter(node, path, name, body).clearReturnStatements();
    }

    @Override
    @NotNull
    public ValidationContext reduceSwitchStatement(@NotNull SwitchStatement node, @NotNull ImmutableList<Branch> path, @NotNull ValidationContext discriminant, @NotNull ImmutableList<ValidationContext> cases) {
        return super.reduceSwitchStatement(node, path, discriminant, cases).clearFreeBreakStatements();
    }

    @Override
    @NotNull
    public ValidationContext reduceSwitchStatementWithDefault(@NotNull SwitchStatementWithDefault node, @NotNull ImmutableList<Branch> path, @NotNull ValidationContext discriminant, @NotNull ImmutableList<ValidationContext> preDefaultCases, @NotNull ValidationContext defaultCase, @NotNull ImmutableList<ValidationContext> postDefaultCases) {
        return super.reduceSwitchStatementWithDefault(node, path, discriminant, preDefaultCases, defaultCase, postDefaultCases).clearFreeBreakStatements();
    }

    @Override
    @NotNull
    public ValidationContext reduceVariableDeclarator(@NotNull VariableDeclarator node, @NotNull ImmutableList<Branch> path, @NotNull ValidationContext binding, @NotNull Maybe<ValidationContext> init) {
        return super.reduceVariableDeclarator(node, path, binding, init).checkRestricted(node.binding);
    }

    @Override
    @NotNull
    public ValidationContext reduceWhileStatement(@NotNull WhileStatement node, @NotNull ImmutableList<Branch> path, @NotNull ValidationContext test, @NotNull ValidationContext body) {
        return super.reduceWhileStatement(node, path, test, body).clearFreeBreakStatements().clearFreeContinueStatements();
    }

    @Override
    @NotNull
    public ValidationContext reduceWithStatement(@NotNull WithStatement node, @NotNull ImmutableList<Branch> path, @NotNull ValidationContext object, @NotNull ValidationContext body) {
        return super.reduceWithStatement(node, path, object, body).addStrictError(new ValidationError(node, "WithStatement not allowed in strict mode"));
    }

    @Override
    @NotNull
    public ValidationContext reduceStaticMemberExpression(@NotNull StaticMemberExpression node, @NotNull ImmutableList<Branch> path, @NotNull ValidationContext object, @NotNull ValidationContext property) {
        return super.reduceStaticMemberExpression(node, path, object, property.clearIdentifierNameError());
    }

    @Override
    @NotNull
    public ValidationContext reducePropertyName(@NotNull PropertyName node, @NotNull ImmutableList<Branch> path) {
        ValidationContext v = (ValidationContext)super.reducePropertyName(node, path);
        switch (node.kind) {
            case Identifier: {
                if (Utils.isValidIdentifierName(node.value)) break;
                return v.addError(new ValidationError(node, "PropertyName of kind 'identifier' must be valid identifier name."));
            }
            case Number: {
                if (Utils.isValidNumber(node.value)) break;
                return v.addError(new ValidationError(node, "PropertyName of kind 'number' must be a valid number literal."));
            }
        }
        return v;
    }
}

