/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.utils;

import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.shift.ast.Identifier;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class Utils {
    private static final int IDENT_PART_MASK = 8390526;

    private Utils() {
    }

    public static boolean isRestrictedWord(@NotNull String name) {
        return "eval".equals(name) || "arguments".equals(name);
    }

    public static boolean isValidIdentifierName(@NotNull String name) {
        if (name.isEmpty()) {
            return false;
        }
        if (!Utils.isIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Utils.isIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean areUniqueNames(@NotNull ImmutableList<Identifier> list) {
        HashSet<String> paramSet = new HashSet<String>();
        for (Identifier item : list) {
            if (paramSet.contains(item.name)) {
                return false;
            }
            paramSet.add(item.name);
        }
        return true;
    }

    @NotNull
    public static String escapeStringLiteral(@NotNull String stringValue) {
        char[] chars;
        StringBuilder result = new StringBuilder();
        result.append('\"');
        block12: for (char ch : chars = stringValue.toCharArray()) {
            switch (ch) {
                case '\b': {
                    result.append("\\b");
                    continue block12;
                }
                case '\t': {
                    result.append("\\t");
                    continue block12;
                }
                case '\n': {
                    result.append("\\n");
                    continue block12;
                }
                case '\u000b': {
                    result.append("\\v");
                    continue block12;
                }
                case '\f': {
                    result.append("\\f");
                    continue block12;
                }
                case '\r': {
                    result.append("\\r");
                    continue block12;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block12;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block12;
                }
                case '\u2028': {
                    result.append("\\u2028");
                    continue block12;
                }
                case '\u2029': {
                    result.append("\\u2029");
                    continue block12;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        result.append('\"');
        return result.toString();
    }

    public static boolean isReservedWordES5(@NotNull String word) {
        switch (word) {
            case "break": 
            case "case": 
            case "catch": 
            case "class": 
            case "const": 
            case "continue": 
            case "debugger": 
            case "default": 
            case "delete": 
            case "do": 
            case "else": 
            case "enum": 
            case "export": 
            case "extends": 
            case "finally": 
            case "for": 
            case "function": 
            case "if": 
            case "import": 
            case "in": 
            case "instanceof": 
            case "new": 
            case "return": 
            case "super": 
            case "switch": 
            case "this": 
            case "throw": 
            case "try": 
            case "typeof": 
            case "var": 
            case "void": 
            case "while": 
            case "with": {
                return true;
            }
        }
        return false;
    }

    public static boolean isStrictModeReservedWordES5(@NotNull String word) {
        switch (word) {
            case "implements": 
            case "interface": 
            case "package": 
            case "protected": 
            case "public": 
            case "static": 
            case "let": 
            case "yield": {
                return true;
            }
        }
        return Utils.isReservedWordES5(word);
    }

    public static boolean isDecimalDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    public static boolean isLineTerminator(char ch) {
        return ch == '\r' || ch == '\n' || ch == '\u2028' || ch == '\u2029';
    }

    public static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\u000b' || ch == '\f' || ch == '\u00a0' || ch >= '\u1680' && (ch == '\u1680' || ch == '\u180e' || '\u2000' <= ch && ch <= '\u200a' || ch == '\u202f' || ch == '\u205f' || ch == '\u3000' || ch == '\ufeff');
    }

    public static boolean isIdentifierStart(char ch) {
        if (ch < '\u0080') {
            return Character.isJavaIdentifierStart(ch);
        }
        return Character.isAlphabetic(ch);
    }

    public static boolean isIdentifierPart(char ch) {
        if (ch < '\u0080') {
            return Character.isJavaIdentifierPart(ch);
        }
        return (8390526 >> Character.getType(ch) & 1) != 0 || ch == '\u200c' || ch == '\u200d';
    }

    public static int getHexValue(char rune) {
        if ('0' <= rune && rune <= '9') {
            return rune - 48;
        }
        if ('a' <= rune && rune <= 'f') {
            return rune - 97 + 10;
        }
        if ('A' <= rune && rune <= 'F') {
            return rune - 65 + 10;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValidNumber(@NotNull String source) {
        int index = 0;
        int length = source.length();
        char[] chs = source.toCharArray();
        char ch = chs[index];
        if (ch == '0') {
            if (++index >= length) return true;
            ch = chs[index];
            if (ch == 'x') return Utils.isValidHexLiteral(chs);
            if (ch == 'X') {
                return Utils.isValidHexLiteral(chs);
            }
            if ('0' <= ch && ch <= '9') {
                return Utils.isValidOctalLiteral(chs);
            }
        } else if ('1' <= ch && ch <= '9') {
            ch = chs[index];
            while ('0' <= ch && ch <= '9') {
                if (++index == length) {
                    return true;
                }
                ch = chs[index];
            }
        } else if (ch != '.') {
            return false;
        }
        if (ch == '.') {
            if (++index == length) {
                return true;
            }
            ch = chs[index];
            while ('0' <= ch && ch <= '9') {
                if (++index == length) {
                    return true;
                }
                ch = chs[index];
            }
        }
        if (ch == 'e' || ch == 'E') {
            if (++index == length) {
                return false;
            }
            ch = chs[index];
            if (ch == '+' || ch == '-') {
                if (++index == length) {
                    return false;
                }
                ch = chs[index];
            }
            if ('0' > ch) return false;
            if (ch > '9') return false;
            while ('0' <= ch && ch <= '9') {
                if (++index == length) {
                    return true;
                }
                ch = chs[index];
            }
        }
        if (index == length) return false;
        return true;
    }

    private static boolean isValidOctalLiteral(char[] chs) {
        for (int i = 1; i < chs.length; ++i) {
            if (chs[i] >= '0' && chs[i] <= '7') continue;
            return false;
        }
        return true;
    }

    private static boolean isValidHexLiteral(char[] chs) {
        for (int i = 1; i < chs.length; ++i) {
            if (Utils.getHexValue(chs[i]) >= 0) continue;
            return false;
        }
        return true;
    }
}

