/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.utils;

import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;

public final class D2A {
    private static final BigInteger FIVE = BigInteger.valueOf(5L);

    private D2A() {
    }

    private static BigInteger power(@NotNull BigInteger b, int p) {
        BigInteger result;
        if (p == 0) {
            result = BigInteger.ONE;
        } else if (p == 1) {
            result = new BigInteger(b.toByteArray());
        } else {
            result = D2A.power(b, p >> 1);
            result = result.multiply(result);
            if ((p & 1) != 0) {
                result = result.multiply(b);
            }
        }
        return result;
    }

    @NotNull
    private static String digitTrim(@NotNull BigInteger value, @NotNull String strValue, @NotNull BigInteger err) {
        if (err.signum() == 0) {
            return strValue;
        }
        BigInteger digit = BigInteger.TEN.pow((int)Math.ceil((double)value.bitLength() * 0.3010299956639812));
        BigInteger half = digit.shiftRight(1);
        while (digit.signum() > 0) {
            BigInteger mod;
            BigInteger addHalf = value.add(half);
            BigInteger trimmed = addHalf.subtract(mod = addHalf.mod(digit));
            if (trimmed.subtract(value).abs().compareTo(err) <= 0) {
                return trimmed.toString();
            }
            digit = digit.divide(BigInteger.TEN);
            half = digit.shiftRight(1);
        }
        return strValue;
    }

    @NotNull
    private static DtoAInfo formatNumberHelper(double number) {
        long mantle;
        int exp;
        long p = Double.doubleToRawLongBits(number);
        long shift = p >>> 52;
        if (shift == 0L) {
            exp = -1074;
            mantle = p;
        } else {
            exp = (int)(shift - 1023L - 52L);
            mantle = p & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        }
        BigInteger bMantle = BigInteger.valueOf(mantle);
        BigInteger err = BigInteger.ONE;
        if (exp >= 0) {
            bMantle = bMantle.shiftLeft(exp);
            err = err.shiftLeft(exp);
        } else {
            BigInteger power = D2A.power(FIVE, -exp);
            bMantle = bMantle.multiply(power);
            err = err.multiply(power);
        }
        err = err.shiftRight(1);
        String original = bMantle.toString();
        int length = Math.min(0, exp) - 1 + original.length();
        String trimmed = D2A.digitTrim(bMantle, original, err);
        return new DtoAInfo(trimmed, length + trimmed.length() - original.length());
    }

    @NotNull
    public static String d2a(double number) {
        if (Double.isNaN(number)) {
            return "NaN";
        }
        if (number == 0.0) {
            return "0";
        }
        if (number < 0.0) {
            return '-' + D2A.d2a(-number);
        }
        if (Double.isInfinite(number)) {
            return "Infinity";
        }
        DtoAInfo info = D2A.formatNumberHelper(number);
        if (info.exp >= 21 || info.exp <= -7) {
            String part2 = info.digits.substring(1);
            while (!part2.isEmpty() && part2.charAt(part2.length() - 1) == '0') {
                part2 = part2.substring(0, part2.length() - 1);
            }
            return info.digits.substring(0, 1) + (part2.isEmpty() ? "" : '.' + part2) + (info.exp > 0 ? "e+" : "e") + info.exp;
        }
        if (info.exp >= 0) {
            info.digits = info.digits + "00000";
            String part2 = info.digits.substring(info.exp + 1);
            while (!part2.isEmpty() && part2.charAt(part2.length() - 1) == '0') {
                part2 = part2.substring(0, part2.length() - 1);
            }
            return info.digits.substring(0, info.exp + 1) + (part2.isEmpty() ? "" : '.' + part2);
        }
        for (int i = 1; i < -info.exp; ++i) {
            info.digits = '0' + info.digits;
        }
        while (!info.digits.isEmpty() && info.digits.charAt(info.digits.length() - 1) == '0') {
            info.digits = info.digits.substring(0, info.digits.length() - 1);
        }
        return "0." + info.digits;
    }

    private static final class DtoAInfo {
        public final int exp;
        @NotNull
        public String digits;

        DtoAInfo(@NotNull String digits, int exp) {
            this.digits = digits;
            this.exp = exp;
        }
    }
}

