/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.serialization;

import com.shapesecurity.functional.data.Either;
import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.functional.data.Maybe;
import com.shapesecurity.functional.data.NonEmptyImmutableList;
import com.shapesecurity.shift.ast.Block;
import com.shapesecurity.shift.ast.CatchClause;
import com.shapesecurity.shift.ast.FunctionBody;
import com.shapesecurity.shift.ast.Identifier;
import com.shapesecurity.shift.ast.Node;
import com.shapesecurity.shift.ast.Script;
import com.shapesecurity.shift.ast.SourceLocation;
import com.shapesecurity.shift.ast.SwitchCase;
import com.shapesecurity.shift.ast.SwitchDefault;
import com.shapesecurity.shift.ast.VariableDeclaration;
import com.shapesecurity.shift.ast.VariableDeclarator;
import com.shapesecurity.shift.ast.directive.UnknownDirective;
import com.shapesecurity.shift.ast.directive.UseStrictDirective;
import com.shapesecurity.shift.ast.expression.ArrayExpression;
import com.shapesecurity.shift.ast.expression.AssignmentExpression;
import com.shapesecurity.shift.ast.expression.BinaryExpression;
import com.shapesecurity.shift.ast.expression.CallExpression;
import com.shapesecurity.shift.ast.expression.ComputedMemberExpression;
import com.shapesecurity.shift.ast.expression.ConditionalExpression;
import com.shapesecurity.shift.ast.expression.FunctionExpression;
import com.shapesecurity.shift.ast.expression.IdentifierExpression;
import com.shapesecurity.shift.ast.expression.LiteralBooleanExpression;
import com.shapesecurity.shift.ast.expression.LiteralInfinityExpression;
import com.shapesecurity.shift.ast.expression.LiteralNullExpression;
import com.shapesecurity.shift.ast.expression.LiteralNumericExpression;
import com.shapesecurity.shift.ast.expression.LiteralRegExpExpression;
import com.shapesecurity.shift.ast.expression.LiteralStringExpression;
import com.shapesecurity.shift.ast.expression.NewExpression;
import com.shapesecurity.shift.ast.expression.ObjectExpression;
import com.shapesecurity.shift.ast.expression.PostfixExpression;
import com.shapesecurity.shift.ast.expression.PrefixExpression;
import com.shapesecurity.shift.ast.expression.StaticMemberExpression;
import com.shapesecurity.shift.ast.expression.ThisExpression;
import com.shapesecurity.shift.ast.property.DataProperty;
import com.shapesecurity.shift.ast.property.Getter;
import com.shapesecurity.shift.ast.property.PropertyName;
import com.shapesecurity.shift.ast.property.Setter;
import com.shapesecurity.shift.ast.statement.BlockStatement;
import com.shapesecurity.shift.ast.statement.BreakStatement;
import com.shapesecurity.shift.ast.statement.ContinueStatement;
import com.shapesecurity.shift.ast.statement.DebuggerStatement;
import com.shapesecurity.shift.ast.statement.DoWhileStatement;
import com.shapesecurity.shift.ast.statement.EmptyStatement;
import com.shapesecurity.shift.ast.statement.ExpressionStatement;
import com.shapesecurity.shift.ast.statement.ForInStatement;
import com.shapesecurity.shift.ast.statement.ForStatement;
import com.shapesecurity.shift.ast.statement.FunctionDeclaration;
import com.shapesecurity.shift.ast.statement.IfStatement;
import com.shapesecurity.shift.ast.statement.LabeledStatement;
import com.shapesecurity.shift.ast.statement.ReturnStatement;
import com.shapesecurity.shift.ast.statement.SwitchStatement;
import com.shapesecurity.shift.ast.statement.SwitchStatementWithDefault;
import com.shapesecurity.shift.ast.statement.ThrowStatement;
import com.shapesecurity.shift.ast.statement.TryCatchStatement;
import com.shapesecurity.shift.ast.statement.TryFinallyStatement;
import com.shapesecurity.shift.ast.statement.VariableDeclarationStatement;
import com.shapesecurity.shift.ast.statement.WhileStatement;
import com.shapesecurity.shift.ast.statement.WithStatement;
import com.shapesecurity.shift.path.Branch;
import com.shapesecurity.shift.utils.Utils;
import com.shapesecurity.shift.visitor.Reducer;
import org.jetbrains.annotations.NotNull;

public class Serializer
implements Reducer<StringBuilder> {
    public static final Serializer INSTANCE = new Serializer();

    protected Serializer() {
    }

    @NotNull
    public static String serialize(@NotNull Script script) {
        return script.reduce(INSTANCE).toString();
    }

    @NotNull
    private static StringBuilder list(@NotNull ImmutableList<StringBuilder> values) {
        if (values.isEmpty()) {
            return new StringBuilder("[]");
        }
        StringBuilder sb = new StringBuilder("[");
        NonEmptyImmutableList nel = (NonEmptyImmutableList)values;
        sb.append((CharSequence)nel.head);
        nel.tail().foreach(s -> sb.append(",").append((CharSequence)s));
        sb.append("]");
        return sb;
    }

    @NotNull
    private static StringBuilder olist(@NotNull ImmutableList<Maybe<StringBuilder>> values) {
        if (values.isEmpty()) {
            return new StringBuilder("[]");
        }
        StringBuilder sb = new StringBuilder("[");
        NonEmptyImmutableList nel = (NonEmptyImmutableList)values;
        sb.append((CharSequence)Serializer.o((Maybe)nel.head));
        nel.tail().foreach(s -> sb.append(",").append((CharSequence)Serializer.o(s)));
        sb.append("]");
        return sb;
    }

    @NotNull
    private static StringBuilder o(@NotNull Maybe<StringBuilder> el) {
        return el.orJust(new StringBuilder("null"));
    }

    @NotNull
    private static CharSequence e(@NotNull Either<StringBuilder, StringBuilder> el) {
        return Serializer.olist(ImmutableList.list(el.left(), el.right()));
    }

    @NotNull
    private static JsonObjectBuilder b(@NotNull String type) {
        return new JsonObjectBuilder().add("type", type);
    }

    @Override
    @NotNull
    public StringBuilder reduceScript(@NotNull Script node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder body) {
        return Serializer.b("Script").add("body", body).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceIdentifier(@NotNull Identifier node, @NotNull ImmutableList<Branch> path) {
        return Serializer.b("Identifier").add("name", node.name).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceIdentifierExpression(@NotNull IdentifierExpression node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder identifier) {
        return Serializer.b("IdentifierExpression").add("identifier", identifier).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceThisExpression(@NotNull ThisExpression node, @NotNull ImmutableList<Branch> path) {
        return Serializer.b("ThisExpression").done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceLiteralBooleanExpression(@NotNull LiteralBooleanExpression node, @NotNull ImmutableList<Branch> path) {
        return Serializer.b("LiteralBooleanExpression").add("value", node.value).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceLiteralStringExpression(@NotNull LiteralStringExpression node, @NotNull ImmutableList<Branch> path) {
        return Serializer.b("LiteralStringExpression").add("value", node.value).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceLiteralRegExpExpression(@NotNull LiteralRegExpExpression node, @NotNull ImmutableList<Branch> path) {
        return Serializer.b("LiteralRegexExpression").add("value", node.value).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceLiteralNumericExpression(@NotNull LiteralNumericExpression node, @NotNull ImmutableList<Branch> path) {
        return Serializer.b("LiteralNumericExpression").add("value", node.value).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceLiteralInfinityExpression(@NotNull LiteralInfinityExpression node, @NotNull ImmutableList<Branch> path) {
        return Serializer.b("LiteralInfinityExpression").done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceLiteralNullExpression(@NotNull LiteralNullExpression node, @NotNull ImmutableList<Branch> path) {
        return Serializer.b("LiteralNullExpression").done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceFunctionExpression(@NotNull FunctionExpression node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<StringBuilder> name, @NotNull ImmutableList<StringBuilder> parameters, @NotNull StringBuilder body) {
        return Serializer.b("FunctionExpression").add("name", name).add("parameters", Serializer.list(parameters)).add("body", body).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceStaticMemberExpression(@NotNull StaticMemberExpression node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder object, @NotNull StringBuilder property) {
        return Serializer.b("StaticMemberExpression").add("object", object).add("property", property).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceComputedMemberExpression(@NotNull ComputedMemberExpression node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder object, @NotNull StringBuilder expression) {
        return Serializer.b("ComputedMemberExpression").add("object", object).add("expression", expression).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceObjectExpression(@NotNull ObjectExpression node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<StringBuilder> properties) {
        return Serializer.b("ObjectExpression").add("properties", Serializer.list(properties)).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceBinaryExpression(@NotNull BinaryExpression node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder left, @NotNull StringBuilder right) {
        return Serializer.b("BinaryExpression").add("operator", node.operator.getName()).add("left", left).add("right", right).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceAssignmentExpression(@NotNull AssignmentExpression node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder binding, @NotNull StringBuilder expression) {
        return Serializer.b("AssignmentExpression").add("operator", node.operator.getName()).add("binding", binding).add("expression", expression).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceArrayExpression(@NotNull ArrayExpression node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<Maybe<StringBuilder>> elements) {
        return Serializer.b("ArrayExpression").add("elements", Serializer.olist(elements)).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceNewExpression(@NotNull NewExpression node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder callee, @NotNull ImmutableList<StringBuilder> arguments) {
        return Serializer.b("NewExpression").add("callee", callee).add("arguments", Serializer.list(arguments)).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceCallExpression(@NotNull CallExpression node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder callee, @NotNull ImmutableList<StringBuilder> arguments) {
        return Serializer.b("CallExpression").add("callee", callee).add("arguments", Serializer.list(arguments)).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reducePostfixExpression(@NotNull PostfixExpression node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder operand) {
        return Serializer.b("PostfixExpression").add("operator", node.operator.getName()).add("operand", operand).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reducePrefixExpression(@NotNull PrefixExpression node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder operand) {
        return Serializer.b("PrefixExpression").add("operator", node.operator.getName()).add("operand", operand).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceConditionalExpression(@NotNull ConditionalExpression node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder test, @NotNull StringBuilder consequent, @NotNull StringBuilder alternate) {
        return Serializer.b("ConditionalExpression").add("test", test).add("consequent", consequent).add("alternate", alternate).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceFunctionDeclaration(@NotNull FunctionDeclaration node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder name, @NotNull ImmutableList<StringBuilder> params, @NotNull StringBuilder body) {
        return Serializer.b("FunctionDeclaration").add("name", name).add("parameters", Serializer.list(params)).add("body", body).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceUseStrictDirective(@NotNull UseStrictDirective node, @NotNull ImmutableList<Branch> path) {
        return Serializer.b("UseStrictDirective").done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceUnknownDirective(@NotNull UnknownDirective node, @NotNull ImmutableList<Branch> path) {
        return Serializer.b("UnknownDirective").add("value", node.value).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceBlockStatement(@NotNull BlockStatement node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder block) {
        return Serializer.b("BlockStatement").add("block", block).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceBreakStatement(@NotNull BreakStatement node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<StringBuilder> label) {
        return Serializer.b("BreakStatement").add("label", label).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceCatchClause(@NotNull CatchClause node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder binding, @NotNull StringBuilder body) {
        return Serializer.b("CatchClause").add("binding", binding).add("body", body).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceContinueStatement(@NotNull ContinueStatement node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<StringBuilder> label) {
        return Serializer.b("ContinueStatement").add("label", label).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceDebuggerStatement(@NotNull DebuggerStatement node, @NotNull ImmutableList<Branch> path) {
        return Serializer.b("DebuggerStatement").done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceDoWhileStatement(@NotNull DoWhileStatement node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder body, @NotNull StringBuilder test) {
        return Serializer.b("DoWhileStatement").add("body", body).add("test", test).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceEmptyStatement(@NotNull EmptyStatement node, @NotNull ImmutableList<Branch> path) {
        return Serializer.b("EmptyStatement").done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceExpressionStatement(@NotNull ExpressionStatement node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder expression) {
        return Serializer.b("ExpressionStatement").add("expression", expression).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceForInStatement(@NotNull ForInStatement node, @NotNull ImmutableList<Branch> path, @NotNull Either<StringBuilder, StringBuilder> left, @NotNull StringBuilder right, @NotNull StringBuilder body) {
        return Serializer.b("ForInStatement").add("left", left).add("right", right).add("body", body).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceForStatement(@NotNull ForStatement node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<Either<StringBuilder, StringBuilder>> init, @NotNull Maybe<StringBuilder> test, @NotNull Maybe<StringBuilder> update, @NotNull StringBuilder body) {
        return Serializer.b("ForStatement").add("init", init.map(x -> x.either(y -> y, y -> y))).add("test", test).add("update", update).add("body", body).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceIfStatement(@NotNull IfStatement node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder test, @NotNull StringBuilder consequent, @NotNull Maybe<StringBuilder> alternate) {
        return Serializer.b("IfStatement").add("test", test).add("consequent", consequent).add("alternate", alternate).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceLabeledStatement(@NotNull LabeledStatement node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder label, @NotNull StringBuilder body) {
        return Serializer.b("LabeledStatement").add("label", label).add("body", body).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceReturnStatement(@NotNull ReturnStatement node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<StringBuilder> expression) {
        return Serializer.b("ReturnStatement").add("expression", expression).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceSwitchCase(@NotNull SwitchCase node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder test, @NotNull ImmutableList<StringBuilder> consequent) {
        return Serializer.b("SwitchCase").add("test", test).add("consequent", Serializer.list(consequent)).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceSwitchDefault(@NotNull SwitchDefault node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<StringBuilder> consequent) {
        return Serializer.b("SwitchDefault").add("consequent", Serializer.list(consequent)).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceSwitchStatement(@NotNull SwitchStatement node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder discriminant, @NotNull ImmutableList<StringBuilder> cases) {
        return Serializer.b("SwitchStatement").add("discriminant", discriminant).add("cases", Serializer.list(cases)).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceSwitchStatementWithDefault(@NotNull SwitchStatementWithDefault node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder discriminant, @NotNull ImmutableList<StringBuilder> preDefaultCases, @NotNull StringBuilder defaultCase, @NotNull ImmutableList<StringBuilder> postDefaultCases) {
        return Serializer.b("SwitchStatementWithDefault").add("discriminant", discriminant).add("preDefaultCases", Serializer.list(preDefaultCases)).add("defaultCase", defaultCase).add("postDefaultCases", Serializer.list(postDefaultCases)).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceThrowStatement(@NotNull ThrowStatement node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder expression) {
        return Serializer.b("ThrowStatement").add("expression", expression).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceTryCatchStatement(@NotNull TryCatchStatement node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder body, @NotNull StringBuilder handler) {
        return Serializer.b("TryStatement").add("body", body).add("handler", handler).add("finalizer", Maybe.nothing()).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceTryFinallyStatement(@NotNull TryFinallyStatement node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder body, @NotNull Maybe<StringBuilder> handler, @NotNull StringBuilder finalizer) {
        return Serializer.b("TryStatement").add("body", body).add("handler", handler).add("finalizer", finalizer).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceVariableDeclarationStatement(@NotNull VariableDeclarationStatement node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder declaration) {
        return Serializer.b("VariableDeclarationStatement").add("declaration", declaration).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceVariableDeclaration(@NotNull VariableDeclaration node, @NotNull ImmutableList<Branch> path, @NotNull NonEmptyImmutableList<StringBuilder> declarators) {
        return Serializer.b("VariableDeclaration").add("kind", node.kind.name).add("declarators", Serializer.list(declarators)).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceWhileStatement(@NotNull WhileStatement node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder test, @NotNull StringBuilder body) {
        return Serializer.b("WhileStatement").add("test", test).add("body", body).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceWithStatement(@NotNull WithStatement node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder object, @NotNull StringBuilder body) {
        return Serializer.b("WithStatement").add("object", object).add("body", body).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceDataProperty(@NotNull DataProperty node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder name, @NotNull StringBuilder value) {
        return Serializer.b("DataProperty").add("name", name).add("value", value).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceGetter(@NotNull Getter node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder name, @NotNull StringBuilder body) {
        return Serializer.b("Getter").add("name", name).add("body", body).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceSetter(@NotNull Setter node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder name, @NotNull StringBuilder parameter, @NotNull StringBuilder body) {
        return Serializer.b("Setter").add("name", name).add("parameter", parameter).add("body", body).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reducePropertyName(@NotNull PropertyName node, @NotNull ImmutableList<Branch> path) {
        return Serializer.b("PropertyName").add("value", node.value).add("kind", node.kind.name).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceFunctionBody(@NotNull FunctionBody node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<StringBuilder> directives, @NotNull ImmutableList<StringBuilder> statements) {
        return Serializer.b("FunctionBody").add("directives", Serializer.list(directives)).add("statements", Serializer.list(statements)).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceVariableDeclarator(@NotNull VariableDeclarator node, @NotNull ImmutableList<Branch> path, @NotNull StringBuilder binding, @NotNull Maybe<StringBuilder> init) {
        return Serializer.b("VariableDeclarator").add("binding", binding).add("init", init).done(node);
    }

    @Override
    @NotNull
    public StringBuilder reduceBlock(@NotNull Block node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<StringBuilder> statements) {
        return Serializer.b("Block").add("statements", Serializer.list(statements)).done(node);
    }

    private static class JsonObjectBuilder {
        boolean first = true;
        final StringBuilder text = new StringBuilder("{");

        private JsonObjectBuilder() {
        }

        private void optionalComma() {
            if (this.first) {
                this.first = false;
            } else {
                this.text.append(",");
            }
        }

        @NotNull
        JsonObjectBuilder add(@NotNull String property, boolean value) {
            this.optionalComma();
            this.text.append(Utils.escapeStringLiteral(property)).append(":").append(value);
            return this;
        }

        @NotNull
        JsonObjectBuilder add(@NotNull String property, @NotNull String value) {
            this.optionalComma();
            this.text.append(Utils.escapeStringLiteral(property)).append(":").append(Utils.escapeStringLiteral(value));
            return this;
        }

        @NotNull
        JsonObjectBuilder add(@NotNull String property, @NotNull Number value) {
            this.optionalComma();
            this.text.append(Utils.escapeStringLiteral(property)).append(":").append(value);
            return this;
        }

        @NotNull
        JsonObjectBuilder add(@NotNull String property, @NotNull StringBuilder value) {
            this.optionalComma();
            this.text.append(Utils.escapeStringLiteral(property)).append(":").append((CharSequence)value);
            return this;
        }

        @NotNull
        JsonObjectBuilder add(@NotNull String property, @NotNull Maybe<StringBuilder> value) {
            this.optionalComma();
            this.text.append(Utils.escapeStringLiteral(property)).append(":").append((CharSequence)Serializer.o(value));
            return this;
        }

        @NotNull
        JsonObjectBuilder add(@NotNull String property, @NotNull Either<StringBuilder, StringBuilder> value) {
            this.optionalComma();
            this.text.append(Utils.escapeStringLiteral(property)).append(":").append(Serializer.e(value));
            return this;
        }

        @NotNull
        StringBuilder done(@NotNull Node node) {
            SourceLocation loc = node.getLoc();
            if (loc != null && loc.source != null) {
                this.add("range", Serializer.list(ImmutableList.list(new StringBuilder(Integer.toString(loc.offset)), new StringBuilder(Integer.toString(loc.offset + loc.source.length())))));
            }
            this.text.append("}");
            return this.text;
        }
    }
}

