/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.scope;

import com.shapesecurity.functional.Pair;
import com.shapesecurity.functional.data.Either;
import com.shapesecurity.functional.data.HashTable;
import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.functional.data.Maybe;
import com.shapesecurity.functional.data.Monoid;
import com.shapesecurity.functional.data.NonEmptyImmutableList;
import com.shapesecurity.shift.ast.Block;
import com.shapesecurity.shift.ast.CatchClause;
import com.shapesecurity.shift.ast.Identifier;
import com.shapesecurity.shift.ast.Node;
import com.shapesecurity.shift.ast.Script;
import com.shapesecurity.shift.ast.VariableDeclaration;
import com.shapesecurity.shift.ast.VariableDeclarator;
import com.shapesecurity.shift.ast.expression.AssignmentExpression;
import com.shapesecurity.shift.ast.expression.BinaryExpression;
import com.shapesecurity.shift.ast.expression.CallExpression;
import com.shapesecurity.shift.ast.expression.FunctionExpression;
import com.shapesecurity.shift.ast.expression.IdentifierExpression;
import com.shapesecurity.shift.ast.expression.PostfixExpression;
import com.shapesecurity.shift.ast.expression.PrefixExpression;
import com.shapesecurity.shift.ast.operators.AssignmentOperator;
import com.shapesecurity.shift.ast.operators.PrefixOperator;
import com.shapesecurity.shift.ast.property.Getter;
import com.shapesecurity.shift.ast.property.Setter;
import com.shapesecurity.shift.ast.statement.ForInStatement;
import com.shapesecurity.shift.ast.statement.FunctionDeclaration;
import com.shapesecurity.shift.ast.statement.WithStatement;
import com.shapesecurity.shift.path.Branch;
import com.shapesecurity.shift.scope.Accessibility;
import com.shapesecurity.shift.scope.Declaration;
import com.shapesecurity.shift.scope.GlobalScope;
import com.shapesecurity.shift.scope.Reference;
import com.shapesecurity.shift.scope.Scope;
import com.shapesecurity.shift.scope.Variable;
import com.shapesecurity.shift.visitor.MonoidalReducer;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScopeAnalyzer
extends MonoidalReducer<State> {
    private static final ScopeAnalyzer INSTANCE = new ScopeAnalyzer();

    private ScopeAnalyzer() {
        super(new StateMonoid());
    }

    @NotNull
    public static GlobalScope analyze(@NotNull Script script) {
        return (GlobalScope)script.reduce(ScopeAnalyzer.INSTANCE).children.maybeHead().just();
    }

    @Override
    @NotNull
    public State reduceIdentifier(@NotNull Identifier node, @NotNull ImmutableList<Branch> path) {
        return new State(HashTable.empty(), HashTable.empty(), HashTable.empty(), new HashSet(), ImmutableList.nil(), ImmutableList.nil(), false, path, node, false);
    }

    @Override
    @NotNull
    public State reduceIdentifierExpression(@NotNull IdentifierExpression node, @NotNull ImmutableList<Branch> path, @NotNull State identifier) {
        return identifier.addReference(Accessibility.Read);
    }

    @Override
    @NotNull
    public State reduceBinaryExpression(@NotNull BinaryExpression node, @NotNull ImmutableList<Branch> path, @NotNull State left, @NotNull State right) {
        return super.reduceBinaryExpression(node, path, left, right);
    }

    @Override
    @NotNull
    public State reduceAssignmentExpression(@NotNull AssignmentExpression node, @NotNull ImmutableList<Branch> path, @NotNull State binding, @NotNull State expression) {
        if (node.binding instanceof IdentifierExpression) {
            assert (binding.lastIdentifier != null);
            assert (binding.lastPath != null);
            return expression.addReference(binding.lastPath, binding.lastIdentifier, node.operator == AssignmentOperator.Assign ? Accessibility.Write : Accessibility.ReadWrite);
        }
        return super.reduceAssignmentExpression(node, path, binding, expression);
    }

    @Override
    @NotNull
    public State reduceCallExpression(@NotNull CallExpression node, @NotNull ImmutableList<Branch> path, @NotNull State callee, @NotNull ImmutableList<State> arguments) {
        State s = super.reduceCallExpression(node, path, callee, arguments);
        if (node.callee instanceof IdentifierExpression && ((IdentifierExpression)node.callee).identifier.name.equals("eval")) {
            return s.taint();
        }
        return s;
    }

    @Override
    @NotNull
    public State reduceForInStatement(@NotNull ForInStatement node, @NotNull ImmutableList<Branch> path, @NotNull Either<State, State> left, @NotNull State right, @NotNull State body) {
        if (node.left.isRight() && node.left.right().just() instanceof IdentifierExpression) {
            left = left.map(x -> x, x -> x.addReference(Accessibility.Write));
        } else if (node.left.isLeft() && ((VariableDeclarator)node.left.left().just().declarators.head).init.isNothing()) {
            left = left.map(x -> x.addReference(Accessibility.Write), x -> x);
        }
        return super.reduceForInStatement(node, path, left, right, body);
    }

    @Override
    @NotNull
    public State reduceScript(@NotNull Script node, @NotNull ImmutableList<Branch> path, @NotNull State body) {
        return super.reduceScript(node, path, body).finish(node, Scope.Type.Global);
    }

    @Override
    @NotNull
    public State reduceFunctionDeclaration(@NotNull FunctionDeclaration node, @NotNull ImmutableList<Branch> path, @NotNull State id, @NotNull ImmutableList<State> params, @NotNull State programBody) {
        params = params.map(s -> ((State)s).addDeclaration(Declaration.Kind.Param));
        ImmutableList<Branch> lastPath = id.lastPath;
        Identifier lastIdentifier = id.lastIdentifier;
        assert (lastPath != null);
        assert (lastIdentifier != null);
        return super.reduceFunctionDeclaration(node, path, id, params, programBody).finish(node, Scope.Type.Function).addDeclaration(lastPath, lastIdentifier, Declaration.Kind.FunctionName);
    }

    @Override
    @NotNull
    public State reduceFunctionExpression(@NotNull FunctionExpression node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<State> id, @NotNull ImmutableList<State> params, @NotNull State programBody) {
        params = params.map(s -> ((State)s).addDeclaration(Declaration.Kind.Param));
        State s2 = super.reduceFunctionExpression(node, path, id, params, programBody).finish(node, Scope.Type.Function);
        if (id.isJust()) {
            s2 = s2.target(id.just()).addDeclaration(Declaration.Kind.FunctionName);
            s2 = s2.finish(node, Scope.Type.FunctionName);
        }
        return s2;
    }

    @Override
    @NotNull
    public State reduceGetter(@NotNull Getter node, @NotNull ImmutableList<Branch> path, @NotNull State key, @NotNull State body) {
        return body.finish(node, Scope.Type.Function);
    }

    @Override
    @NotNull
    public State reduceSetter(@NotNull Setter node, @NotNull ImmutableList<Branch> path, @NotNull State key, @NotNull State param, @NotNull State body) {
        return super.reduceSetter(node, path, key, param.addDeclaration(Declaration.Kind.Param), body).finish(node, Scope.Type.Function);
    }

    @Override
    @NotNull
    public State reduceWithStatement(@NotNull WithStatement node, @NotNull ImmutableList<Branch> path, @NotNull State object, @NotNull State body) {
        return super.reduceWithStatement(node, path, object, body.finish(node, Scope.Type.With));
    }

    @Override
    @NotNull
    public State reduceCatchClause(@NotNull CatchClause node, @NotNull ImmutableList<Branch> path, @NotNull State param, @NotNull State body) {
        return super.reduceCatchClause(node, path, param.addDeclaration(Declaration.Kind.CatchParam), body).finish(node, Scope.Type.Catch);
    }

    @Override
    @NotNull
    public State reduceBlock(@NotNull Block node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<State> statements) {
        State s = super.reduceBlock(node, path, statements);
        if (s.blockScopedDeclarations.length > 0) {
            s = s.finish(node, Scope.Type.Block);
        }
        return s;
    }

    @Override
    @NotNull
    public State reducePostfixExpression(@NotNull PostfixExpression node, @NotNull ImmutableList<Branch> path, @NotNull State operand) {
        if (node.operand instanceof IdentifierExpression) {
            operand = operand.addReference(Accessibility.ReadWrite);
        }
        return super.reducePostfixExpression(node, path, operand);
    }

    @Override
    @NotNull
    public State reducePrefixExpression(@NotNull PrefixExpression node, @NotNull ImmutableList<Branch> path, @NotNull State operand) {
        if ((node.operator == PrefixOperator.Decrement || node.operator == PrefixOperator.Increment) && node.operand instanceof IdentifierExpression) {
            operand = operand.addReference(Accessibility.ReadWrite);
        }
        return super.reducePrefixExpression(node, path, operand);
    }

    @Override
    @NotNull
    public State reduceVariableDeclaration(@NotNull VariableDeclaration node, @NotNull ImmutableList<Branch> path, @NotNull NonEmptyImmutableList<State> declarators) {
        Declaration.Kind kind = Declaration.Kind.fromVariableDeclarationKind(node.kind);
        ImmutableList l = declarators;
        while (!((ImmutableList)l).isEmpty()) {
            l = ((ImmutableList)l).maybeTail().just();
        }
        return ((State)super.reduceVariableDeclaration(node, path, declarators.map(d -> ((State)d).addDeclaration(kind, d.lastDeclaratorWasInit)))).target((State)declarators.head);
    }

    @Override
    @NotNull
    public State reduceVariableDeclarator(@NotNull VariableDeclarator node, @NotNull ImmutableList<Branch> path, @NotNull State id, @NotNull Maybe<State> init) {
        if (init.isJust()) {
            id = id.addReference(Accessibility.Write, true);
        }
        return super.reduceVariableDeclarator(node, path, id, init).target(id);
    }

    public static final class StateMonoid
    implements Monoid<State> {
        @Override
        @NotNull
        public State identity() {
            return new State();
        }

        @Override
        @NotNull
        public State append(State a, State b) {
            if (a == b) {
                return a;
            }
            return new State(a, b);
        }
    }

    public static final class State {
        public final boolean dynamic;
        @NotNull
        public final HashTable<String, HashTable<ImmutableList<Branch>, Reference>> freeIdentifiers;
        @NotNull
        public final HashTable<String, HashTable<ImmutableList<Branch>, Declaration>> functionScopedDeclarations;
        @NotNull
        public final HashTable<String, HashTable<ImmutableList<Branch>, Declaration>> blockScopedDeclarations;
        @NotNull
        public final Set<String> functionScopedInit;
        @NotNull
        public final ImmutableList<Variable> blockScopedTiedVar;
        @NotNull
        public final ImmutableList<Scope> children;
        @Nullable
        public final ImmutableList<Branch> lastPath;
        @Nullable
        public final Identifier lastIdentifier;
        public final boolean lastDeclaratorWasInit;

        private State(@NotNull HashTable<String, HashTable<ImmutableList<Branch>, Reference>> freeIdentifiers, @NotNull HashTable<String, HashTable<ImmutableList<Branch>, Declaration>> functionScopedDeclarations, @NotNull HashTable<String, HashTable<ImmutableList<Branch>, Declaration>> blockScopedDeclarations, @NotNull Set<String> functionScopedInit, @NotNull ImmutableList<Variable> blockScopedTiedVar, @NotNull ImmutableList<Scope> children, boolean dynamic, @Nullable ImmutableList<Branch> lastPath, @Nullable Identifier lastIdentifier, boolean lastDeclaratorWasInit) {
            this.freeIdentifiers = freeIdentifiers;
            this.functionScopedDeclarations = functionScopedDeclarations;
            this.blockScopedDeclarations = blockScopedDeclarations;
            this.functionScopedInit = functionScopedInit;
            this.blockScopedTiedVar = blockScopedTiedVar;
            this.children = children;
            this.dynamic = dynamic;
            this.lastPath = lastPath;
            this.lastIdentifier = lastIdentifier;
            this.lastDeclaratorWasInit = lastDeclaratorWasInit;
        }

        private State() {
            this.freeIdentifiers = HashTable.empty();
            this.functionScopedDeclarations = HashTable.empty();
            this.blockScopedDeclarations = HashTable.empty();
            this.functionScopedInit = new HashSet<String>();
            this.blockScopedTiedVar = ImmutableList.nil();
            this.children = ImmutableList.nil();
            this.dynamic = false;
            this.lastPath = null;
            this.lastIdentifier = null;
            this.lastDeclaratorWasInit = false;
        }

        private State(@NotNull State a, @NotNull State b) {
            this.freeIdentifiers = State.merge(a.freeIdentifiers, b.freeIdentifiers);
            this.functionScopedDeclarations = State.merge(a.functionScopedDeclarations, b.functionScopedDeclarations);
            this.blockScopedDeclarations = State.merge(a.blockScopedDeclarations, b.blockScopedDeclarations);
            this.functionScopedInit = State.mergeSet(a.functionScopedInit, b.functionScopedInit);
            this.blockScopedTiedVar = a.blockScopedTiedVar.append(b.blockScopedTiedVar);
            this.children = a.children.append(b.children);
            this.dynamic = a.dynamic || b.dynamic;
            this.lastPath = null;
            this.lastIdentifier = null;
            this.lastDeclaratorWasInit = false;
        }

        @NotNull
        private static <T> HashTable<String, HashTable<ImmutableList<Branch>, T>> merge(@NotNull HashTable<String, HashTable<ImmutableList<Branch>, T>> mapA, @NotNull HashTable<String, HashTable<ImmutableList<Branch>, T>> mapB) {
            return mapA.merge(mapB, HashTable::merge);
        }

        @NotNull
        private static Set<String> mergeSet(@NotNull Set<String> setA, @NotNull Set<String> setB) {
            if (setB.isEmpty()) {
                return setA;
            }
            if (setA.isEmpty()) {
                return setB;
            }
            HashSet<String> setC = new HashSet<String>();
            setC.addAll(setA);
            setC.addAll(setB);
            return setC;
        }

        private State finish(@NotNull Node astNode, @NotNull Scope.Type scopeType) {
            ImmutableList<Variable> variables = ImmutableList.nil();
            HashTable<String, HashTable<ImmutableList<Branch>, Declaration>> functionScope = HashTable.empty();
            HashTable<String, HashTable<ImmutableList<Branch>, Reference>> freeIdentifiers = this.freeIdentifiers;
            HashSet<String> functionScopedInit = new HashSet<String>();
            ImmutableList<Variable> blockScopedTiedVar = ImmutableList.nil();
            switch (scopeType) {
                case Block: 
                case Catch: 
                case With: {
                    ImmutableList<Variable> variables3 = variables;
                    for (Pair<String, HashTable<ImmutableList<Branch>, Declaration>> entry2 : this.blockScopedDeclarations.entries()) {
                        String name2 = (String)entry2.a;
                        HashTable hashTable = (HashTable)entry2.b;
                        HashTable<ImmutableList<Branch>, Reference> references2 = freeIdentifiers.get(name2).orJust(HashTable.empty());
                        variables3 = ImmutableList.cons(new Variable(name2, references2, hashTable), variables3);
                        freeIdentifiers = freeIdentifiers.remove(name2);
                    }
                    variables = variables3;
                    functionScope = this.functionScopedDeclarations;
                    functionScopedInit.addAll(this.functionScopedInit);
                    ImmutableList<Variable> vptr = variables;
                    blockScopedTiedVar = this.blockScopedTiedVar;
                    while (!vptr.isEmpty()) {
                        Variable v = (Variable)vptr.maybeHead().just();
                        if (functionScopedInit.contains(v.name)) {
                            blockScopedTiedVar = blockScopedTiedVar.cons(v);
                            functionScopedInit.remove(v.name);
                        }
                        vptr = vptr.maybeTail().just();
                    }
                    break;
                }
                default: {
                    if (scopeType == Scope.Type.Function) {
                        ImmutableList<Variable> variables1 = variables;
                        HashTable arguments = freeIdentifiers.get("arguments").orJust(HashTable.empty());
                        freeIdentifiers = freeIdentifiers.remove("arguments");
                        variables = variables1 = ImmutableList.cons(new Variable("arguments", arguments, HashTable.empty()), variables1);
                    }
                    ImmutableList<Variable> variables2 = variables;
                    for (Pair pair : this.blockScopedDeclarations.entries()) {
                        String name1 = (String)pair.a;
                        HashTable declarations1 = (HashTable)pair.b;
                        HashTable<ImmutableList<Branch>, Reference> references1 = freeIdentifiers.get(name1).orJust(HashTable.empty());
                        variables2 = ImmutableList.cons(new Variable(name1, references1, declarations1), variables2);
                        freeIdentifiers = freeIdentifiers.remove(name1);
                    }
                    ImmutableList<Variable> variables1 = variables = variables2;
                    for (Pair<String, HashTable<ImmutableList<Branch>, Declaration>> entry : this.functionScopedDeclarations.entries()) {
                        String name = (String)entry.a;
                        HashTable declarations = (HashTable)entry.b;
                        HashTable<ImmutableList<Branch>, Reference> references = freeIdentifiers.get(name).orJust(HashTable.empty());
                        variables1 = ImmutableList.cons(new Variable(name, references, declarations), variables1);
                        freeIdentifiers = freeIdentifiers.remove(name);
                    }
                    variables = variables1;
                }
            }
            Scope scope = scopeType == Scope.Type.Global ? new GlobalScope(this.children, variables, blockScopedTiedVar, freeIdentifiers, astNode) : new Scope(this.children, variables, blockScopedTiedVar, freeIdentifiers, scopeType, this.dynamic, astNode);
            return new State(freeIdentifiers, functionScope, HashTable.empty(), functionScopedInit, blockScopedTiedVar, ImmutableList.list(scope, new Scope[0]), false, this.lastPath, this.lastIdentifier, this.lastDeclaratorWasInit);
        }

        @NotNull
        private State addDeclaration(@NotNull Declaration.Kind kind) {
            return this.addDeclaration(kind, false);
        }

        @NotNull
        private State addDeclaration(@NotNull Declaration.Kind kind, boolean hasInit) {
            assert (this.lastPath != null);
            assert (this.lastIdentifier != null);
            return this.addDeclaration(this.lastPath, this.lastIdentifier, kind, this.lastDeclaratorWasInit);
        }

        @NotNull
        private State addDeclaration(@NotNull ImmutableList<Branch> path, @NotNull Identifier id, @NotNull Declaration.Kind kind) {
            return this.addDeclaration(path, id, kind, false);
        }

        @NotNull
        private State addDeclaration(@NotNull ImmutableList<Branch> path, @NotNull Identifier id, @NotNull Declaration.Kind kind, boolean hasInit) {
            Declaration decl = new Declaration(id, path, kind);
            HashTable<String, HashTable<ImmutableList<Branch>, Declaration>> declMap = kind.isBlockScoped ? this.blockScopedDeclarations : this.functionScopedDeclarations;
            HashTable<ImmutableList<Branch>, Declaration> tree = declMap.get(id.name).orJust(HashTable.empty()).put(decl.path, decl);
            declMap = declMap.put(id.name, tree);
            Set<String> functionScopedInit = this.functionScopedInit;
            if (hasInit && kind.isFunctionScoped) {
                functionScopedInit = new HashSet<String>();
                functionScopedInit.addAll(this.functionScopedInit);
                functionScopedInit.add(id.name);
            }
            return new State(this.freeIdentifiers, kind.isBlockScoped ? this.functionScopedDeclarations : declMap, kind.isBlockScoped ? declMap : this.blockScopedDeclarations, functionScopedInit, this.blockScopedTiedVar, this.children, this.dynamic, this.lastPath, this.lastIdentifier, false);
        }

        @NotNull
        public State addReference(@NotNull Accessibility accessibility) {
            return this.addReference(accessibility, false);
        }

        @NotNull
        public State addReference(@NotNull Accessibility accessibility, boolean hasInit) {
            ImmutableList<Branch> path = this.lastPath;
            Identifier id = this.lastIdentifier;
            assert (path != null);
            assert (id != null);
            return this.addReference(path, id, accessibility, hasInit);
        }

        @NotNull
        private State addReference(@NotNull ImmutableList<Branch> path, @NotNull Identifier id, @NotNull Accessibility accessibility) {
            return this.addReference(path, id, accessibility, false);
        }

        @NotNull
        private State addReference(@NotNull ImmutableList<Branch> path, @NotNull Identifier id, @NotNull Accessibility accessibility, boolean hasInit) {
            Reference ref = new Reference(id, path, accessibility);
            HashTable<String, HashTable<ImmutableList<Branch>, Reference>> free = this.freeIdentifiers;
            HashTable<ImmutableList<Branch>, Reference> tree = free.get(ref.node.name).orJust(HashTable.empty()).put(ref.path, ref);
            free = free.put(ref.node.name, tree);
            return new State(free, this.functionScopedDeclarations, this.blockScopedDeclarations, this.functionScopedInit, this.blockScopedTiedVar, this.children, this.dynamic, this.lastPath, this.lastIdentifier, hasInit);
        }

        @NotNull
        public State taint() {
            return new State(this.freeIdentifiers, this.functionScopedDeclarations, this.blockScopedDeclarations, this.functionScopedInit, this.blockScopedTiedVar, this.children, true, this.lastPath, this.lastIdentifier, this.lastDeclaratorWasInit);
        }

        @NotNull
        public State target(@Nullable State id) {
            assert (id != null);
            return new State(this.freeIdentifiers, this.functionScopedDeclarations, this.blockScopedDeclarations, this.functionScopedInit, this.blockScopedTiedVar, this.children, this.dynamic, id.lastPath, id.lastIdentifier, id.lastDeclaratorWasInit);
        }
    }
}

