/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.scope;

import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.shift.ast.Identifier;
import com.shapesecurity.shift.ast.VariableDeclaration;
import com.shapesecurity.shift.path.Branch;
import org.jetbrains.annotations.NotNull;

public class Declaration {
    @NotNull
    public final Identifier node;
    @NotNull
    public final ImmutableList<Branch> path;
    @NotNull
    public final Kind kind;

    public Declaration(@NotNull Identifier node, @NotNull ImmutableList<Branch> path, @NotNull Kind kind) {
        this.node = node;
        this.path = path;
        this.kind = kind;
    }

    @NotNull
    public final ImmutableList<Branch> getPath() {
        return this.path;
    }

    public static enum Kind {
        Var(false),
        Const(true),
        Let(true),
        FunctionName(false),
        Param(false),
        CatchParam(true);

        public final boolean isFunctionScoped;
        public final boolean isBlockScoped;

        private Kind(boolean isBlockScoped) {
            this.isFunctionScoped = !isBlockScoped;
            this.isBlockScoped = isBlockScoped;
        }

        @NotNull
        public static Kind fromVariableDeclarationKind(@NotNull VariableDeclaration.VariableDeclarationKind kind) {
            switch (kind) {
                case Var: {
                    return Var;
                }
                case Const: {
                    return Const;
                }
                case Let: {
                    return Let;
                }
            }
            throw new RuntimeException("not reached");
        }
    }
}

