/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.path;

import com.shapesecurity.shift.ast.Node;
import com.shapesecurity.shift.ast.types.GenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypedBranch<P extends Node, C extends Node> {
    @NotNull
    private final GenType parentType;
    @NotNull
    private final GenType childType;

    TypedBranch(@NotNull GenType parentType, @NotNull GenType childType) {
        this.parentType = parentType;
        this.childType = childType;
    }

    boolean isValidParent(@NotNull GenType type) {
        return this.parentType.isAssignableFrom(type);
    }

    boolean isValidChild(@NotNull GenType type) {
        return this.childType.isAssignableFrom(type);
    }

    public boolean isValidChild(@NotNull GenType parentType, @NotNull GenType type) {
        return this.isValidChild(type);
    }

    @Nullable
    public abstract C view(@NotNull P var1);

    @NotNull
    public abstract P set(@NotNull P var1, @NotNull C var2);
}

