/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.path;

import com.shapesecurity.functional.data.Either;
import com.shapesecurity.functional.data.Maybe;
import com.shapesecurity.shift.ast.EitherNode;
import com.shapesecurity.shift.ast.MaybeNode;
import com.shapesecurity.shift.ast.Node;
import com.shapesecurity.shift.ast.types.MaybeType;
import com.shapesecurity.shift.path.Branch;
import com.shapesecurity.shift.path.TypedBranch;
import com.shapesecurity.shift.path.TypedBranches;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum StaticBranch implements Branch
{
    ALTERNATE(TypedBranches.IfStatement_alternate, TypedBranches.ConditionalExpression_alternate),
    ARGUMENTS(TypedBranches.CallExpression_arguments, TypedBranches.NewExpression_arguments),
    BINDING(TypedBranches.AssignmentExpression_binding, TypedBranches.CatchClause_binding, TypedBranches.VariableDeclarator_binding),
    BLOCK(TypedBranches.BlockStatement_block),
    BODY(TypedBranches.Getter_body, TypedBranches.Setter_body, TypedBranches.FunctionDeclaration_body, TypedBranches.FunctionExpression_body, TypedBranches.DoWhileStatement_body, TypedBranches.ForInStatement_body, TypedBranches.ForStatement_body, TypedBranches.WhileStatement_body, TypedBranches.LabeledStatement_body, TypedBranches.TryCatchStatement_body, TypedBranches.TryFinallyStatement_body, TypedBranches.WithStatement_body, TypedBranches.CatchClause_body, TypedBranches.Script_body),
    CALLEE(TypedBranches.CallExpression_callee, TypedBranches.NewExpression_callee),
    CASES(TypedBranches.SwitchStatement_cases),
    CATCHCLAUSE(TypedBranches.TryCatchStatement_catchClause, TypedBranches.TryFinallyStatement_catchClause),
    CONSEQUENT(TypedBranches.ConditionalExpression_consequent, TypedBranches.IfStatement_consequent, TypedBranches.SwitchCase_consequent, TypedBranches.SwitchDefault_consequent),
    DECLARATION(TypedBranches.VariableDeclarationStatement_declaration),
    DECLARATORS(TypedBranches.VariableDeclaration_declarators),
    DEFAULTCASE(TypedBranches.SwitchStatementWithDefault_defaultCase),
    DIRECTIVES(TypedBranches.FunctionBody_directives),
    DISCRIMINANT(TypedBranches.SwitchStatement_discriminant, TypedBranches.SwitchStatementWithDefault_discriminant),
    ELEMENTS(TypedBranches.ArrayExpression_elements),
    EXPRESSION(TypedBranches.AssignmentExpression_expression, TypedBranches.ComputedMemberExpression_expression, TypedBranches.ExpressionStatement_expression, TypedBranches.ReturnStatement_expression, TypedBranches.ThrowStatement_expression),
    FINALIZER(TypedBranches.TryFinallyStatement_finalizer),
    IDENTIFIER(TypedBranches.IdentifierExpression_identifier),
    INIT(TypedBranches.ForStatement_init, TypedBranches.VariableDeclarator_init),
    JUST(new TypedBranch[0]){

        @Override
        @Nullable
        public Node view(@NotNull Node parent) {
            if (parent instanceof MaybeNode) {
                MaybeNode typed = (MaybeNode)parent;
                if (typed.maybe.isJust()) {
                    return Branch.wrap(typed.maybe.just(), typed.genType.elementType);
                }
            }
            return null;
        }

        @Override
        @NotNull
        public Node set(@NotNull Node parent, @NotNull Node child) {
            if (parent instanceof MaybeNode) {
                MaybeType type = (MaybeType)parent.genType();
                if (((MaybeNode)parent).maybe.isJust() && type.isAssignableFrom(child.genType())) {
                    return new MaybeNode<Node>(Maybe.just(child), type);
                }
            }
            return parent;
        }
    }
    ,
    LABEL(TypedBranches.BreakStatement_label, TypedBranches.ContinueStatement_label, TypedBranches.LabeledStatement_label),
    LEFT(new TypedBranch[]{TypedBranches.BinaryExpression_left, TypedBranches.ForInStatement_left}){

        @Override
        @Nullable
        public Node view(@NotNull Node parent) {
            if (parent instanceof EitherNode) {
                if (((EitherNode)parent).either.isLeft()) {
                    return Branch.wrap(((EitherNode)parent).either.left().just(), ((EitherNode)parent).genType.leftType);
                }
                return null;
            }
            return super.view(parent);
        }

        @Override
        @NotNull
        public Node set(@NotNull Node parent, @NotNull Node child) {
            if (parent instanceof EitherNode) {
                if (((EitherNode)parent).either.isLeft() && ((EitherNode)parent).genType.leftType.isAssignableFrom(child.genType())) {
                    return new EitherNode(Either.left(child), ((EitherNode)parent).genType);
                }
                return parent;
            }
            return super.set(parent, child);
        }
    }
    ,
    NAME(TypedBranches.DataProperty_name, TypedBranches.Getter_name, TypedBranches.Setter_name, TypedBranches.FunctionDeclaration_name, TypedBranches.FunctionExpression_name),
    OBJECT(TypedBranches.StaticMemberExpression_object, TypedBranches.ComputedMemberExpression_object, TypedBranches.WithStatement_object),
    OPERAND(TypedBranches.PrefixExpression_operand, TypedBranches.PostfixExpression_operand),
    PARAMETER(TypedBranches.Setter_parameter),
    PARAMETERS(TypedBranches.FunctionDeclaration_parameters, TypedBranches.FunctionExpression_parameters),
    POSTDEFAULTCASES(TypedBranches.SwitchStatementWithDefault_postDefaultCases),
    PREDEFAULTCASES(TypedBranches.SwitchStatementWithDefault_preDefaultCases),
    PROPERTIES(TypedBranches.ObjectExpression_properties),
    PROPERTY(TypedBranches.StaticMemberExpression_property),
    RIGHT(new TypedBranch[]{TypedBranches.BinaryExpression_right, TypedBranches.ForInStatement_right}){

        @Override
        @Nullable
        public Node view(@NotNull Node parent) {
            if (parent instanceof EitherNode) {
                if (((EitherNode)parent).either.isRight()) {
                    return Branch.wrap(((EitherNode)parent).either.right().just(), ((EitherNode)parent).genType.rightType);
                }
                return null;
            }
            return super.view(parent);
        }

        @Override
        @NotNull
        public Node set(@NotNull Node parent, @NotNull Node child) {
            if (parent instanceof EitherNode) {
                if (((EitherNode)parent).either.isRight() && ((EitherNode)parent).genType.rightType.isAssignableFrom(child.genType())) {
                    return new EitherNode(Either.right(child), ((EitherNode)parent).genType);
                }
                return parent;
            }
            return super.set(parent, child);
        }
    }
    ,
    STATEMENTS(TypedBranches.FunctionBody_statements, TypedBranches.Block_statements),
    TEST(TypedBranches.ConditionalExpression_test, TypedBranches.DoWhileStatement_test, TypedBranches.ForStatement_test, TypedBranches.IfStatement_test, TypedBranches.WhileStatement_test, TypedBranches.SwitchCase_test),
    UPDATE(TypedBranches.ForStatement_update),
    VALUE(TypedBranches.DataProperty_value);

    @NotNull
    private final TypedBranch[] typedBranches;

    private StaticBranch(TypedBranch ... typedBranches) {
        this.typedBranches = typedBranches;
    }

    @Override
    @Nullable
    public Node view(@NotNull Node parent) {
        for (TypedBranch typedBranch : this.typedBranches) {
            if (!typedBranch.isValidParent(parent.genType())) continue;
            return typedBranch.view(parent);
        }
        return null;
    }

    @Override
    @NotNull
    public Node set(@NotNull Node parent, @NotNull Node child) {
        for (TypedBranch typedBranch : this.typedBranches) {
            if (!typedBranch.isValidParent(parent.genType()) || !typedBranch.isValidChild(parent.genType(), child.genType())) continue;
            return typedBranch.set(parent, child);
        }
        return parent;
    }
}

