/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.path;

import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.functional.data.NonEmptyImmutableList;
import com.shapesecurity.shift.ast.ListNode;
import com.shapesecurity.shift.ast.Node;
import com.shapesecurity.shift.ast.NonEmptyListNode;
import com.shapesecurity.shift.path.Branch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IndexedBranch
implements Branch {
    public final int index;
    private static final IndexedBranch[] cache = new IndexedBranch[1024];

    private IndexedBranch(int index) {
        this.index = index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static IndexedBranch from(int i) {
        if (i < 1024) {
            if (cache[i] == null) {
                IndexedBranch[] indexedBranchArray = cache;
                synchronized (cache) {
                    if (cache[i] == null) {
                        IndexedBranch.cache[i] = new IndexedBranch(i);
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            } else {
                return cache[i];
            }
        }
        return new IndexedBranch(i);
    }

    public int hashCode() {
        return this.index;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof IndexedBranch && ((IndexedBranch)obj).index == this.index;
    }

    @Override
    @Nullable
    public Node view(@NotNull Node parent) {
        if (parent instanceof ListNode) {
            ListNode listNode = (ListNode)parent;
            Object node = listNode.list.index(this.index).toNullable();
            if (node == null) {
                return null;
            }
            return Branch.wrap(node, listNode.genType.elementType);
        }
        if (parent instanceof NonEmptyListNode) {
            NonEmptyListNode listNode = (NonEmptyListNode)parent;
            Object node = listNode.list.index(this.index).toNullable();
            if (node == null) {
                return null;
            }
            return Branch.wrap(node, listNode.genType.elementType);
        }
        return null;
    }

    @Override
    @NotNull
    public Node set(@NotNull Node parent, @NotNull Node child) {
        if (parent instanceof ListNode) {
            ListNode list = (ListNode)parent;
            if (list.genType.elementType.isAssignableFrom(child.genType()) && this.index <= list.list.length) {
                return new ListNode(list.list.patch(this.index, 1, ImmutableList.list(child, new Node[0])), list.genType);
            }
        } else if (parent instanceof NonEmptyListNode) {
            NonEmptyListNode list = (NonEmptyListNode)parent;
            if (list.genType.elementType.isAssignableFrom(child.genType()) && this.index <= list.list.length) {
                return new NonEmptyListNode((NonEmptyImmutableList)list.list.patch(this.index, 1, ImmutableList.list(child, new Node[0])), list.genType);
            }
        }
        return parent;
    }

    public String toString() {
        return "" + this.index;
    }
}

