/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.parser;

import com.shapesecurity.shift.ast.SourceLocation;
import com.shapesecurity.shift.parser.JsError;
import com.shapesecurity.shift.parser.SourceRange;
import com.shapesecurity.shift.parser.Token;
import com.shapesecurity.shift.parser.TokenType;
import com.shapesecurity.shift.parser.token.EOFToken;
import com.shapesecurity.shift.parser.token.FalseLiteralToken;
import com.shapesecurity.shift.parser.token.IdentifierToken;
import com.shapesecurity.shift.parser.token.KeywordToken;
import com.shapesecurity.shift.parser.token.NullLiteralToken;
import com.shapesecurity.shift.parser.token.NumericLiteralToken;
import com.shapesecurity.shift.parser.token.PunctuatorToken;
import com.shapesecurity.shift.parser.token.RegularExpressionLiteralToken;
import com.shapesecurity.shift.parser.token.StringLiteralToken;
import com.shapesecurity.shift.parser.token.TrueLiteralToken;
import com.shapesecurity.shift.utils.Utils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class Tokenizer {
    static final HashSet<String> STRICT_MODE_RESERVED_WORD = new HashSet<String>(Arrays.asList("implements", "interface", "package", "private", "protected", "public", "static", "yield", "let"));
    private static final TokenType[] ONE_CHAR_PUNCTUATOR = new TokenType[]{TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.NOT, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.MOD, TokenType.BIT_AND, TokenType.ILLEGAL, TokenType.LPAREN, TokenType.RPAREN, TokenType.MUL, TokenType.ADD, TokenType.COMMA, TokenType.SUB, TokenType.PERIOD, TokenType.DIV, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.COLON, TokenType.SEMICOLON, TokenType.LT, TokenType.ASSIGN, TokenType.GT, TokenType.CONDITIONAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.LBRACK, TokenType.ILLEGAL, TokenType.RBRACK, TokenType.BIT_XOR, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.ILLEGAL, TokenType.LBRACE, TokenType.BIT_OR, TokenType.RBRACE, TokenType.BIT_NOT};
    private static final boolean[] PUNCTUATOR_START = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, true, true, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, false};
    private static final boolean[] IDENTIFIER_START = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    @NotNull
    final String source;
    @NotNull
    protected Token lookahead;
    protected boolean hasLineTerminatorBeforeNext;
    protected boolean strict;
    private int index;
    private int line;
    private int lineStart;
    private int lastIndex;
    private int startIndex;
    private int startLine;
    private int startLineStart;
    private SourceLocation cachedSourceLocation;
    private int lastCachedSourceLocation = -1;

    public Tokenizer(@NotNull String source) throws JsError {
        this.source = source;
        this.lookahead = this.collectToken();
        this.hasLineTerminatorBeforeNext = false;
    }

    private static boolean cse2(@NotNull CharSequence id, char ch1, char ch2) {
        return id.charAt(1) == ch1 && id.charAt(2) == ch2;
    }

    private static boolean cse3(@NotNull CharSequence id, char ch1, char ch2, char ch3) {
        return id.charAt(1) == ch1 && id.charAt(2) == ch2 && id.charAt(3) == ch3;
    }

    private static boolean cse4(@NotNull CharSequence id, char ch1, char ch2, char ch3, char ch4) {
        return id.charAt(1) == ch1 && id.charAt(2) == ch2 && id.charAt(3) == ch3 && id.charAt(4) == ch4;
    }

    private static boolean cse5(@NotNull CharSequence id, char ch1, char ch2, char ch3, char ch4, char ch5) {
        return id.charAt(1) == ch1 && id.charAt(2) == ch2 && id.charAt(3) == ch3 && id.charAt(4) == ch4 && id.charAt(5) == ch5;
    }

    private static boolean cse6(@NotNull CharSequence id, char ch1, char ch2, char ch3, char ch4, char ch5, char ch6) {
        return id.charAt(1) == ch1 && id.charAt(2) == ch2 && id.charAt(3) == ch3 && id.charAt(4) == ch4 && id.charAt(5) == ch5 && id.charAt(6) == ch6;
    }

    private static boolean cse7(@NotNull CharSequence id, char ch1, char ch2, char ch3, char ch4, char ch5, char ch6, char ch7) {
        return id.charAt(1) == ch1 && id.charAt(2) == ch2 && id.charAt(3) == ch3 && id.charAt(4) == ch4 && id.charAt(5) == ch5 && id.charAt(6) == ch6 && id.charAt(7) == ch7;
    }

    @NotNull
    private TokenType getKeyword(@NotNull CharSequence id) {
        if (id.length() == 1 || id.length() > 10) {
            return TokenType.ILLEGAL;
        }
        block0 : switch (id.length()) {
            case 2: {
                switch (id.charAt(0)) {
                    case 'i': {
                        switch (id.charAt(1)) {
                            case 'f': {
                                return TokenType.IF;
                            }
                            case 'n': {
                                return TokenType.IN;
                            }
                        }
                        break block0;
                    }
                    case 'd': {
                        if (id.charAt(1) != 'o') break block0;
                        return TokenType.DO;
                    }
                }
                break;
            }
            case 3: {
                switch (id.charAt(0)) {
                    case 'v': {
                        if (!Tokenizer.cse2(id, 'a', 'r')) break block0;
                        return TokenType.VAR;
                    }
                    case 'f': {
                        if (!Tokenizer.cse2(id, 'o', 'r')) break block0;
                        return TokenType.FOR;
                    }
                    case 'n': {
                        if (!Tokenizer.cse2(id, 'e', 'w')) break block0;
                        return TokenType.NEW;
                    }
                    case 't': {
                        if (!Tokenizer.cse2(id, 'r', 'y')) break block0;
                        return TokenType.TRY;
                    }
                    case 'l': {
                        if (!Tokenizer.cse2(id, 'e', 't')) break block0;
                        return TokenType.LET;
                    }
                }
                break;
            }
            case 4: {
                switch (id.charAt(0)) {
                    case 't': {
                        if (!Tokenizer.cse3(id, 'h', 'i', 's')) break block0;
                        return TokenType.THIS;
                    }
                    case 'e': {
                        if (Tokenizer.cse3(id, 'l', 's', 'e')) {
                            return TokenType.ELSE;
                        }
                        if (!Tokenizer.cse3(id, 'n', 'u', 'm')) break block0;
                        return TokenType.FUTURE_RESERVED_WORD;
                    }
                    case 'c': {
                        if (!Tokenizer.cse3(id, 'a', 's', 'e')) break block0;
                        return TokenType.CASE;
                    }
                    case 'v': {
                        if (!Tokenizer.cse3(id, 'o', 'i', 'd')) break block0;
                        return TokenType.VOID;
                    }
                    case 'w': {
                        if (!Tokenizer.cse3(id, 'i', 't', 'h')) break block0;
                        return TokenType.WITH;
                    }
                }
                break;
            }
            case 5: {
                switch (id.charAt(0)) {
                    case 'w': {
                        if (!Tokenizer.cse4(id, 'h', 'i', 'l', 'e')) break block0;
                        return TokenType.WHILE;
                    }
                    case 'b': {
                        if (!Tokenizer.cse4(id, 'r', 'e', 'a', 'k')) break block0;
                        return TokenType.BREAK;
                    }
                    case 'c': {
                        if (Tokenizer.cse4(id, 'a', 't', 'c', 'h')) {
                            return TokenType.CATCH;
                        }
                        if (Tokenizer.cse4(id, 'o', 'n', 's', 't')) {
                            return TokenType.CONST;
                        }
                        if (!Tokenizer.cse4(id, 'l', 'a', 's', 's')) break block0;
                        return TokenType.FUTURE_RESERVED_WORD;
                    }
                    case 't': {
                        if (!Tokenizer.cse4(id, 'h', 'r', 'o', 'w')) break block0;
                        return TokenType.THROW;
                    }
                    case 'y': {
                        if (!Tokenizer.cse4(id, 'i', 'e', 'l', 'd')) break block0;
                        return this.strict ? TokenType.FUTURE_STRICT_RESERVED_WORD : TokenType.ILLEGAL;
                    }
                    case 's': {
                        if (!Tokenizer.cse4(id, 'u', 'p', 'e', 'r')) break block0;
                        return TokenType.FUTURE_RESERVED_WORD;
                    }
                }
                break;
            }
            case 6: {
                switch (id.charAt(0)) {
                    case 'r': {
                        if (!Tokenizer.cse5(id, 'e', 't', 'u', 'r', 'n')) break block0;
                        return TokenType.RETURN;
                    }
                    case 't': {
                        if (!Tokenizer.cse5(id, 'y', 'p', 'e', 'o', 'f')) break block0;
                        return TokenType.TYPEOF;
                    }
                    case 'd': {
                        if (!Tokenizer.cse5(id, 'e', 'l', 'e', 't', 'e')) break block0;
                        return TokenType.DELETE;
                    }
                    case 's': {
                        if (Tokenizer.cse5(id, 'w', 'i', 't', 'c', 'h')) {
                            return TokenType.SWITCH;
                        }
                        if (!this.strict || !Tokenizer.cse5(id, 't', 'a', 't', 'i', 'c')) break block0;
                        return TokenType.FUTURE_STRICT_RESERVED_WORD;
                    }
                    case 'e': {
                        if (!Tokenizer.cse5(id, 'x', 'p', 'o', 'r', 't')) break block0;
                        return TokenType.FUTURE_RESERVED_WORD;
                    }
                    case 'i': {
                        if (!Tokenizer.cse5(id, 'm', 'p', 'o', 'r', 't')) break block0;
                        return TokenType.FUTURE_RESERVED_WORD;
                    }
                    case 'p': {
                        if (!this.strict || !Tokenizer.cse5(id, 'u', 'b', 'l', 'i', 'c')) break block0;
                        return TokenType.FUTURE_STRICT_RESERVED_WORD;
                    }
                }
                break;
            }
            case 7: {
                switch (id.charAt(0)) {
                    case 'd': {
                        if (!Tokenizer.cse6(id, 'e', 'f', 'a', 'u', 'l', 't')) break;
                        return TokenType.DEFAULT;
                    }
                    case 'f': {
                        if (!Tokenizer.cse6(id, 'i', 'n', 'a', 'l', 'l', 'y')) break;
                        return TokenType.FINALLY;
                    }
                    case 'e': {
                        if (!Tokenizer.cse6(id, 'x', 't', 'e', 'n', 'd', 's')) break;
                        return TokenType.FUTURE_RESERVED_WORD;
                    }
                    case 'p': {
                        if (!this.strict) break;
                        String s = id.toString();
                        if (!"private".equals(s) && !"package".equals(s)) break block0;
                        return TokenType.FUTURE_STRICT_RESERVED_WORD;
                    }
                }
                break;
            }
            case 8: {
                switch (id.charAt(0)) {
                    case 'f': {
                        if (!Tokenizer.cse7(id, 'u', 'n', 'c', 't', 'i', 'o', 'n')) break block0;
                        return TokenType.FUNCTION;
                    }
                    case 'c': {
                        if (!Tokenizer.cse7(id, 'o', 'n', 't', 'i', 'n', 'u', 'e')) break block0;
                        return TokenType.CONTINUE;
                    }
                    case 'd': {
                        if (!Tokenizer.cse7(id, 'e', 'b', 'u', 'g', 'g', 'e', 'r')) break block0;
                        return TokenType.DEBUGGER;
                    }
                }
                break;
            }
            case 9: {
                String s;
                if (!this.strict || id.charAt(0) != 'p' && id.charAt(0) != 'i' || !"protected".equals(s = id.toString()) && !"interface".equals(s)) break;
                return TokenType.FUTURE_STRICT_RESERVED_WORD;
            }
            case 10: {
                String s = id.toString();
                if ("instanceof".equals(s)) {
                    return TokenType.INSTANCEOF;
                }
                if (!this.strict || !"implements".equals(s)) break;
                return TokenType.FUTURE_STRICT_RESERVED_WORD;
            }
        }
        return TokenType.ILLEGAL;
    }

    @NotNull
    private JsError createILLEGAL() {
        this.startIndex = this.index;
        this.startLine = this.line;
        this.startLineStart = this.lineStart;
        return this.createError("Unexpected token ILLEGAL", new Object[0]);
    }

    JsError createUnexpected(@NotNull Token token) {
        switch (token.type.klass) {
            case Eof: {
                return this.createError("Unexpected end of input", new Object[0]);
            }
            case NumericLiteral: {
                return this.createError("Unexpected number", new Object[0]);
            }
            case StringLiteral: {
                return this.createError("Unexpected string", new Object[0]);
            }
            case Ident: {
                return this.createError("Unexpected identifier", new Object[0]);
            }
            case Keyword: {
                if (token.type == TokenType.FUTURE_RESERVED_WORD) {
                    return this.createError("Unexpected reserved word", new Object[0]);
                }
                if (token.type == TokenType.FUTURE_STRICT_RESERVED_WORD) {
                    return this.createError("Use of future reserved word in strict mode", new Object[0]);
                }
                return this.createError("Unexpected token %s", token.slice.getString());
            }
            case Punctuator: {
                return this.createError("Unexpected token %s", token.type.toString());
            }
        }
        return this.createError("Unexpected token %s", token.getValueString());
    }

    @NotNull
    JsError createError(@NotNull String message, Object ... args) {
        String msg = String.format(message, args);
        return new JsError(this.startIndex, this.startLine + 1, this.startIndex - this.startLineStart, msg);
    }

    @NotNull
    JsError createErrorWithToken(@NotNull SourceLocation location, @NotNull String message, Object ... args) {
        String msg = String.format(message, args);
        return new JsError(location.offset, location.line + 1, location.column, msg);
    }

    @NotNull
    SourceLocation getLocation() {
        if (this.lastCachedSourceLocation != this.index) {
            this.cachedSourceLocation = new SourceLocation(this.startLine, this.startIndex - this.startLineStart, this.startIndex);
            this.lastCachedSourceLocation = this.index;
        }
        return this.cachedSourceLocation;
    }

    @NotNull
    private SourceRange getSlice(int start) {
        return new SourceRange(start, this.index, this.source);
    }

    @NotNull
    SourceRange getSliceBeforeLookahead(int start) {
        return new SourceRange(start, this.lastIndex, this.source);
    }

    private void skipSingleLineComment(int offset) {
        this.index += offset;
        while (this.index < this.source.length()) {
            char ch = this.source.charAt(this.index);
            ++this.index;
            if (!Utils.isLineTerminator(ch)) continue;
            this.hasLineTerminatorBeforeNext = true;
            if (ch == '\r' && this.index < this.source.length() && this.source.charAt(this.index) == '\n') {
                ++this.index;
            }
            this.lineStart = this.index;
            ++this.line;
            return;
        }
    }

    private void skipMultiLineComment() throws JsError {
        this.index += 2;
        int length = this.source.length();
        int i = this.index;
        block5: while (i < length) {
            char ch = this.source.charAt(i);
            if (ch < '\u0080') {
                switch (ch) {
                    case '*': {
                        if (i + 1 < length && this.source.charAt(i + 1) == '/') {
                            this.index = i + 2;
                            return;
                        }
                        ++i;
                        continue block5;
                    }
                    case '\n': {
                        this.hasLineTerminatorBeforeNext = true;
                        this.lineStart = ++i;
                        ++this.line;
                        continue block5;
                    }
                    case '\r': {
                        this.hasLineTerminatorBeforeNext = true;
                        if (i < length - 1 && this.source.charAt(i + 1) == '\n') {
                            ++i;
                        }
                        this.lineStart = ++i;
                        ++this.line;
                        continue block5;
                    }
                }
                ++i;
                continue;
            }
            if (ch == '\u2028' || ch == '\u2029') {
                this.lineStart = ++i;
                ++this.line;
                continue;
            }
            ++i;
        }
        this.index = i;
        throw this.createILLEGAL();
    }

    private void skipComment() throws JsError {
        boolean isLineStart = this.index == 0;
        int length = this.source.length();
        while (this.index < length) {
            char ch = this.source.charAt(this.index);
            if (Utils.isWhitespace(ch)) {
                ++this.index;
                continue;
            }
            if (Utils.isLineTerminator(ch)) {
                this.hasLineTerminatorBeforeNext = true;
                ++this.index;
                if (ch != '\r' || this.index >= length || this.source.charAt(this.index) == '\n') {
                    // empty if block
                }
                this.lineStart = ++this.index;
                ++this.line;
                isLineStart = true;
                continue;
            }
            if (ch == '/') {
                if (this.index + 1 >= length) break;
                ch = this.source.charAt(this.index + 1);
                if (ch == '/') {
                    this.skipSingleLineComment(2);
                    isLineStart = true;
                    continue;
                }
                if (ch != '*') break;
                this.skipMultiLineComment();
                continue;
            }
            if (isLineStart && ch == '-') {
                if (this.index + 2 >= length || this.source.charAt(this.index + 1) != '-' || this.source.charAt(this.index + 2) != '>') break;
                this.skipSingleLineComment(3);
                continue;
            }
            if (ch != '<' || this.index + 4 > length || this.source.charAt(this.index + 1) != '!' || this.source.charAt(this.index + 2) != '-' || this.source.charAt(this.index + 3) != '-') break;
            this.skipSingleLineComment(4);
        }
    }

    private int scanHexEscape4() {
        if (this.index + 4 > this.source.length()) {
            return -1;
        }
        int r1 = Utils.getHexValue(this.source.charAt(this.index));
        if (r1 == -1) {
            return -1;
        }
        int r2 = Utils.getHexValue(this.source.charAt(this.index + 1));
        if (r2 == -1) {
            return -1;
        }
        int r3 = Utils.getHexValue(this.source.charAt(this.index + 2));
        if (r3 == -1) {
            return -1;
        }
        int r4 = Utils.getHexValue(this.source.charAt(this.index + 3));
        if (r4 == -1) {
            return -1;
        }
        this.index += 4;
        return r1 << 12 | r2 << 8 | r3 << 4 | r4;
    }

    private int scanHexEscape2() {
        if (this.index + 2 > this.source.length()) {
            return -1;
        }
        int r1 = Utils.getHexValue(this.source.charAt(this.index));
        if (r1 == -1) {
            return -1;
        }
        int r2 = Utils.getHexValue(this.source.charAt(this.index + 1));
        if (r2 == -1) {
            return -1;
        }
        this.index += 2;
        return r1 << 4 | r2;
    }

    @NotNull
    private CharSequence getEscapedIdentifier() throws JsError {
        int ich;
        char ch = this.source.charAt(this.index);
        ++this.index;
        if (this.index >= this.source.length()) {
            throw this.createILLEGAL();
        }
        StringBuilder id = new StringBuilder();
        if (ch == '\\') {
            if (this.source.charAt(this.index) != 'u') {
                throw this.createILLEGAL();
            }
            ++this.index;
            if (this.index >= this.source.length()) {
                throw this.createILLEGAL();
            }
            ich = this.scanHexEscape4();
            if (ich < 0 || ich == 92 || !Utils.isIdentifierStart((char)ich)) {
                throw this.createILLEGAL();
            }
            ch = (char)ich;
        }
        id.append(ch);
        while (this.index < this.source.length() && (Utils.isIdentifierPart(ch = this.source.charAt(this.index)) || ch == '\\')) {
            ++this.index;
            if (ch == '\\') {
                if (this.index >= this.source.length()) {
                    throw this.createILLEGAL();
                }
                if (this.source.charAt(this.index) != 'u') {
                    throw this.createILLEGAL();
                }
                ++this.index;
                if (this.index >= this.source.length()) {
                    throw this.createILLEGAL();
                }
                ich = this.scanHexEscape4();
                if (ich < 0 || ich == 92 || !Utils.isIdentifierPart((char)ich)) {
                    throw this.createILLEGAL();
                }
                ch = (char)ich;
            }
            id.append(ch);
        }
        return id;
    }

    @NotNull
    private CharSequence getIdentifier() throws JsError {
        int i;
        int start = this.index++;
        int l = this.source.length();
        for (i = this.index; i < l; ++i) {
            char ch = this.source.charAt(i);
            if (ch == '\\') {
                this.index = start;
                return this.getEscapedIdentifier();
            }
            if (!Utils.isIdentifierPart(ch)) break;
        }
        this.index = i;
        return this.getSlice(start);
    }

    @NotNull
    private Token scanIdentifier() throws JsError {
        int start = this.index;
        CharSequence id = this.source.charAt(this.index) == '\\' ? this.getEscapedIdentifier() : this.getIdentifier();
        SourceRange slice = this.getSlice(start);
        if (id.length() == 1) {
            return new IdentifierToken(slice);
        }
        TokenType subType = this.getKeyword(id);
        if (subType != TokenType.ILLEGAL) {
            return new KeywordToken(subType, slice);
        }
        if (id.length() == 4) {
            if ("null".equals(id = id.toString())) {
                return new NullLiteralToken(slice);
            }
            if ("true".equals(id)) {
                return new TrueLiteralToken(slice);
            }
        }
        if (id.length() == 5 && "false".equals(id.toString())) {
            return new FalseLiteralToken(slice);
        }
        return new IdentifierToken(slice);
    }

    @NotNull
    private TokenType scanPunctuatorHelper() {
        char ch2;
        char ch1 = this.source.charAt(this.index);
        switch (ch1) {
            case '.': {
                return TokenType.PERIOD;
            }
            case '(': {
                return TokenType.LPAREN;
            }
            case ')': 
            case ',': 
            case ';': {
                return ONE_CHAR_PUNCTUATOR[ch1];
            }
            case '{': {
                return TokenType.LBRACE;
            }
            case ':': 
            case '?': 
            case '[': 
            case ']': 
            case '}': 
            case '~': {
                return ONE_CHAR_PUNCTUATOR[ch1];
            }
        }
        if (this.index + 1 < this.source.length() && this.source.charAt(this.index + 1) == '=') {
            switch (ch1) {
                case '=': {
                    if (this.index + 2 < this.source.length() && this.source.charAt(this.index + 2) == '=') {
                        return TokenType.EQ_STRICT;
                    }
                    return TokenType.EQ;
                }
                case '!': {
                    if (this.index + 2 < this.source.length() && this.source.charAt(this.index + 2) == '=') {
                        return TokenType.NE_STRICT;
                    }
                    return TokenType.NE;
                }
                case '|': {
                    return TokenType.ASSIGN_BIT_OR;
                }
                case '+': {
                    return TokenType.ASSIGN_ADD;
                }
                case '-': {
                    return TokenType.ASSIGN_SUB;
                }
                case '*': {
                    return TokenType.ASSIGN_MUL;
                }
                case '<': {
                    return TokenType.LTE;
                }
                case '>': {
                    return TokenType.GTE;
                }
                case '/': {
                    return TokenType.ASSIGN_DIV;
                }
                case '%': {
                    return TokenType.ASSIGN_MOD;
                }
                case '^': {
                    return TokenType.ASSIGN_BIT_XOR;
                }
                case '&': {
                    return TokenType.ASSIGN_BIT_AND;
                }
            }
        }
        if (this.index + 1 < this.source.length() && ch1 == (ch2 = this.source.charAt(this.index + 1))) {
            if (this.index + 2 < this.source.length()) {
                char ch3 = this.source.charAt(this.index + 2);
                if (ch1 == '>' && ch3 == '>') {
                    if (this.index + 3 < this.source.length() && this.source.charAt(this.index + 3) == '=') {
                        return TokenType.ASSIGN_SHR_UNSIGNED;
                    }
                    return TokenType.SHR_UNSIGNED;
                }
                if (ch1 == '<' && ch3 == '=') {
                    return TokenType.ASSIGN_SHL;
                }
                if (ch1 == '>' && ch3 == '=') {
                    return TokenType.ASSIGN_SHR;
                }
            }
            switch (ch1) {
                case '+': {
                    return TokenType.INC;
                }
                case '-': {
                    return TokenType.DEC;
                }
                case '<': {
                    return TokenType.SHL;
                }
                case '>': {
                    return TokenType.SHR;
                }
                case '&': {
                    return TokenType.AND;
                }
                case '|': {
                    return TokenType.OR;
                }
            }
        }
        return ONE_CHAR_PUNCTUATOR[ch1];
    }

    @NotNull
    private Token scanPunctuator() {
        int start = this.index;
        TokenType subType = this.scanPunctuatorHelper();
        this.index += subType.toString().length();
        return new PunctuatorToken(subType, this.getSlice(start));
    }

    @NotNull
    private Token scanHexLiteral(int start) throws JsError {
        char ch;
        int hex;
        int i;
        BigInteger value = BigInteger.ZERO;
        for (i = this.index; i < this.source.length() && (hex = Utils.getHexValue(ch = this.source.charAt(i))) != -1; ++i) {
            value = value.shiftLeft(4);
            value = value.add(BigInteger.valueOf(hex));
        }
        if (this.index == i) {
            throw this.createILLEGAL();
        }
        if (i < this.source.length() && Utils.isIdentifierStart(this.source.charAt(i))) {
            throw this.createILLEGAL();
        }
        this.index = i;
        return new NumericLiteralToken(this.getSlice(start), value.doubleValue());
    }

    @NotNull
    private Token scanOctalLiteral(int start) throws JsError {
        char ch;
        BigInteger value = BigInteger.ZERO;
        while (this.index < this.source.length() && '0' <= (ch = this.source.charAt(this.index)) && ch <= '7') {
            ++this.index;
            value = value.shiftLeft(3);
            value = value.add(BigInteger.valueOf(ch - 48));
        }
        if (this.index < this.source.length() && (Utils.isIdentifierStart(this.source.charAt(this.index)) || Utils.isDecimalDigit(this.source.charAt(this.index)))) {
            throw this.createILLEGAL();
        }
        return new NumericLiteralToken(this.getSlice(start), value.doubleValue(), true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private Token scanNumericLiteral() throws JsError {
        BigInteger value = BigInteger.ZERO;
        char ch = this.source.charAt(this.index);
        int start = this.index++;
        if (ch == '0') {
            if (this.index >= this.source.length()) return new NumericLiteralToken(this.getSlice(start), 0.0);
            ch = this.source.charAt(this.index);
            if (ch == 'x' || ch == 'X') {
                ++this.index;
                return this.scanHexLiteral(start);
            }
            if ('0' <= ch && ch <= '9') {
                return this.scanOctalLiteral(start);
            }
        } else if (ch != '.') {
            ch = this.source.charAt(this.index);
            while ('0' <= ch && ch <= '9') {
                value = value.multiply(BigInteger.TEN);
                value = value.add(BigInteger.valueOf(ch - 48));
                ++this.index;
                if (this.index == this.source.length()) {
                    return new NumericLiteralToken(this.getSlice(start), value.doubleValue());
                }
                ch = this.source.charAt(this.index);
            }
        }
        int e = 0;
        if (ch == '.') {
            ++this.index;
            if (this.index == this.source.length()) {
                return new NumericLiteralToken(this.getSlice(start), value.doubleValue());
            }
            ch = this.source.charAt(this.index);
            while ('0' <= ch && ch <= '9') {
                ++e;
                value = value.multiply(BigInteger.TEN);
                value = value.add(BigInteger.valueOf(ch - 48));
                ++this.index;
                if (this.index == this.source.length()) {
                    return new NumericLiteralToken(this.getSlice(start), new BigDecimal(value, e).doubleValue());
                }
                ch = this.source.charAt(this.index);
            }
        }
        if (ch == 'e' || ch == 'E') {
            ++this.index;
            if (this.index == this.source.length()) {
                throw this.createILLEGAL();
            }
            ch = this.source.charAt(this.index);
            boolean neg = false;
            if (ch == '+' || ch == '-') {
                neg = ch == '-';
                ++this.index;
                if (this.index == this.source.length()) {
                    throw this.createILLEGAL();
                }
                ch = this.source.charAt(this.index);
            }
            int f = 0;
            if ('0' > ch || ch > '9') throw this.createILLEGAL();
            while ('0' <= ch && ch <= '9') {
                f *= 10;
                f += ch - 48;
                ++this.index;
                if (this.index == this.source.length()) break;
                ch = this.source.charAt(this.index);
            }
            e += neg ? f : -f;
        }
        if (!Utils.isIdentifierStart(ch)) return new NumericLiteralToken(this.getSlice(start), new BigDecimal(value, e).doubleValue());
        throw this.createILLEGAL();
    }

    @NotNull
    private Token scanStringLiteral() throws JsError {
        StringBuilder str = new StringBuilder();
        char quote = this.source.charAt(this.index);
        int start = this.index++;
        boolean octal = false;
        while (this.index < this.source.length()) {
            char ch = this.source.charAt(this.index);
            if (ch == quote) {
                ++this.index;
                return new StringLiteralToken(this.getSlice(start), str.toString(), octal);
            }
            if (ch == '\\') {
                ++this.index;
                if (this.index == this.source.length()) {
                    throw this.createILLEGAL();
                }
                ch = this.source.charAt(this.index);
                if (!Utils.isLineTerminator(ch)) {
                    switch (ch) {
                        case 'n': {
                            str.append('\n');
                            ++this.index;
                            break;
                        }
                        case 'r': {
                            str.append('\r');
                            ++this.index;
                            break;
                        }
                        case 't': {
                            str.append('\t');
                            ++this.index;
                            break;
                        }
                        case 'u': 
                        case 'x': {
                            int unescaped;
                            int restore = this.index++;
                            if (this.index >= this.source.length()) {
                                throw this.createILLEGAL();
                            }
                            int n = unescaped = ch == 'u' ? this.scanHexEscape4() : this.scanHexEscape2();
                            if (unescaped >= 0) {
                                str.append((char)unescaped);
                                break;
                            }
                            this.index = restore;
                            str.append(ch);
                            ++this.index;
                            break;
                        }
                        case 'b': {
                            str.append('\b');
                            ++this.index;
                            break;
                        }
                        case 'f': {
                            str.append('\f');
                            ++this.index;
                            break;
                        }
                        case 'v': {
                            str.append('\u000b');
                            ++this.index;
                            break;
                        }
                        default: {
                            if ('0' <= ch && ch <= '7') {
                                octal = true;
                                int octLen = 1;
                                if ('0' <= ch && ch <= '3') {
                                    octLen = 0;
                                }
                                int code = 0;
                                while (octLen < 3 && '0' <= ch && ch <= '7') {
                                    code *= 8;
                                    ++octLen;
                                    code += ch - 48;
                                    ++this.index;
                                    if (this.index == this.source.length()) {
                                        throw this.createILLEGAL();
                                    }
                                    ch = this.source.charAt(this.index);
                                }
                                str.append((char)code);
                                break;
                            }
                            str.append(ch);
                            ++this.index;
                            break;
                        }
                    }
                    continue;
                }
                this.hasLineTerminatorBeforeNext = true;
                ++this.index;
                if (ch != '\r' || this.source.charAt(this.index) == '\n') {
                    // empty if block
                }
                this.lineStart = ++this.index;
                ++this.line;
                continue;
            }
            if (Utils.isLineTerminator(ch)) {
                throw this.createILLEGAL();
            }
            str.append(ch);
            ++this.index;
        }
        throw this.createILLEGAL();
    }

    @NotNull
    protected Token rescanRegExp() throws JsError {
        this.index = this.startIndex;
        this.line = this.startLine;
        this.lineStart = this.startLineStart;
        this.lookahead = this.scanRegExp();
        return this.lookahead;
    }

    @NotNull
    private Token scanRegExp() throws JsError {
        char ch;
        int start = this.index++;
        StringBuilder str = new StringBuilder();
        str.append('/');
        boolean terminated = false;
        boolean classMarker = false;
        while (this.index < this.source.length()) {
            ch = this.source.charAt(this.index);
            if (ch == '\\') {
                str.append(ch);
                ++this.index;
                ch = this.source.charAt(this.index);
                if (Utils.isLineTerminator(ch)) {
                    throw this.createError("Invalid regular expression: missing /", new Object[0]);
                }
                str.append(ch);
                ++this.index;
                continue;
            }
            if (Utils.isLineTerminator(ch)) {
                throw this.createError("Invalid regular expression: missing /", new Object[0]);
            }
            if (classMarker) {
                if (ch == ']') {
                    classMarker = false;
                }
            } else {
                if (ch == '/') {
                    terminated = true;
                    str.append(ch);
                    ++this.index;
                    break;
                }
                if (ch == '[') {
                    classMarker = true;
                }
            }
            str.append(ch);
            ++this.index;
        }
        if (!terminated) {
            throw this.createError("Invalid regular expression: missing /", new Object[0]);
        }
        while (this.index < this.source.length() && (Utils.isIdentifierPart(ch = this.source.charAt(this.index)) || ch == '\\')) {
            ++this.index;
            str.append(ch);
        }
        return new RegularExpressionLiteralToken(this.getSlice(start), str.toString());
    }

    @NotNull
    private Token advance() throws JsError {
        char ch = this.source.charAt(this.index);
        if (ch < '\u0080') {
            if (PUNCTUATOR_START[ch]) {
                return this.scanPunctuator();
            }
            if (IDENTIFIER_START[ch]) {
                return this.scanIdentifier();
            }
            if (ch == '.') {
                if (this.index + 1 < this.source.length() && Utils.isDecimalDigit(this.source.charAt(this.index + 1))) {
                    return this.scanNumericLiteral();
                }
                return this.scanPunctuator();
            }
            if (ch == '\'' || ch == '\"') {
                return this.scanStringLiteral();
            }
            if (Utils.isDecimalDigit(ch)) {
                return this.scanNumericLiteral();
            }
            if (ch == '/') {
                return this.scanPunctuator();
            }
            throw this.createILLEGAL();
        }
        if (Utils.isIdentifierStart(ch)) {
            return this.scanIdentifier();
        }
        throw this.createILLEGAL();
    }

    protected boolean eof() {
        return this.lookahead.type == TokenType.EOS;
    }

    @NotNull
    private Token collectToken() throws JsError {
        this.hasLineTerminatorBeforeNext = false;
        int start = this.index;
        this.lastIndex = this.index;
        this.skipComment();
        this.startIndex = this.index;
        this.startLine = this.line;
        this.startLineStart = this.lineStart;
        SourceRange lastWhitespace = this.getSlice(start);
        if (this.index >= this.source.length()) {
            return new EOFToken(this.getSlice(start));
        }
        Token token = this.advance();
        token.leadingWhitespace = lastWhitespace;
        return token;
    }

    @NotNull
    protected Token lex() throws JsError {
        if (this.lookahead.type == TokenType.EOS) {
            return this.lookahead;
        }
        Token prevToken = this.lookahead;
        this.lookahead = this.collectToken();
        return prevToken;
    }
}

