/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.minifier.passes.reduction;

import com.shapesecurity.functional.F;
import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.shift.ast.Block;
import com.shapesecurity.shift.ast.FunctionBody;
import com.shapesecurity.shift.ast.Statement;
import com.shapesecurity.shift.ast.SwitchCase;
import com.shapesecurity.shift.ast.SwitchDefault;
import com.shapesecurity.shift.ast.expression.PrefixExpression;
import com.shapesecurity.shift.ast.operators.PrefixOperator;
import com.shapesecurity.shift.ast.statement.DoWhileStatement;
import com.shapesecurity.shift.ast.statement.EmptyStatement;
import com.shapesecurity.shift.ast.statement.ExpressionStatement;
import com.shapesecurity.shift.ast.statement.IfStatement;
import com.shapesecurity.shift.ast.statement.SwitchStatement;
import com.shapesecurity.shift.ast.statement.WhileStatement;
import com.shapesecurity.shift.ast.statement.WithStatement;
import com.shapesecurity.shift.minifier.ReductionRule;
import com.shapesecurity.shift.visitor.DirtyState;
import org.jetbrains.annotations.NotNull;

public class RemoveEmptyStatements
extends ReductionRule {
    public static final RemoveEmptyStatements INSTANCE = new RemoveEmptyStatements();
    private static final F<Statement, Boolean> isNotEmptyStatement = iStatement -> !(iStatement instanceof EmptyStatement);

    private RemoveEmptyStatements() {
    }

    @Override
    @NotNull
    public DirtyState<Block> transform(@NotNull Block node) {
        ImmutableList<Statement> filteredStatements = node.statements.filter(isNotEmptyStatement);
        return filteredStatements.length == node.statements.length ? DirtyState.clean(node) : DirtyState.dirty(new Block(filteredStatements));
    }

    @Override
    @NotNull
    public DirtyState<FunctionBody> transform(@NotNull FunctionBody node) {
        ImmutableList<Statement> filteredStatements = node.statements.filter(isNotEmptyStatement);
        return filteredStatements.length == node.statements.length ? DirtyState.clean(node) : DirtyState.dirty(new FunctionBody(node.directives, filteredStatements));
    }

    @Override
    @NotNull
    public DirtyState<SwitchCase> transform(@NotNull SwitchCase node) {
        ImmutableList<Statement> filteredStatements = node.consequent.filter(isNotEmptyStatement);
        return filteredStatements.length == node.consequent.length ? DirtyState.clean(node) : DirtyState.dirty(new SwitchCase(node.test, filteredStatements));
    }

    @Override
    @NotNull
    public DirtyState<SwitchDefault> transform(@NotNull SwitchDefault node) {
        ImmutableList<Statement> filteredStatements = node.consequent.filter(isNotEmptyStatement);
        return filteredStatements.length == node.consequent.length ? DirtyState.clean(node) : DirtyState.dirty(new SwitchDefault(filteredStatements));
    }

    @Override
    @NotNull
    public DirtyState<Statement> transform(@NotNull DoWhileStatement node) {
        return node.body instanceof EmptyStatement ? DirtyState.dirty(new WhileStatement(node.test, node.body)) : DirtyState.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Statement> transform(@NotNull IfStatement node) {
        boolean alternateEmpty;
        boolean consequentEmpty = node.consequent instanceof EmptyStatement;
        boolean bl = alternateEmpty = node.alternate.isJust() && node.alternate.just() instanceof EmptyStatement;
        if ((alternateEmpty || node.alternate.isNothing()) && consequentEmpty) {
            return DirtyState.dirty(new ExpressionStatement(node.test));
        }
        if (alternateEmpty) {
            return DirtyState.dirty(new IfStatement(node.test, node.consequent));
        }
        if (consequentEmpty) {
            return DirtyState.dirty(new IfStatement(new PrefixExpression(PrefixOperator.LogicalNot, node.test), node.alternate.just()));
        }
        return DirtyState.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Statement> transform(@NotNull WithStatement node) {
        return node.body instanceof EmptyStatement ? DirtyState.dirty(new ExpressionStatement(node.object)) : DirtyState.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<Statement> transform(@NotNull SwitchStatement node) {
        return DirtyState.clean(node);
    }
}

