/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.minifier.passes.reduction;

import com.shapesecurity.shift.ast.Statement;
import com.shapesecurity.shift.ast.expression.BinaryExpression;
import com.shapesecurity.shift.ast.operators.BinaryOperator;
import com.shapesecurity.shift.ast.statement.IfStatement;
import com.shapesecurity.shift.minifier.ReductionRule;
import com.shapesecurity.shift.visitor.DirtyState;
import org.jetbrains.annotations.NotNull;

public class ReduceNestedIfStatements
extends ReductionRule {
    public static final ReduceNestedIfStatements INSTANCE = new ReduceNestedIfStatements();

    @Override
    @NotNull
    public DirtyState<Statement> transform(@NotNull IfStatement node) {
        if (node.alternate.isNothing() && node.consequent instanceof IfStatement) {
            IfStatement consequent = (IfStatement)node.consequent;
            if (consequent.alternate.isNothing()) {
                return DirtyState.dirty(new IfStatement(new BinaryExpression(BinaryOperator.LogicalAnd, node.test, consequent.test), consequent.consequent));
            }
        }
        return DirtyState.clean(node);
    }
}

