/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.minifier.passes.reduction;

import com.shapesecurity.functional.F;
import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.shift.ast.Block;
import com.shapesecurity.shift.ast.FunctionBody;
import com.shapesecurity.shift.ast.Statement;
import com.shapesecurity.shift.ast.SwitchCase;
import com.shapesecurity.shift.ast.SwitchDefault;
import com.shapesecurity.shift.ast.statement.BlockStatement;
import com.shapesecurity.shift.minifier.ReductionRule;
import com.shapesecurity.shift.visitor.DirtyState;
import org.jetbrains.annotations.NotNull;

public class FlattenBlocks
extends ReductionRule {
    public static final FlattenBlocks INSTANCE = new FlattenBlocks();
    private static final F<Statement, ImmutableList<Statement>> flattenBlockStatements = iStatement -> iStatement instanceof BlockStatement ? ((BlockStatement)iStatement).block.statements : ImmutableList.list(iStatement, new Statement[0]);
    private static final F<Statement, Boolean> isBlockStatement = iStatement -> iStatement instanceof BlockStatement;

    @Override
    @NotNull
    public DirtyState<Block> transform(@NotNull Block node) {
        ImmutableList<Statement> flattenedStatements = node.statements.bind(flattenBlockStatements);
        return node.statements.exists(isBlockStatement) ? DirtyState.dirty(new Block(flattenedStatements)) : DirtyState.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<FunctionBody> transform(@NotNull FunctionBody node) {
        ImmutableList<Statement> flattenedStatements = node.statements.bind(flattenBlockStatements);
        return node.statements.exists(isBlockStatement) ? DirtyState.dirty(new FunctionBody(node.directives, flattenedStatements)) : DirtyState.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<SwitchCase> transform(@NotNull SwitchCase node) {
        ImmutableList<Statement> flattenedStatements = node.consequent.bind(flattenBlockStatements);
        return node.consequent.exists(isBlockStatement) ? DirtyState.dirty(new SwitchCase(node.test, flattenedStatements)) : DirtyState.clean(node);
    }

    @Override
    @NotNull
    public DirtyState<SwitchDefault> transform(@NotNull SwitchDefault node) {
        ImmutableList<Statement> flattenedStatements = node.consequent.bind(flattenBlockStatements);
        return node.consequent.exists(isBlockStatement) ? DirtyState.dirty(new SwitchDefault(flattenedStatements)) : DirtyState.clean(node);
    }
}

