/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.minifier.passes.expansion;

import com.shapesecurity.shift.ast.Expression;
import com.shapesecurity.shift.ast.Statement;
import com.shapesecurity.shift.ast.expression.CallExpression;
import com.shapesecurity.shift.ast.expression.FunctionExpression;
import com.shapesecurity.shift.ast.expression.MemberExpression;
import com.shapesecurity.shift.ast.expression.ObjectExpression;
import com.shapesecurity.shift.ast.expression.PostfixExpression;
import com.shapesecurity.shift.ast.expression.PrefixExpression;
import com.shapesecurity.shift.ast.operators.PrefixOperator;
import com.shapesecurity.shift.ast.statement.ExpressionStatement;
import com.shapesecurity.shift.minifier.ExpansionRule;
import com.shapesecurity.shift.visitor.DirtyState;
import org.jetbrains.annotations.NotNull;

public class TopLevelExpressionWithProhibitedFirstToken
extends ExpansionRule {
    public static final TopLevelExpressionWithProhibitedFirstToken INSTANCE = new TopLevelExpressionWithProhibitedFirstToken();

    private static boolean startsWithProhibitedToken(@NotNull Expression expression) {
        if (expression instanceof FunctionExpression || expression instanceof ObjectExpression) {
            return true;
        }
        if (expression instanceof PostfixExpression) {
            return TopLevelExpressionWithProhibitedFirstToken.startsWithProhibitedToken(((PostfixExpression)expression).operand);
        }
        if (expression instanceof CallExpression) {
            return TopLevelExpressionWithProhibitedFirstToken.startsWithProhibitedToken(((CallExpression)expression).callee);
        }
        if (expression instanceof MemberExpression) {
            return TopLevelExpressionWithProhibitedFirstToken.startsWithProhibitedToken(((MemberExpression)expression).object);
        }
        return false;
    }

    @Override
    @NotNull
    public DirtyState<Statement> transform(@NotNull ExpressionStatement node) {
        if (TopLevelExpressionWithProhibitedFirstToken.startsWithProhibitedToken(node.expression)) {
            return DirtyState.dirty(new ExpressionStatement(new PrefixExpression(PrefixOperator.LogicalNot, node.expression)));
        }
        return DirtyState.clean(node);
    }
}

