/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.minifier.passes.expansion;

import com.shapesecurity.shift.ast.Expression;
import com.shapesecurity.shift.ast.expression.BinaryExpression;
import com.shapesecurity.shift.ast.expression.ComputedMemberExpression;
import com.shapesecurity.shift.ast.expression.LiteralNumericExpression;
import com.shapesecurity.shift.ast.expression.PrefixExpression;
import com.shapesecurity.shift.ast.expression.StaticMemberExpression;
import com.shapesecurity.shift.ast.operators.BinaryOperator;
import com.shapesecurity.shift.ast.operators.PrefixOperator;
import com.shapesecurity.shift.minifier.ExpansionRule;
import com.shapesecurity.shift.visitor.DirtyState;
import org.jetbrains.annotations.NotNull;

public class ReplaceStaticMemberAccessWithDynamicMemberAccess
extends ExpansionRule {
    public static final ReplaceStaticMemberAccessWithDynamicMemberAccess INSTANCE = new ReplaceStaticMemberAccessWithDynamicMemberAccess();

    @Override
    @NotNull
    public DirtyState<Expression> transform(@NotNull StaticMemberExpression node) {
        switch (node.property.name) {
            case "undefined": {
                return DirtyState.dirty(new ComputedMemberExpression(node.object, new PrefixExpression(PrefixOperator.Void, new LiteralNumericExpression(0.0))));
            }
            case "true": 
            case "false": {
                return DirtyState.dirty(new ComputedMemberExpression(node.object, new PrefixExpression(PrefixOperator.LogicalNot, new LiteralNumericExpression("true".equals(node.property.name) ? 0.0 : 1.0))));
            }
            case "Infinity": {
                return DirtyState.dirty(new ComputedMemberExpression(node.object, new BinaryExpression(BinaryOperator.Div, new LiteralNumericExpression(1.0), new LiteralNumericExpression(0.0))));
            }
        }
        return DirtyState.clean(node);
    }
}

