/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.minifier;

import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.shift.ast.Script;
import com.shapesecurity.shift.minifier.ComposedRule;
import com.shapesecurity.shift.minifier.ExpansionRule;
import com.shapesecurity.shift.minifier.MinificationRule;
import com.shapesecurity.shift.minifier.ReductionRule;
import com.shapesecurity.shift.minifier.passes.expansion.ExpandBooleanLiterals;
import com.shapesecurity.shift.minifier.passes.expansion.ReplaceStaticMemberAccessWithDynamicMemberAccess;
import com.shapesecurity.shift.minifier.passes.expansion.TopLevelExpressionWithProhibitedFirstToken;
import com.shapesecurity.shift.minifier.passes.reduction.FlattenBlocks;
import com.shapesecurity.shift.minifier.passes.reduction.ReduceNestedIfStatements;
import com.shapesecurity.shift.minifier.passes.reduction.RemoveEmptyBlocks;
import com.shapesecurity.shift.minifier.passes.reduction.RemoveEmptyStatements;
import com.shapesecurity.shift.minifier.passes.reduction.RemoveEmptyTrailingDefault;
import com.shapesecurity.shift.minifier.passes.reduction.RemoveSingleStatementBlocks;
import com.shapesecurity.shift.minifier.passes.reduction.ReplaceWhileWithFor;
import com.shapesecurity.shift.visitor.FixPointTransformer;
import org.jetbrains.annotations.NotNull;

public class Minifier {
    private static final FixPointTransformer REDUCTION = new FixPointTransformer(new ComposedRule((MinificationRule[])new ReductionRule[]{FlattenBlocks.INSTANCE, ReduceNestedIfStatements.INSTANCE, RemoveEmptyBlocks.INSTANCE, RemoveEmptyStatements.INSTANCE, RemoveEmptyTrailingDefault.INSTANCE, RemoveSingleStatementBlocks.INSTANCE, ReplaceWhileWithFor.INSTANCE}));
    private static final FixPointTransformer EXPANSION = new FixPointTransformer(new ComposedRule((MinificationRule[])new ExpansionRule[]{ReplaceStaticMemberAccessWithDynamicMemberAccess.INSTANCE, ExpandBooleanLiterals.INSTANCE, TopLevelExpressionWithProhibitedFirstToken.INSTANCE}));

    @NotNull
    public static Script minify(@NotNull Script script) {
        return EXPANSION.transform(REDUCTION.transform(script, ImmutableList.nil()), ImmutableList.nil());
    }

    public static Script minify(@NotNull Script script, @NotNull ReductionRule[] reductionRules, @NotNull ExpansionRule[] expansionRules) {
        FixPointTransformer reduction = new FixPointTransformer(new ComposedRule((MinificationRule[])reductionRules));
        FixPointTransformer expansion = new FixPointTransformer(new ComposedRule((MinificationRule[])expansionRules));
        return expansion.transform(reduction.transform(script, ImmutableList.nil()), ImmutableList.nil());
    }

    public static Script minify(@NotNull Script script, @NotNull ImmutableList<ReductionRule> reductionRules, @NotNull ImmutableList<ExpansionRule> expansionRules) {
        MinificationRule[] reductionRulesArray = reductionRules.toArray((ReductionRule[])new ReductionRule[reductionRules.length]);
        MinificationRule[] expansionRulesArray = expansionRules.toArray((ExpansionRule[])new ExpansionRule[expansionRules.length]);
        FixPointTransformer reduction = new FixPointTransformer(new ComposedRule(reductionRulesArray));
        FixPointTransformer expansion = new FixPointTransformer(new ComposedRule(expansionRulesArray));
        return expansion.transform(reduction.transform(script, ImmutableList.nil()), ImmutableList.nil());
    }
}

