/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.fuzzer;

import com.shapesecurity.functional.data.Either;
import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.functional.data.Maybe;
import com.shapesecurity.functional.data.NonEmptyImmutableList;
import com.shapesecurity.shift.ast.Block;
import com.shapesecurity.shift.ast.CatchClause;
import com.shapesecurity.shift.ast.Directive;
import com.shapesecurity.shift.ast.Expression;
import com.shapesecurity.shift.ast.FunctionBody;
import com.shapesecurity.shift.ast.Identifier;
import com.shapesecurity.shift.ast.Script;
import com.shapesecurity.shift.ast.Statement;
import com.shapesecurity.shift.ast.SwitchCase;
import com.shapesecurity.shift.ast.SwitchDefault;
import com.shapesecurity.shift.ast.VariableDeclaration;
import com.shapesecurity.shift.ast.VariableDeclarator;
import com.shapesecurity.shift.ast.directive.UnknownDirective;
import com.shapesecurity.shift.ast.directive.UseStrictDirective;
import com.shapesecurity.shift.ast.expression.ArrayExpression;
import com.shapesecurity.shift.ast.expression.AssignmentExpression;
import com.shapesecurity.shift.ast.expression.BinaryExpression;
import com.shapesecurity.shift.ast.expression.CallExpression;
import com.shapesecurity.shift.ast.expression.ComputedMemberExpression;
import com.shapesecurity.shift.ast.expression.ConditionalExpression;
import com.shapesecurity.shift.ast.expression.FunctionExpression;
import com.shapesecurity.shift.ast.expression.IdentifierExpression;
import com.shapesecurity.shift.ast.expression.LiteralBooleanExpression;
import com.shapesecurity.shift.ast.expression.LiteralInfinityExpression;
import com.shapesecurity.shift.ast.expression.LiteralNullExpression;
import com.shapesecurity.shift.ast.expression.LiteralNumericExpression;
import com.shapesecurity.shift.ast.expression.LiteralRegExpExpression;
import com.shapesecurity.shift.ast.expression.LiteralStringExpression;
import com.shapesecurity.shift.ast.expression.NewExpression;
import com.shapesecurity.shift.ast.expression.ObjectExpression;
import com.shapesecurity.shift.ast.expression.PostfixExpression;
import com.shapesecurity.shift.ast.expression.PrefixExpression;
import com.shapesecurity.shift.ast.expression.StaticMemberExpression;
import com.shapesecurity.shift.ast.expression.ThisExpression;
import com.shapesecurity.shift.ast.operators.AssignmentOperator;
import com.shapesecurity.shift.ast.operators.BinaryOperator;
import com.shapesecurity.shift.ast.operators.PostfixOperator;
import com.shapesecurity.shift.ast.operators.PrefixOperator;
import com.shapesecurity.shift.ast.property.DataProperty;
import com.shapesecurity.shift.ast.property.Getter;
import com.shapesecurity.shift.ast.property.ObjectProperty;
import com.shapesecurity.shift.ast.property.PropertyName;
import com.shapesecurity.shift.ast.property.Setter;
import com.shapesecurity.shift.ast.statement.BlockStatement;
import com.shapesecurity.shift.ast.statement.BreakStatement;
import com.shapesecurity.shift.ast.statement.ContinueStatement;
import com.shapesecurity.shift.ast.statement.DebuggerStatement;
import com.shapesecurity.shift.ast.statement.DoWhileStatement;
import com.shapesecurity.shift.ast.statement.EmptyStatement;
import com.shapesecurity.shift.ast.statement.ExpressionStatement;
import com.shapesecurity.shift.ast.statement.ForInStatement;
import com.shapesecurity.shift.ast.statement.ForStatement;
import com.shapesecurity.shift.ast.statement.FunctionDeclaration;
import com.shapesecurity.shift.ast.statement.IfStatement;
import com.shapesecurity.shift.ast.statement.IterationStatement;
import com.shapesecurity.shift.ast.statement.LabeledStatement;
import com.shapesecurity.shift.ast.statement.ReturnStatement;
import com.shapesecurity.shift.ast.statement.SwitchStatement;
import com.shapesecurity.shift.ast.statement.SwitchStatementWithDefault;
import com.shapesecurity.shift.ast.statement.ThrowStatement;
import com.shapesecurity.shift.ast.statement.TryCatchStatement;
import com.shapesecurity.shift.ast.statement.TryFinallyStatement;
import com.shapesecurity.shift.ast.statement.VariableDeclarationStatement;
import com.shapesecurity.shift.ast.statement.WhileStatement;
import com.shapesecurity.shift.ast.statement.WithStatement;
import com.shapesecurity.shift.fuzzer.GenCtx;
import com.shapesecurity.shift.utils.D2A;
import com.shapesecurity.shift.utils.Utils;
import java.util.HashSet;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public class Fuzzer {
    private static final String identifierStart = "_$abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String identifierPart = "_$abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final char[] identifierStartArr = "_$abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] identifierPartArr = "_$abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();
    private static final int MANY_BOUND = 5;
    private static final int MAX_IDENT_LENGTH = 15;
    private static final int MAX_STRING_LENGTH = 3;
    private static final double STRICT_MODE_PROBABILITY = 0.3;
    private static final double SPECIAL_IDENT_PROBABILITY = 0.5;
    private static final String[] RESERVED_WORDS = new String[]{"false", "null", "true", "let", "if", "in", "do", "var", "for", "new", "try", "this", "else", "case", "void", "with", "enum", "while", "break", "catch", "throw", "const", "class", "super", "return", "typeof", "delete", "switch", "export", "import", "default", "finally", "extends", "function", "continue", "debugger", "instanceof"};
    private static final String[] STRICT_MODE_RESERVED_WORDS = new String[]{"implements", "interface", "package", "private", "protected", "public", "static", "yield", "false", "null", "true", "let", "if", "in", "do", "var", "for", "new", "try", "this", "else", "case", "void", "with", "enum", "while", "break", "catch", "throw", "const", "class", "super", "return", "typeof", "delete", "switch", "export", "import", "default", "finally", "extends", "function", "continue", "debugger", "instanceof"};
    private static final String[] RESTRICTED_WORDS = new String[]{"arguments", "eval"};
    private static final Gen<Expression>[] expressionGens = Fuzzer.array(Fuzzer::randomArrayExpression, Fuzzer::randomAssignmentExpression, Fuzzer::randomBinaryExpression, Fuzzer::randomCallExpression, Fuzzer::randomComputedMemberExpression, Fuzzer::randomConditionalExpression, Fuzzer::randomFunctionExpression, Fuzzer::randomIdentifierExpression, Fuzzer::randomLiteralBooleanExpression, Fuzzer::randomLiteralNullExpression, Fuzzer::randomLiteralInfinityExpression, Fuzzer::randomLiteralNumericExpression, Fuzzer::randomLiteralRegExpExpression, Fuzzer::randomLiteralStringExpression, Fuzzer::randomNewExpression, Fuzzer::randomObjectExpression, Fuzzer::randomPostfixExpression, Fuzzer::randomPrefixExpression, Fuzzer::randomStaticMemberExpression, Fuzzer::randomThisExpression);
    private static final int kGenBreakStatement = 0;
    private static final int kGenContinueStatement = 1;
    private static final int kGenWithStatement = 2;
    private static final int kGenReturnStatement = 3;
    private static final int kGenLabeledStatement = 4;
    private static final Gen<Statement>[] nonIterationStatementGens = Fuzzer.array(Fuzzer::randomBlockStatement, Fuzzer::randomDebuggerStatement, Fuzzer::randomEmptyStatement, Fuzzer::randomExpressionStatement, Fuzzer::randomFunctionDeclaration, Fuzzer::randomIfStatement, Fuzzer::randomSwitchStatement, Fuzzer::randomSwitchStatementWithDefault, Fuzzer::randomThrowStatement, Fuzzer::randomTryCatchStatement, Fuzzer::randomTryFinallyStatement, Fuzzer::randomVariableDeclarationStatement);
    private static final Gen<IterationStatement>[] iterationStatementGens = Fuzzer.array(Fuzzer::randomDoWhileStatement, Fuzzer::randomForInStatement, Fuzzer::randomForStatement, Fuzzer::randomWhileStatement);
    private static final int totalStatements = nonIterationStatementGens.length + iterationStatementGens.length + 5;

    @SafeVarargs
    private static <T> T[] array(T ... arr) {
        return arr;
    }

    @NotNull
    public static Script generate(@NotNull Random random, int depth) {
        return Fuzzer.randomScript(new GenCtx(random), depth);
    }

    @NotNull
    private static String randomRegExpString(@NotNull GenCtx ctx, int depth) {
        return "/" + Fuzzer.randomIdentifierString(ctx, depth) + "/";
    }

    @NotNull
    private static String randomString(@NotNull GenCtx ctx, int depth) {
        int length = ctx.random.nextInt(3);
        StringBuilder sb = new StringBuilder();
        ctx.random.ints(length, 20, 127).forEach(i -> sb.append((char)i));
        return sb.toString();
    }

    @NotNull
    private static String randomIdentifierString(@NotNull GenCtx ctx, int depth) {
        StringBuilder result = new StringBuilder();
        result.append(identifierStartArr[ctx.random.nextInt(identifierStartArr.length)]);
        int length = ctx.random.nextInt(15);
        for (int i = 0; i < length; ++i) {
            result.append(identifierPartArr[ctx.random.nextInt(identifierPartArr.length)]);
        }
        return result.toString();
    }

    private static double randomNumber(@NotNull GenCtx ctx, int depth) {
        return Math.exp(ctx.random.nextGaussian());
    }

    private static <T> Gen<T> choice(T[] arr) {
        return (ctx, depth) -> arr[ctx.random.nextInt(arr.length)];
    }

    @NotNull
    private static <T> Gen<ImmutableList<T>> many(int bound, @NotNull Gen<T> gen) {
        return (ctx, depth) -> {
            if (depth <= 0) {
                return ImmutableList.nil();
            }
            int number = ctx.random.nextInt(bound);
            ImmutableList result = ImmutableList.nil();
            for (int i = 0; i < number; ++i) {
                result = result.cons(gen.apply(ctx, depth));
            }
            return result;
        };
    }

    @NotNull
    private static <T> Gen<ImmutableList<T>> many(@NotNull Gen<T> gen) {
        return Fuzzer.many(5, gen);
    }

    @NotNull
    private static <T> Gen<NonEmptyImmutableList<T>> many1(@NotNull Gen<T> gen) {
        return (ctx, depth) -> Fuzzer.many(4, gen).apply(ctx, depth).cons(gen.apply(ctx, depth));
    }

    @NotNull
    private static <T> Gen<Maybe<T>> optional(@NotNull Gen<T> gen) {
        return (ctx, depth) -> {
            if (depth <= 0) {
                return Maybe.nothing();
            }
            if (ctx.random.nextBoolean()) {
                return Maybe.nothing();
            }
            return Maybe.just(gen.apply(ctx, depth));
        };
    }

    @NotNull
    private static <A, B> Gen<Either<A, B>> either(@NotNull Gen<A> gen1, @NotNull Gen<B> gen2) {
        return (ctx, depth) -> {
            if (ctx.random.nextBoolean()) {
                return Either.left(gen1.apply(ctx, depth));
            }
            return Either.right(gen2.apply(ctx, depth));
        };
    }

    @NotNull
    private static Script randomScript(@NotNull GenCtx ctx, int depth) {
        return new Script(Fuzzer.randomFunctionBody(ctx, depth - 1));
    }

    @NotNull
    private static FunctionBody randomFunctionBody(@NotNull GenCtx ctx, int depth) {
        ImmutableList<Directive> directives = Fuzzer.many(Fuzzer::randomDirective).apply(ctx, depth - 1);
        if (!ctx.inStrictMode && directives.exists(dir -> dir instanceof UseStrictDirective)) {
            ctx = ctx.enterStrictMode();
        }
        return new FunctionBody(directives, Fuzzer.many(Fuzzer::randomStatement).apply(ctx, depth - 1));
    }

    @NotNull
    private static Identifier randomIdentifier(@NotNull GenCtx ctx, int depth, boolean allowReserved, boolean allowRestricted) {
        String name;
        boolean genarateSpecial;
        boolean bl = genarateSpecial = ctx.random.nextDouble() < 0.5;
        if (genarateSpecial && allowReserved) {
            name = ctx.inStrictMode ? Fuzzer.choice(STRICT_MODE_RESERVED_WORDS).apply(ctx, depth - 1) : Fuzzer.choice(RESERVED_WORDS).apply(ctx, depth - 1);
        } else if (genarateSpecial && allowRestricted) {
            name = Fuzzer.choice(RESTRICTED_WORDS).apply(ctx, depth - 1);
        } else {
            boolean disallow;
            do {
                disallow = false;
                name = Fuzzer.randomIdentifierString(ctx, depth - 1);
                for (String reservedWord : ctx.inStrictMode ? STRICT_MODE_RESERVED_WORDS : RESERVED_WORDS) {
                    if (!reservedWord.equals(name)) continue;
                    disallow = true;
                }
            } while (disallow);
        }
        return new Identifier(name);
    }

    @NotNull
    private static Expression randomExpression(@NotNull GenCtx ctx, int depth) {
        return Fuzzer.choice(expressionGens).apply(ctx, depth - 1).apply(ctx, depth - 1);
    }

    @NotNull
    private static Directive randomDirective(@NotNull GenCtx ctx, int depth) {
        if (ctx.random.nextDouble() < 0.3) {
            return Fuzzer.randomUseStrictDirective(ctx, depth - 1);
        }
        return Fuzzer.randomUnknownDirective(ctx, depth - 1);
    }

    @NotNull
    private static Statement randomStatement(@NotNull GenCtx ctx, int depth) {
        return Fuzzer.randomStatementGeneric(ctx, depth, true);
    }

    @NotNull
    private static Statement randomStatementGeneric(@NotNull GenCtx ctx, int depth, boolean allowIteration) {
        int n;
        if (depth <= 0) {
            switch (ctx.random.nextInt(ctx.inIteration ? 4 : 2)) {
                case 0: {
                    return new DebuggerStatement();
                }
                case 1: {
                    return new EmptyStatement();
                }
                case 2: {
                    return new BreakStatement(Maybe.nothing());
                }
            }
            return new ContinueStatement(Maybe.nothing());
        }
        int total = totalStatements - (allowIteration ? 0 : iterationStatementGens.length);
        block18: while (true) {
            n = ctx.random.nextInt(total);
            switch (n) {
                case 0: {
                    if (ctx.labelsInFunctionBoundary.length != 0 || ctx.inSwitch || ctx.inIteration) break block18;
                    continue block18;
                }
                case 1: {
                    if (ctx.inIteration) break block18;
                    continue block18;
                }
                case 2: {
                    if (!ctx.inStrictMode) break block18;
                    continue block18;
                }
                case 3: {
                    if (ctx.inFunctional) break block18;
                    continue block18;
                }
            }
            break;
        }
        switch (n) {
            case 0: {
                if (!ctx.inSwitch && !ctx.inIteration || ctx.labelsInFunctionBoundary.length > 0 && ctx.random.nextBoolean()) {
                    Maybe<Identifier> label = ctx.labelsInFunctionBoundary.index(ctx.random.nextInt(ctx.labelsInFunctionBoundary.length));
                    return new BreakStatement(label);
                }
                return new BreakStatement(Maybe.nothing());
            }
            case 1: {
                if (ctx.iterationLabelsInFunctionBoundary.length > 0 && ctx.random.nextBoolean()) {
                    Maybe<Identifier> label = ctx.iterationLabelsInFunctionBoundary.index(ctx.random.nextInt(ctx.iterationLabelsInFunctionBoundary.length));
                    return new ContinueStatement(label);
                }
                return new ContinueStatement(Maybe.nothing());
            }
            case 2: {
                return new WithStatement(Fuzzer.randomExpression(ctx, depth - 1), Fuzzer.randomStatement(ctx, depth - 1));
            }
            case 3: {
                if (ctx.random.nextBoolean()) {
                    return new ReturnStatement(Maybe.just(Fuzzer.randomExpression(ctx, depth - 1)));
                }
                return new ReturnStatement(Maybe.nothing());
            }
            case 4: {
                Identifier label = Fuzzer.randomIdentifier(ctx, depth - 1, false, true);
                while (ctx.labels.exists(label::equals)) {
                    label = Fuzzer.randomIdentifier(ctx, depth - 1, false, true);
                }
                int bodyN = ctx.random.nextInt(totalStatements);
                if (bodyN < iterationStatementGens.length) {
                    IterationStatement body = iterationStatementGens[bodyN].apply(ctx.withIterationLabel(label), depth - 1);
                    return new LabeledStatement(label, body);
                }
                Statement body = Fuzzer.randomStatementGeneric(ctx.withLabel(label), depth - 1, false);
                return new LabeledStatement(label, body);
            }
        }
        if (n < nonIterationStatementGens.length + 5) {
            return nonIterationStatementGens[n - 5].apply(ctx, depth - 1);
        }
        return iterationStatementGens[n - nonIterationStatementGens.length - 5].apply(ctx, depth - 1);
    }

    @NotNull
    private static Block randomBlock(@NotNull GenCtx ctx, int depth) {
        if (depth < 1) {
            return new Block(ImmutableList.nil());
        }
        return new Block(Fuzzer.many(Fuzzer::randomStatement).apply(ctx.allowMissingElse(), depth - 1));
    }

    @NotNull
    private static VariableDeclarator randomVariableDeclarator(@NotNull GenCtx ctx, int depth) {
        return new VariableDeclarator(Fuzzer.randomIdentifier(ctx, depth - 1, false, false), Fuzzer.optional(Fuzzer::randomExpression).apply(ctx, depth - 1));
    }

    @NotNull
    private static VariableDeclaration randomVariableDeclaration1(@NotNull GenCtx ctx, int depth) {
        return new VariableDeclaration(ctx.inStrictMode ? VariableDeclaration.VariableDeclarationKind.Var : Fuzzer.choice(new VariableDeclaration.VariableDeclarationKind[]{VariableDeclaration.VariableDeclarationKind.Var, VariableDeclaration.VariableDeclarationKind.Let}).apply(ctx, depth - 1), ImmutableList.list(Fuzzer.randomVariableDeclarator(ctx, depth - 1), new VariableDeclarator[0]));
    }

    @NotNull
    private static VariableDeclaration randomVariableDeclaration(@NotNull GenCtx ctx, int depth) {
        return new VariableDeclaration(ctx.inStrictMode ? VariableDeclaration.VariableDeclarationKind.Var : Fuzzer.choice(VariableDeclaration.VariableDeclarationKind.values()).apply(ctx, depth - 1), Fuzzer.many1(Fuzzer::randomVariableDeclarator).apply(ctx, depth - 1));
    }

    @NotNull
    private static SwitchCase randomSwitchCase(@NotNull GenCtx ctx, int depth) {
        return new SwitchCase(Fuzzer.randomExpression(ctx, depth - 1), Fuzzer.many(Fuzzer::randomStatement).apply(ctx, depth - 1));
    }

    @NotNull
    private static SwitchDefault randomSwitchDefault(@NotNull GenCtx ctx, int depth) {
        return new SwitchDefault(Fuzzer.many(Fuzzer::randomStatement).apply(ctx, depth - 1));
    }

    @NotNull
    private static CatchClause randomCatchClause(@NotNull GenCtx ctx, int depth) {
        return new CatchClause(Fuzzer.randomIdentifier(ctx, depth - 1, false, false), Fuzzer.randomBlock(ctx, depth - 1));
    }

    @NotNull
    private static UnknownDirective randomUnknownDirective(@NotNull GenCtx ctx, int depth) {
        String value = Utils.escapeStringLiteral(Fuzzer.randomString(ctx, depth - 1));
        return new UnknownDirective(value.substring(1, value.length() - 1));
    }

    @NotNull
    private static UseStrictDirective randomUseStrictDirective(@NotNull GenCtx ctx, int depth) {
        return new UseStrictDirective();
    }

    @NotNull
    private static ArrayExpression randomArrayExpression(@NotNull GenCtx ctx, int depth) {
        return new ArrayExpression(Fuzzer.many(Fuzzer.optional(Fuzzer::randomExpression)).apply(ctx, depth - 1));
    }

    @NotNull
    private static AssignmentExpression randomAssignmentExpression(@NotNull GenCtx ctx, int depth) {
        Expression lhs;
        do {
            lhs = Fuzzer.randomExpression(ctx, depth - 1);
        } while (ctx.inStrictMode && lhs instanceof IdentifierExpression && Utils.isRestrictedWord(((IdentifierExpression)lhs).identifier.name));
        return new AssignmentExpression(Fuzzer.choice(AssignmentOperator.values()).apply(ctx, depth - 1), lhs, Fuzzer.randomExpression(ctx, depth - 1));
    }

    @NotNull
    private static BinaryExpression randomBinaryExpression(@NotNull GenCtx ctx, int depth) {
        return new BinaryExpression(Fuzzer.choice(BinaryOperator.values()).apply(ctx, depth - 1), Fuzzer.randomExpression(ctx, depth - 1), Fuzzer.randomExpression(ctx, depth - 1));
    }

    @NotNull
    private static CallExpression randomCallExpression(@NotNull GenCtx ctx, int depth) {
        return new CallExpression(Fuzzer.randomExpression(ctx, depth - 1), Fuzzer.many(Fuzzer::randomExpression).apply(ctx, depth - 1));
    }

    @NotNull
    private static ComputedMemberExpression randomComputedMemberExpression(@NotNull GenCtx ctx, int depth) {
        return new ComputedMemberExpression(Fuzzer.randomExpression(ctx, depth - 1), Fuzzer.randomExpression(ctx, depth - 1));
    }

    @NotNull
    private static ConditionalExpression randomConditionalExpression(@NotNull GenCtx ctx, int depth) {
        return new ConditionalExpression(Fuzzer.randomExpression(ctx, depth - 1), Fuzzer.randomExpression(ctx, depth - 1), Fuzzer.randomExpression(ctx, depth - 1));
    }

    @NotNull
    private static ImmutableList<Identifier> randomParameterList(@NotNull GenCtx ctx, int depth) {
        Gen<Identifier> gen = (c, d) -> Fuzzer.randomIdentifier(c, d, false, false);
        if (ctx.inStrictMode) {
            int length = ctx.random.nextInt(5);
            HashSet<String> names = new HashSet<String>();
            ImmutableList<Identifier> result = ImmutableList.nil();
            for (int i = 0; i < length; ++i) {
                Identifier identifier = gen.apply(ctx, depth);
                while (names.contains(identifier.name)) {
                    identifier = gen.apply(ctx, depth);
                }
                names.add(identifier.name);
                result = result.cons(identifier);
            }
            return result;
        }
        return Fuzzer.many(gen).apply(ctx, depth);
    }

    @NotNull
    private static FunctionExpression randomFunctionExpression(@NotNull GenCtx ctx, int depth) {
        FunctionBody body = Fuzzer.randomFunctionBody(ctx.enterFunctional(), depth - 1);
        if (body.isStrict()) {
            ctx = ctx.enterStrictMode();
        }
        return new FunctionExpression(Fuzzer.optional((c, d) -> Fuzzer.randomIdentifier(c, d, false, false)).apply(ctx, depth - 1), Fuzzer.randomParameterList(ctx, depth - 1), body);
    }

    @NotNull
    private static IdentifierExpression randomIdentifierExpression(@NotNull GenCtx ctx, int depth) {
        return new IdentifierExpression(Fuzzer.randomIdentifier(ctx, depth - 1, false, true));
    }

    @NotNull
    private static LiteralBooleanExpression randomLiteralBooleanExpression(@NotNull GenCtx ctx, int depth) {
        return new LiteralBooleanExpression(ctx.random.nextBoolean());
    }

    @NotNull
    private static LiteralNullExpression randomLiteralNullExpression(@NotNull GenCtx ctx, int depth) {
        return new LiteralNullExpression();
    }

    @NotNull
    private static LiteralNumericExpression randomLiteralNumericExpression(@NotNull GenCtx ctx, int depth) {
        return new LiteralNumericExpression(Fuzzer.randomNumber(ctx, depth - 1));
    }

    @NotNull
    private static LiteralInfinityExpression randomLiteralInfinityExpression(@NotNull GenCtx ctx, int depth) {
        return new LiteralInfinityExpression();
    }

    @NotNull
    private static LiteralRegExpExpression randomLiteralRegExpExpression(@NotNull GenCtx ctx, int depth) {
        return new LiteralRegExpExpression(Fuzzer.randomRegExpString(ctx, depth - 1));
    }

    @NotNull
    private static LiteralStringExpression randomLiteralStringExpression(@NotNull GenCtx ctx, int depth) {
        return new LiteralStringExpression(Fuzzer.randomString(ctx, depth - 1));
    }

    @NotNull
    private static NewExpression randomNewExpression(@NotNull GenCtx ctx, int depth) {
        return new NewExpression(Fuzzer.randomExpression(ctx, depth - 1), Fuzzer.many(Fuzzer::randomExpression).apply(ctx, depth - 1));
    }

    @NotNull
    private static ObjectExpression randomObjectExpression(@NotNull GenCtx ctx, int depth) {
        int length = ctx.random.nextInt(5);
        HashSet<Object> names = new HashSet<Object>();
        for (int i = 0; i < length; ++i) {
            Object name;
            int n = ctx.random.nextInt();
            switch (n) {
                case 0: {
                    Object ident;
                    do {
                        ident = Fuzzer.randomIdentifier(ctx, depth - 1, true, true);
                    } while (names.contains(((Identifier)ident).name));
                    name = ((Identifier)ident).name;
                    break;
                }
                case 1: {
                    double ident;
                    while (names.contains(D2A.d2a(ident = Fuzzer.randomNumber(ctx, depth - 1)))) {
                    }
                    name = D2A.d2a(ident);
                    break;
                }
                default: {
                    Object ident;
                    while (names.contains(ident = Fuzzer.randomString(ctx, depth - 1))) {
                    }
                    name = ident;
                    break;
                }
            }
            names.add(name);
        }
        ImmutableList<ObjectProperty> properties = ImmutableList.nil();
        block14: for (String string : names) {
            switch (ctx.random.nextInt(ctx.inStrictMode ? 4 : 5)) {
                case 0: {
                    properties = properties.cons(Fuzzer.randomDataProperty(ctx, depth - 1, string));
                    continue block14;
                }
                case 1: {
                    properties = properties.cons(Fuzzer.randomGetter(ctx, depth - 1, string));
                    continue block14;
                }
                case 2: {
                    properties = properties.cons(Fuzzer.randomSetter(ctx, depth - 1, string));
                    continue block14;
                }
                case 3: {
                    properties = properties.cons(Fuzzer.randomGetter(ctx, depth - 1, string));
                    properties = properties.cons(Fuzzer.randomSetter(ctx, depth - 1, string));
                    continue block14;
                }
            }
            properties = properties.cons(Fuzzer.randomDataProperty(ctx, depth - 1, string));
            properties = properties.cons(Fuzzer.randomDataProperty(ctx, depth - 1, string));
        }
        return new ObjectExpression(properties);
    }

    @NotNull
    private static PostfixExpression randomPostfixExpression(@NotNull GenCtx ctx, int depth) {
        PostfixOperator operator = Fuzzer.choice(PostfixOperator.values()).apply(ctx, depth - 1);
        Expression expression = Fuzzer.randomExpression(ctx, depth - 1);
        if (ctx.inStrictMode) {
            switch (operator) {
                case Decrement: 
                case Increment: {
                    while (expression instanceof IdentifierExpression && Utils.isRestrictedWord(((IdentifierExpression)expression).identifier.name)) {
                        expression = Fuzzer.randomExpression(ctx, depth - 1);
                    }
                    break;
                }
            }
        }
        return new PostfixExpression(operator, expression);
    }

    @NotNull
    private static PrefixExpression randomPrefixExpression(@NotNull GenCtx ctx, int depth) {
        PrefixOperator operator = Fuzzer.choice(PrefixOperator.values()).apply(ctx, depth - 1);
        Expression expression = Fuzzer.randomExpression(ctx, depth - 1);
        if (ctx.inStrictMode) {
            switch (operator) {
                case Decrement: 
                case Increment: {
                    while (expression instanceof IdentifierExpression && Utils.isRestrictedWord(((IdentifierExpression)expression).identifier.name)) {
                        expression = Fuzzer.randomExpression(ctx, depth - 1);
                    }
                    break;
                }
                case Delete: {
                    if (!(expression instanceof IdentifierExpression)) break;
                    if (depth < 3) {
                        return new PrefixExpression(PrefixOperator.Delete, Fuzzer.randomStaticMemberExpression(ctx, depth));
                    }
                    while (expression instanceof IdentifierExpression) {
                        expression = Fuzzer.randomExpression(ctx, depth - 1);
                    }
                    break;
                }
            }
        }
        return new PrefixExpression(operator, expression);
    }

    @NotNull
    private static StaticMemberExpression randomStaticMemberExpression(@NotNull GenCtx ctx, int depth) {
        return new StaticMemberExpression(Fuzzer.randomExpression(ctx, depth - 1), Fuzzer.randomIdentifier(ctx, depth - 1, true, true));
    }

    @NotNull
    private static ThisExpression randomThisExpression(@NotNull GenCtx ctx, int depth) {
        return new ThisExpression();
    }

    @NotNull
    private static DataProperty randomDataProperty(@NotNull GenCtx ctx, int depth, @NotNull String name) {
        return new DataProperty(Fuzzer.randomPropertyName(ctx, depth - 1, name), Fuzzer.randomExpression(ctx, depth - 1));
    }

    @NotNull
    private static Getter randomGetter(@NotNull GenCtx ctx, int depth, @NotNull String name) {
        FunctionBody body = Fuzzer.randomFunctionBody(ctx.enterFunctional(), depth - 1);
        if (body.isStrict()) {
            ctx = ctx.enterStrictMode();
        }
        return new Getter(Fuzzer.randomPropertyName(ctx, depth - 1, name), body);
    }

    @NotNull
    private static Setter randomSetter(@NotNull GenCtx ctx, int depth, @NotNull String name) {
        FunctionBody body = Fuzzer.randomFunctionBody(ctx.enterFunctional(), depth - 1);
        if (body.isStrict()) {
            ctx = ctx.enterStrictMode();
        }
        return new Setter(Fuzzer.randomPropertyName(ctx, depth - 1, name), Fuzzer.randomIdentifier(ctx, depth - 1, false, false), body);
    }

    @NotNull
    private static PropertyName randomPropertyName(@NotNull GenCtx ctx, int depth, @NotNull String name) {
        if (Utils.isValidIdentifierName(name)) {
            switch (ctx.random.nextInt(2)) {
                case 0: {
                    return new PropertyName(new Identifier(name));
                }
            }
            return new PropertyName(name);
        }
        return new PropertyName(name);
    }

    @NotNull
    private static BlockStatement randomBlockStatement(@NotNull GenCtx ctx, int depth) {
        return new BlockStatement(Fuzzer.randomBlock(ctx.allowMissingElse(), depth - 1));
    }

    @NotNull
    private static DebuggerStatement randomDebuggerStatement(@NotNull GenCtx ctx, int depth) {
        return new DebuggerStatement();
    }

    @NotNull
    private static DoWhileStatement randomDoWhileStatement(@NotNull GenCtx ctx, int depth) {
        return new DoWhileStatement(Fuzzer.randomStatement(ctx.enterIteration().allowMissingElse(), depth - 1), Fuzzer.randomExpression(ctx, depth - 1));
    }

    @NotNull
    private static EmptyStatement randomEmptyStatement(@NotNull GenCtx ctx, int depth) {
        return new EmptyStatement();
    }

    @NotNull
    private static ExpressionStatement randomExpressionStatement(@NotNull GenCtx ctx, int depth) {
        return new ExpressionStatement(Fuzzer.randomExpression(ctx, depth - 1));
    }

    @NotNull
    private static ForInStatement randomForInStatement(@NotNull GenCtx ctx, int depth) {
        return new ForInStatement(Fuzzer.either(Fuzzer::randomVariableDeclaration1, Fuzzer::randomExpression).apply(ctx, depth - 1), Fuzzer.randomExpression(ctx, depth - 1), Fuzzer.randomStatement(ctx, depth - 1));
    }

    @NotNull
    private static ForStatement randomForStatement(@NotNull GenCtx ctx, int depth) {
        return new ForStatement(Fuzzer.optional(Fuzzer.either(Fuzzer::randomVariableDeclaration1, Fuzzer::randomExpression)).apply(ctx, depth - 1), Fuzzer.optional(Fuzzer::randomExpression).apply(ctx, depth - 1), Fuzzer.optional(Fuzzer::randomExpression).apply(ctx, depth - 1), Fuzzer.randomStatement(ctx, depth - 1));
    }

    @NotNull
    private static FunctionDeclaration randomFunctionDeclaration(@NotNull GenCtx ctx, int depth) {
        FunctionBody functionBody = Fuzzer.randomFunctionBody(ctx.enterFunctional().clearLabels(), depth - 1);
        if (functionBody.isStrict()) {
            ctx = ctx.enterStrictMode();
        }
        return new FunctionDeclaration(Fuzzer.randomIdentifier(ctx, depth - 1, false, false), Fuzzer.randomParameterList(ctx, depth - 1), functionBody);
    }

    @NotNull
    private static IfStatement randomIfStatement(@NotNull GenCtx ctx, int depth) {
        boolean missElse;
        if (ctx.allowMissingElse && (missElse = ctx.random.nextBoolean())) {
            return new IfStatement(Fuzzer.randomExpression(ctx, depth - 1), Fuzzer.randomStatement(ctx, depth - 1), Maybe.nothing());
        }
        return new IfStatement(Fuzzer.randomExpression(ctx, depth - 1), Fuzzer.randomStatement(ctx.forbidMissingElse(), depth - 1), Maybe.just(Fuzzer.randomStatement(ctx, depth - 1)));
    }

    @NotNull
    private static SwitchStatement randomSwitchStatement(@NotNull GenCtx ctx, int depth) {
        ctx = ctx.allowMissingElse().enterSwitch();
        return new SwitchStatement(Fuzzer.randomExpression(ctx, depth - 1), Fuzzer.many(Fuzzer::randomSwitchCase).apply(ctx, depth - 1));
    }

    @NotNull
    private static SwitchStatementWithDefault randomSwitchStatementWithDefault(@NotNull GenCtx ctx, int depth) {
        ctx = ctx.allowMissingElse().enterSwitch();
        return new SwitchStatementWithDefault(Fuzzer.randomExpression(ctx, depth - 1), Fuzzer.many(Fuzzer::randomSwitchCase).apply(ctx, depth - 1), Fuzzer.randomSwitchDefault(ctx, depth - 1), Fuzzer.many(Fuzzer::randomSwitchCase).apply(ctx, depth - 1));
    }

    @NotNull
    private static ThrowStatement randomThrowStatement(@NotNull GenCtx ctx, int depth) {
        return new ThrowStatement(Fuzzer.randomExpression(ctx, depth - 1));
    }

    @NotNull
    private static TryCatchStatement randomTryCatchStatement(@NotNull GenCtx ctx, int depth) {
        return new TryCatchStatement(Fuzzer.randomBlock(ctx, depth - 1), Fuzzer.randomCatchClause(ctx, depth - 1));
    }

    @NotNull
    private static TryFinallyStatement randomTryFinallyStatement(@NotNull GenCtx ctx, int depth) {
        return new TryFinallyStatement(Fuzzer.randomBlock(ctx, depth - 1), Fuzzer.optional(Fuzzer::randomCatchClause).apply(ctx, depth - 1), Fuzzer.randomBlock(ctx, depth - 1));
    }

    @NotNull
    private static VariableDeclarationStatement randomVariableDeclarationStatement(@NotNull GenCtx ctx, int depth) {
        return new VariableDeclarationStatement(Fuzzer.randomVariableDeclaration(ctx, depth - 1));
    }

    @NotNull
    private static WhileStatement randomWhileStatement(@NotNull GenCtx ctx, int depth) {
        return new WhileStatement(Fuzzer.randomExpression(ctx, depth - 1), Fuzzer.randomStatement(ctx, depth - 1));
    }

    private static interface Gen<T> {
        @NotNull
        public T apply(@NotNull GenCtx var1, int var2);
    }
}

