/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.codegen;

import com.shapesecurity.shift.utils.D2A;
import com.shapesecurity.shift.utils.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TokenStream {
    @NotNull
    private final StringBuilder writer;
    private char lastChar = (char)65535;
    @Nullable
    private String lastNumber;
    private boolean optionalSemi;

    public TokenStream(@NotNull StringBuilder writer) {
        this.writer = writer;
    }

    @NotNull
    private static String numberDot(@NotNull String fragment) {
        if (fragment.indexOf(46) < 0 && fragment.indexOf(101) < 0) {
            return "..";
        }
        return ".";
    }

    public void putNumber(double number) {
        String tokenStr = D2A.d2a(number);
        this.put(tokenStr);
        this.lastNumber = tokenStr;
    }

    public void putOptionalSemi() {
        this.optionalSemi = true;
    }

    public void put(@NotNull String tokenStr) {
        if (this.optionalSemi) {
            this.optionalSemi = false;
            if (!tokenStr.equals("}")) {
                this.put(";");
            }
        }
        if (this.lastNumber != null && tokenStr.length() == 1 && String.valueOf(tokenStr).equals(".")) {
            this.writer.append(TokenStream.numberDot(this.lastNumber));
            this.lastNumber = null;
            this.lastChar = (char)46;
            return;
        }
        this.lastNumber = null;
        char rightChar = tokenStr.charAt(0);
        char lastChar = this.lastChar;
        this.lastChar = tokenStr.charAt(tokenStr.length() - 1);
        if ((lastChar == '+' || lastChar == '-') && lastChar == rightChar || Utils.isIdentifierPart(lastChar) && Utils.isIdentifierPart(rightChar) || lastChar == '/' && (rightChar == 'i' || rightChar == '/')) {
            this.writer.append(' ');
        }
        if (this.writer.length() >= 2 && tokenStr.equals("--") && this.writer.substring(this.writer.length() - 2, this.writer.length()).equals("<!")) {
            this.writer.append(' ');
        }
        this.writer.append(tokenStr);
    }
}

