/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.codegen;

import com.shapesecurity.shift.codegen.CodeRep;
import com.shapesecurity.shift.codegen.TokenStream;
import org.jetbrains.annotations.NotNull;

public abstract class FormattedCodeRep
extends CodeRep {
    private FormattedCodeRep() {
    }

    public static final class SemiOp
    extends FormattedCodeRep {
        @Override
        public void emit(@NotNull TokenStream ts, boolean noIn) {
            ts.putOptionalSemi();
            ts.put("\n");
        }
    }

    public static final class Semi
    extends FormattedCodeRep {
        @Override
        public void emit(@NotNull TokenStream ts, boolean noIn) {
            ts.put(";\n");
        }
    }

    public static final class Brace
    extends FormattedCodeRep {
        @NotNull
        private final CodeRep expr;

        public Brace(@NotNull CodeRep expr) {
            this.expr = expr;
        }

        @Override
        public void emit(@NotNull TokenStream ts, boolean noIn) {
            ts.put("{\n");
            this.expr.emit(ts, false);
            ts.put("}");
        }
    }
}

