/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.codegen;

import com.shapesecurity.shift.codegen.TokenStream;
import org.jetbrains.annotations.NotNull;

public abstract class CodeRep {
    public boolean containsIn;
    public boolean containsGroup;
    public boolean startsWithFunctionOrCurly;
    public boolean endsWithMissingElse;

    CodeRep() {
    }

    public abstract void emit(@NotNull TokenStream var1, boolean var2);

    public static final class SemiOp
    extends CodeRep {
        @Override
        public void emit(@NotNull TokenStream ts, boolean noIn) {
            ts.putOptionalSemi();
        }
    }

    public static final class Semi
    extends CodeRep {
        @Override
        public void emit(@NotNull TokenStream ts, boolean noIn) {
            ts.put(";");
        }
    }

    public static final class CommaSep
    extends CodeRep {
        @NotNull
        private final CodeRep[] children;

        public CommaSep(@NotNull CodeRep[] children) {
            this.children = children;
        }

        @Override
        public void emit(@NotNull TokenStream ts, boolean noIn) {
            if (this.children.length == 0) {
                return;
            }
            this.children[0].emit(ts, noIn);
            for (int i = 1; i < this.children.length; ++i) {
                ts.put(",");
                this.children[i].emit(ts, noIn);
            }
        }
    }

    public static final class Init
    extends CodeRep {
        @NotNull
        private final CodeRep lhs;
        @NotNull
        private final CodeRep rhs;

        public Init(@NotNull CodeRep lhs, @NotNull CodeRep rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public void emit(@NotNull TokenStream ts, boolean noIn) {
            this.lhs.emit(ts, false);
            ts.put("=");
            this.rhs.emit(ts, noIn);
        }
    }

    public static final class Seq
    extends CodeRep {
        @NotNull
        public final CodeRep[] children;

        public Seq(@NotNull CodeRep[] children) {
            this.children = children;
        }

        @Override
        public void emit(@NotNull TokenStream ts, boolean noIn) {
            for (CodeRep child : this.children) {
                child.emit(ts, noIn);
            }
        }
    }

    public static final class NoIn
    extends CodeRep {
        @NotNull
        private final CodeRep expr;

        public NoIn(@NotNull CodeRep expr) {
            this.expr = expr;
        }

        @Override
        public void emit(@NotNull TokenStream ts, boolean noIn) {
            this.expr.emit(ts, true);
        }
    }

    public static final class Bracket
    extends CodeRep {
        @NotNull
        private final CodeRep expr;

        public Bracket(@NotNull CodeRep expr) {
            this.expr = expr;
        }

        @Override
        public void emit(@NotNull TokenStream ts, boolean noIn) {
            ts.put("[");
            this.expr.emit(ts, false);
            ts.put("]");
        }
    }

    public static final class Brace
    extends CodeRep {
        @NotNull
        private final CodeRep expr;

        public Brace(@NotNull CodeRep expr) {
            this.expr = expr;
        }

        @Override
        public void emit(@NotNull TokenStream ts, boolean noIn) {
            ts.put("{");
            this.expr.emit(ts, false);
            ts.put("}");
        }
    }

    public static final class ContainsIn
    extends CodeRep {
        @NotNull
        private final CodeRep expr;

        public ContainsIn(@NotNull CodeRep expr) {
            this.expr = expr;
        }

        @Override
        public void emit(@NotNull TokenStream ts, boolean noIn) {
            if (noIn) {
                ts.put("(");
                this.expr.emit(ts, false);
                ts.put(")");
            } else {
                this.expr.emit(ts, false);
            }
        }
    }

    public static final class Paren
    extends CodeRep {
        @NotNull
        private final CodeRep expr;

        public Paren(@NotNull CodeRep expr) {
            this.expr = expr;
        }

        @Override
        public void emit(@NotNull TokenStream ts, boolean noIn) {
            ts.put("(");
            this.expr.emit(ts, false);
            ts.put(")");
        }
    }

    public static final class Number
    extends CodeRep {
        private final double number;

        public Number(double number) {
            this.number = number;
        }

        @Override
        public void emit(@NotNull TokenStream ts, boolean noIn) {
            ts.putNumber(this.number);
        }
    }

    public static final class Token
    extends CodeRep {
        @NotNull
        private final String token;

        public Token(@NotNull String token) {
            this.token = token;
        }

        @Override
        public void emit(@NotNull TokenStream ts, boolean noIn) {
            ts.put(this.token);
        }
    }

    public static final class Empty
    extends CodeRep {
        @Override
        public void emit(@NotNull TokenStream ts, boolean noIn) {
        }
    }
}

