/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.codegen;

import com.shapesecurity.functional.data.Either;
import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.functional.data.Maybe;
import com.shapesecurity.functional.data.NonEmptyImmutableList;
import com.shapesecurity.shift.ast.Block;
import com.shapesecurity.shift.ast.CatchClause;
import com.shapesecurity.shift.ast.FunctionBody;
import com.shapesecurity.shift.ast.Identifier;
import com.shapesecurity.shift.ast.Node;
import com.shapesecurity.shift.ast.Script;
import com.shapesecurity.shift.ast.SwitchCase;
import com.shapesecurity.shift.ast.SwitchDefault;
import com.shapesecurity.shift.ast.VariableDeclaration;
import com.shapesecurity.shift.ast.VariableDeclarator;
import com.shapesecurity.shift.ast.directive.UnknownDirective;
import com.shapesecurity.shift.ast.directive.UseStrictDirective;
import com.shapesecurity.shift.ast.expression.ArrayExpression;
import com.shapesecurity.shift.ast.expression.AssignmentExpression;
import com.shapesecurity.shift.ast.expression.BinaryExpression;
import com.shapesecurity.shift.ast.expression.CallExpression;
import com.shapesecurity.shift.ast.expression.ComputedMemberExpression;
import com.shapesecurity.shift.ast.expression.ConditionalExpression;
import com.shapesecurity.shift.ast.expression.FunctionExpression;
import com.shapesecurity.shift.ast.expression.IdentifierExpression;
import com.shapesecurity.shift.ast.expression.LiteralBooleanExpression;
import com.shapesecurity.shift.ast.expression.LiteralInfinityExpression;
import com.shapesecurity.shift.ast.expression.LiteralNullExpression;
import com.shapesecurity.shift.ast.expression.LiteralNumericExpression;
import com.shapesecurity.shift.ast.expression.LiteralRegExpExpression;
import com.shapesecurity.shift.ast.expression.LiteralStringExpression;
import com.shapesecurity.shift.ast.expression.NewExpression;
import com.shapesecurity.shift.ast.expression.ObjectExpression;
import com.shapesecurity.shift.ast.expression.PostfixExpression;
import com.shapesecurity.shift.ast.expression.PrefixExpression;
import com.shapesecurity.shift.ast.expression.StaticMemberExpression;
import com.shapesecurity.shift.ast.expression.ThisExpression;
import com.shapesecurity.shift.ast.operators.BinaryOperator;
import com.shapesecurity.shift.ast.operators.Precedence;
import com.shapesecurity.shift.ast.property.DataProperty;
import com.shapesecurity.shift.ast.property.Getter;
import com.shapesecurity.shift.ast.property.PropertyName;
import com.shapesecurity.shift.ast.property.Setter;
import com.shapesecurity.shift.ast.statement.BlockStatement;
import com.shapesecurity.shift.ast.statement.BreakStatement;
import com.shapesecurity.shift.ast.statement.ContinueStatement;
import com.shapesecurity.shift.ast.statement.DebuggerStatement;
import com.shapesecurity.shift.ast.statement.DoWhileStatement;
import com.shapesecurity.shift.ast.statement.EmptyStatement;
import com.shapesecurity.shift.ast.statement.ExpressionStatement;
import com.shapesecurity.shift.ast.statement.ForInStatement;
import com.shapesecurity.shift.ast.statement.ForStatement;
import com.shapesecurity.shift.ast.statement.FunctionDeclaration;
import com.shapesecurity.shift.ast.statement.IfStatement;
import com.shapesecurity.shift.ast.statement.LabeledStatement;
import com.shapesecurity.shift.ast.statement.ReturnStatement;
import com.shapesecurity.shift.ast.statement.SwitchStatement;
import com.shapesecurity.shift.ast.statement.SwitchStatementWithDefault;
import com.shapesecurity.shift.ast.statement.ThrowStatement;
import com.shapesecurity.shift.ast.statement.TryCatchStatement;
import com.shapesecurity.shift.ast.statement.TryFinallyStatement;
import com.shapesecurity.shift.ast.statement.VariableDeclarationStatement;
import com.shapesecurity.shift.ast.statement.WhileStatement;
import com.shapesecurity.shift.ast.statement.WithStatement;
import com.shapesecurity.shift.codegen.CodeRep;
import com.shapesecurity.shift.codegen.CodeRepFactory;
import com.shapesecurity.shift.codegen.FormattedCodeRepFactory;
import com.shapesecurity.shift.codegen.TokenStream;
import com.shapesecurity.shift.path.Branch;
import com.shapesecurity.shift.utils.Utils;
import com.shapesecurity.shift.visitor.Director;
import com.shapesecurity.shift.visitor.Reducer;
import org.jetbrains.annotations.NotNull;

public final class CodeGen
implements Reducer<CodeRep> {
    public static final CodeGen COMPACT = new CodeGen(new CodeRepFactory());
    public static final CodeGen PRETTY = new CodeGen(new FormattedCodeRepFactory());
    private final CodeRepFactory factory;

    protected CodeGen(@NotNull CodeRepFactory factory) {
        this.factory = factory;
    }

    @NotNull
    public static String codeGen(@NotNull Script script) {
        return CodeGen.codeGen((Node)script, false);
    }

    @NotNull
    public static String codeGenNode(@NotNull Node node) {
        CodeRep codeRep = Director.reduce(COMPACT, node, ImmutableList.nil());
        StringBuilder sb = new StringBuilder();
        TokenStream ts = new TokenStream(sb);
        codeRep.emit(ts, false);
        return sb.toString();
    }

    @NotNull
    public static String codeGen(@NotNull Node script, boolean pretty) {
        StringBuilder sb = new StringBuilder();
        TokenStream ts = new TokenStream(sb);
        Director.reduce(pretty ? PRETTY : COMPACT, script, ImmutableList.nil()).emit(ts, false);
        return sb.toString();
    }

    @NotNull
    public static String codeGen(@NotNull Script script, @NotNull FormattedCodeRepFactory instance) {
        StringBuilder sb = new StringBuilder();
        TokenStream ts = new TokenStream(sb);
        script.reduce(new CodeGen(instance)).emit(ts, false);
        return sb.toString();
    }

    @NotNull
    private CodeRep seqVA(CodeRep ... reps) {
        return this.factory.seq(reps);
    }

    @NotNull
    private CodeRep parenToAvoidBeingDirective(@NotNull Node element, @NotNull CodeRep original) {
        if (element instanceof ExpressionStatement && ((ExpressionStatement)element).expression instanceof LiteralStringExpression) {
            return this.seqVA(this.factory.paren(((CodeRep.Seq)original).children[0]), this.factory.semiOp());
        }
        return original;
    }

    @Override
    @NotNull
    public CodeRep reduceScript(@NotNull Script node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep body) {
        return body;
    }

    @Override
    @NotNull
    public CodeRep reduceIdentifier(@NotNull Identifier node, @NotNull ImmutableList<Branch> path) {
        return this.factory.token(node.name);
    }

    @Override
    @NotNull
    public CodeRep reduceIdentifierExpression(@NotNull IdentifierExpression node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep identifier) {
        return identifier;
    }

    @Override
    @NotNull
    public CodeRep reduceThisExpression(@NotNull ThisExpression node, @NotNull ImmutableList<Branch> path) {
        return this.factory.token("this");
    }

    @Override
    @NotNull
    public CodeRep reduceLiteralBooleanExpression(@NotNull LiteralBooleanExpression node, @NotNull ImmutableList<Branch> path) {
        return this.factory.token(Boolean.toString(node.value));
    }

    @Override
    @NotNull
    public CodeRep reduceLiteralStringExpression(@NotNull LiteralStringExpression node, @NotNull ImmutableList<Branch> path) {
        return this.factory.token(Utils.escapeStringLiteral(node.value));
    }

    @Override
    @NotNull
    public CodeRep reduceLiteralRegExpExpression(@NotNull LiteralRegExpExpression node, @NotNull ImmutableList<Branch> path) {
        return this.factory.token(node.value);
    }

    @Override
    @NotNull
    public CodeRep reduceLiteralNumericExpression(@NotNull LiteralNumericExpression node, @NotNull ImmutableList<Branch> path) {
        return this.factory.num(node.value);
    }

    @Override
    @NotNull
    public CodeRep reduceLiteralInfinityExpression(@NotNull LiteralInfinityExpression node, @NotNull ImmutableList<Branch> path) {
        return this.factory.token("2e308");
    }

    @Override
    @NotNull
    public CodeRep reduceLiteralNullExpression(@NotNull LiteralNullExpression node, @NotNull ImmutableList<Branch> path) {
        return this.factory.token("null");
    }

    @Override
    @NotNull
    public CodeRep reduceFunctionExpression(@NotNull FunctionExpression node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<CodeRep> name, @NotNull ImmutableList<CodeRep> parameters, @NotNull CodeRep body) {
        CodeRep argBody = this.seqVA(this.factory.paren(this.factory.commaSep(parameters)), this.factory.brace(body));
        CodeRep result = this.seqVA(this.factory.token("function"), name.maybe(argBody, state -> this.seqVA((CodeRep)state, argBody)));
        result.startsWithFunctionOrCurly = true;
        return result;
    }

    @Override
    @NotNull
    public CodeRep reduceStaticMemberExpression(@NotNull StaticMemberExpression node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep object, @NotNull CodeRep property) {
        CodeRep result = this.seqVA(this.factory.expr(node.object, node.getPrecedence(), object), this.factory.token("."), property);
        result.startsWithFunctionOrCurly = object.startsWithFunctionOrCurly;
        return result;
    }

    @Override
    @NotNull
    public CodeRep reduceComputedMemberExpression(@NotNull ComputedMemberExpression node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep object, @NotNull CodeRep expression) {
        CodeRep result = this.seqVA(this.factory.expr(node.object, node.getPrecedence(), object), this.factory.bracket(expression));
        result.startsWithFunctionOrCurly = object.startsWithFunctionOrCurly;
        return result;
    }

    @Override
    @NotNull
    public CodeRep reduceObjectExpression(@NotNull ObjectExpression node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<CodeRep> properties) {
        CodeRep result = this.factory.brace(this.factory.commaSep(properties));
        result.startsWithFunctionOrCurly = true;
        return result;
    }

    @Override
    @NotNull
    public CodeRep reduceBinaryExpression(@NotNull BinaryExpression node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep left, @NotNull CodeRep right) {
        CodeRep leftCode = left;
        boolean leftStartsWithFunctionOrCurly = left.startsWithFunctionOrCurly;
        boolean leftContainsIn = left.containsIn;
        if (node.left.getPrecedence().ordinal() < node.getPrecedence().ordinal()) {
            leftCode = this.factory.paren(leftCode);
            leftStartsWithFunctionOrCurly = false;
            leftContainsIn = false;
        }
        CodeRep rightCode = right;
        boolean rightContainsIn = right.containsIn;
        if (node.right.getPrecedence().ordinal() <= node.getPrecedence().ordinal()) {
            rightCode = this.factory.paren(rightCode);
            rightContainsIn = false;
        }
        CodeRep result = this.seqVA(leftCode, this.factory.token(node.operator.getName()), rightCode);
        result.containsIn = leftContainsIn || rightContainsIn || node.operator == BinaryOperator.In;
        result.containsGroup = node.operator == BinaryOperator.Sequence;
        result.startsWithFunctionOrCurly = leftStartsWithFunctionOrCurly;
        return result;
    }

    @Override
    @NotNull
    public CodeRep reduceAssignmentExpression(@NotNull AssignmentExpression node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep binding, @NotNull CodeRep expression) {
        CodeRep rightCode = expression;
        boolean rightContainsIn = expression.containsIn;
        if (node.expression.getPrecedence().ordinal() < node.getPrecedence().ordinal()) {
            rightCode = this.factory.paren(rightCode);
            rightContainsIn = false;
        }
        CodeRep result = this.seqVA(this.factory.expr(node.binding, Precedence.NEW, binding), this.factory.token(node.operator.getName()), rightCode);
        result.containsIn = rightContainsIn;
        result.startsWithFunctionOrCurly = binding.startsWithFunctionOrCurly;
        return result;
    }

    @Override
    @NotNull
    public CodeRep reduceArrayExpression(@NotNull ArrayExpression node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<Maybe<CodeRep>> elements) {
        if (elements.isEmpty()) {
            return this.factory.bracket(this.factory.empty());
        }
        CodeRep empty = this.factory.empty();
        CodeRep[] reps = new CodeRep[elements.length];
        for (int i = 0; i < reps.length; ++i) {
            NonEmptyImmutableList nel = (NonEmptyImmutableList)elements;
            CodeRep el = empty;
            if (((Maybe)nel.head).isJust()) {
                el = (CodeRep)((Maybe)nel.head).just();
                if (el.containsGroup) {
                    el = this.factory.paren(el);
                }
            }
            reps[i] = el;
            elements = nel.tail;
        }
        CodeRep content = this.factory.commaSep(reps);
        if (reps[reps.length - 1] == empty) {
            content = this.seqVA(content, this.factory.token(","));
        }
        return this.factory.bracket(content);
    }

    @Override
    @NotNull
    public CodeRep reduceNewExpression(@NotNull NewExpression node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep callee, @NotNull ImmutableList<CodeRep> arguments) {
        callee = node.callee.getPrecedence() == Precedence.CALL ? this.factory.paren(callee) : this.factory.expr(node.callee, node.getPrecedence(), callee);
        return this.seqVA(this.factory.token("new"), callee, arguments.isEmpty() ? this.factory.empty() : this.factory.paren(this.factory.commaSep(arguments)));
    }

    @Override
    @NotNull
    public CodeRep reduceCallExpression(@NotNull CallExpression node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep callee, @NotNull ImmutableList<CodeRep> arguments) {
        CodeRep result = this.seqVA(this.factory.expr(node.callee, node.getPrecedence(), callee), this.factory.paren(this.factory.commaSep(arguments)));
        result.startsWithFunctionOrCurly = callee.startsWithFunctionOrCurly;
        return result;
    }

    @Override
    @NotNull
    public CodeRep reducePostfixExpression(@NotNull PostfixExpression node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep operand) {
        CodeRep result = this.seqVA(this.factory.expr(node.operand, Precedence.NEW, operand), this.factory.token(node.operator.getName()));
        result.startsWithFunctionOrCurly = operand.startsWithFunctionOrCurly;
        return result;
    }

    @Override
    @NotNull
    public CodeRep reducePrefixExpression(@NotNull PrefixExpression node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep operand) {
        return this.seqVA(this.factory.token(node.operator.getName()), this.factory.expr(node.operand, node.getPrecedence(), operand));
    }

    @Override
    @NotNull
    public CodeRep reduceConditionalExpression(@NotNull ConditionalExpression node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep test, @NotNull CodeRep consequent, @NotNull CodeRep alternate) {
        CodeRep result = this.seqVA(this.factory.expr(node.test, Precedence.LOGICAL_OR, test), this.factory.token("?"), this.factory.expr(node.consequent, Precedence.ASSIGNMENT, consequent), this.factory.token(":"), this.factory.expr(node.alternate, Precedence.ASSIGNMENT, alternate));
        result.containsIn = test.containsIn || alternate.containsIn;
        result.startsWithFunctionOrCurly = test.startsWithFunctionOrCurly;
        return result;
    }

    @Override
    @NotNull
    public CodeRep reduceFunctionDeclaration(@NotNull FunctionDeclaration node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep name, @NotNull ImmutableList<CodeRep> params, @NotNull CodeRep body) {
        return this.seqVA(this.factory.token("function"), name, this.factory.paren(this.factory.commaSep(params)), this.factory.brace(body));
    }

    @Override
    @NotNull
    public CodeRep reduceUseStrictDirective(@NotNull UseStrictDirective node, @NotNull ImmutableList<Branch> path) {
        return this.seqVA(this.factory.token("\"use strict\""), this.factory.semiOp());
    }

    @Override
    @NotNull
    public CodeRep reduceUnknownDirective(@NotNull UnknownDirective node, @NotNull ImmutableList<Branch> path) {
        return this.seqVA(this.factory.token("\"" + ("use strict".equals(node.getContents()) ? "use\\u0020strict" : node.getContents()) + '\"'), this.factory.semiOp());
    }

    @Override
    @NotNull
    public CodeRep reduceBlockStatement(@NotNull BlockStatement node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep block) {
        return block;
    }

    @Override
    @NotNull
    public CodeRep reduceBreakStatement(@NotNull BreakStatement node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<CodeRep> label) {
        return this.seqVA(this.factory.token("break"), label.orJust(this.factory.empty()), this.factory.semiOp());
    }

    @Override
    @NotNull
    public CodeRep reduceCatchClause(@NotNull CatchClause node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep binding, @NotNull CodeRep body) {
        return this.seqVA(this.factory.token("catch"), this.factory.paren(binding), body);
    }

    @Override
    @NotNull
    public CodeRep reduceContinueStatement(@NotNull ContinueStatement node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<CodeRep> label) {
        return this.seqVA(this.factory.token("continue"), label.orJust(this.factory.empty()), this.factory.semiOp());
    }

    @Override
    @NotNull
    public CodeRep reduceDebuggerStatement(@NotNull DebuggerStatement node, @NotNull ImmutableList<Branch> path) {
        return this.seqVA(this.factory.token("debugger"), this.factory.semiOp());
    }

    @Override
    @NotNull
    public CodeRep reduceDoWhileStatement(@NotNull DoWhileStatement node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep body, @NotNull CodeRep test) {
        return this.seqVA(this.factory.token("do"), body, this.factory.token("while"), this.factory.paren(test), this.factory.semiOp());
    }

    @Override
    @NotNull
    public CodeRep reduceEmptyStatement(@NotNull EmptyStatement node, @NotNull ImmutableList<Branch> path) {
        return this.factory.semi();
    }

    @Override
    @NotNull
    public CodeRep reduceExpressionStatement(@NotNull ExpressionStatement expressionStatement, @NotNull ImmutableList<Branch> path, @NotNull CodeRep expression) {
        return this.seqVA(expression.startsWithFunctionOrCurly ? this.factory.paren(expression) : expression, this.factory.semiOp());
    }

    @Override
    @NotNull
    public CodeRep reduceForInStatement(@NotNull ForInStatement node, @NotNull ImmutableList<Branch> path, @NotNull Either<CodeRep, CodeRep> left, @NotNull CodeRep right, @NotNull CodeRep body) {
        CodeRep result = this.seqVA(this.factory.token("for"), this.factory.paren(this.seqVA(this.factory.noIn(this.factory.testIn((CodeRep)Either.extract(left.mapRight(expr -> this.factory.expr(forInStatement.left.right().just(), Precedence.NEW, (CodeRep)expr))))), this.factory.token("in"), right)), body);
        result.endsWithMissingElse = body.endsWithMissingElse;
        return result;
    }

    @Override
    @NotNull
    public CodeRep reduceForStatement(@NotNull ForStatement node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<Either<CodeRep, CodeRep>> init, @NotNull Maybe<CodeRep> test, @NotNull Maybe<CodeRep> update, @NotNull CodeRep body) {
        CodeRep result = this.seqVA(this.factory.token("for"), this.factory.paren(this.seqVA(init.maybe(this.factory.empty(), x -> this.factory.noIn(this.factory.testIn((CodeRep)Either.extract(x)))), this.factory.token(";"), test.orJust(this.factory.empty()), this.factory.token(";"), update.orJust(this.factory.empty()))), body);
        result.endsWithMissingElse = body.endsWithMissingElse;
        return result;
    }

    @Override
    @NotNull
    public CodeRep reduceIfStatement(@NotNull IfStatement node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep test, @NotNull CodeRep consequent, @NotNull Maybe<CodeRep> alternate) {
        CodeRep consequentCode = consequent;
        if (alternate.isJust() && consequent.endsWithMissingElse) {
            consequentCode = this.factory.brace(consequentCode);
        }
        CodeRep result = this.seqVA(this.factory.token("if"), this.factory.paren(test), consequentCode, alternate.maybe(this.factory.empty(), s -> this.seqVA(this.factory.token("else"), (CodeRep)s)));
        result.endsWithMissingElse = alternate.maybe(true, s -> s.endsWithMissingElse);
        return result;
    }

    @Override
    @NotNull
    public CodeRep reduceLabeledStatement(@NotNull LabeledStatement node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep label, @NotNull CodeRep body) {
        CodeRep result = this.seqVA(label, this.factory.token(":"), body);
        result.endsWithMissingElse = body.endsWithMissingElse;
        return result;
    }

    @Override
    @NotNull
    public CodeRep reduceReturnStatement(@NotNull ReturnStatement node, @NotNull ImmutableList<Branch> path, @NotNull Maybe<CodeRep> expression) {
        return this.seqVA(this.factory.token("return"), this.seqVA(expression.orJust(this.factory.empty())), this.factory.semiOp());
    }

    @Override
    @NotNull
    public CodeRep reduceSwitchCase(@NotNull SwitchCase node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep test, @NotNull ImmutableList<CodeRep> consequent) {
        return this.seqVA(this.factory.token("case"), test, this.factory.token(":"), this.factory.seq(consequent));
    }

    @Override
    @NotNull
    public CodeRep reduceSwitchDefault(@NotNull SwitchDefault node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<CodeRep> consequent) {
        return this.seqVA(this.factory.token("default"), this.factory.token(":"), this.factory.seq(consequent));
    }

    @Override
    @NotNull
    public CodeRep reduceSwitchStatement(@NotNull SwitchStatement node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep discriminant, @NotNull ImmutableList<CodeRep> cases) {
        return this.seqVA(this.factory.token("switch"), this.factory.paren(discriminant), this.factory.brace(this.factory.seq(cases)));
    }

    @Override
    @NotNull
    public CodeRep reduceSwitchStatementWithDefault(@NotNull SwitchStatementWithDefault node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep discriminant, @NotNull ImmutableList<CodeRep> preDefaultCases, @NotNull CodeRep defaultCase, @NotNull ImmutableList<CodeRep> postDefaultCases) {
        return this.seqVA(this.factory.token("switch"), this.factory.paren(discriminant), this.factory.brace(this.seqVA(this.factory.seq(preDefaultCases), defaultCase, this.factory.seq(postDefaultCases))));
    }

    @Override
    @NotNull
    public CodeRep reduceThrowStatement(@NotNull ThrowStatement node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep expression) {
        return this.seqVA(this.factory.token("throw"), expression, this.factory.semiOp());
    }

    @Override
    @NotNull
    public CodeRep reduceTryCatchStatement(@NotNull TryCatchStatement node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep block, @NotNull CodeRep catchClause) {
        return this.seqVA(this.factory.token("try"), block, catchClause);
    }

    @Override
    @NotNull
    public CodeRep reduceTryFinallyStatement(@NotNull TryFinallyStatement node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep block, @NotNull Maybe<CodeRep> catchClause, @NotNull CodeRep finalizer) {
        return this.seqVA(this.factory.token("try"), block, catchClause.orJust(this.factory.empty()), this.seqVA(this.factory.token("finally"), finalizer));
    }

    @Override
    @NotNull
    public CodeRep reduceVariableDeclarationStatement(@NotNull VariableDeclarationStatement node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep declaration) {
        return this.seqVA(declaration, this.factory.semiOp());
    }

    @Override
    @NotNull
    public CodeRep reduceVariableDeclaration(@NotNull VariableDeclaration node, @NotNull ImmutableList<Branch> path, @NotNull NonEmptyImmutableList<CodeRep> declarators) {
        return this.seqVA(this.factory.token(node.kind.name), this.factory.commaSep(declarators));
    }

    @Override
    @NotNull
    public CodeRep reduceWhileStatement(@NotNull WhileStatement node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep test, @NotNull CodeRep body) {
        CodeRep result = this.seqVA(this.factory.token("while"), this.factory.paren(test), body);
        result.endsWithMissingElse = body.endsWithMissingElse;
        return result;
    }

    @Override
    @NotNull
    public CodeRep reduceWithStatement(@NotNull WithStatement node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep object, @NotNull CodeRep body) {
        CodeRep result = this.seqVA(this.factory.token("with"), this.factory.paren(object), body);
        result.endsWithMissingElse = body.endsWithMissingElse;
        return result;
    }

    @Override
    @NotNull
    public CodeRep reduceDataProperty(@NotNull DataProperty node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep name, @NotNull CodeRep value) {
        return this.seqVA(name, this.factory.token(":"), value.containsGroup ? this.factory.paren(value) : value);
    }

    @Override
    @NotNull
    public CodeRep reduceGetter(@NotNull Getter node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep name, @NotNull CodeRep body) {
        return this.seqVA(this.factory.token("get"), name, this.factory.paren(this.factory.empty()), this.factory.brace(body));
    }

    @Override
    @NotNull
    public CodeRep reduceSetter(@NotNull Setter node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep name, @NotNull CodeRep parameter, @NotNull CodeRep body) {
        return this.seqVA(this.factory.token("set"), name, this.factory.paren(parameter), this.factory.brace(body));
    }

    @Override
    @NotNull
    public CodeRep reducePropertyName(@NotNull PropertyName node, @NotNull ImmutableList<Branch> path) {
        if (node.kind == PropertyName.PropertyNameKind.Number) {
            if (node.value.equals("Infinity")) {
                return this.factory.token("2e308");
            }
            return this.factory.token(node.value);
        }
        if (node.kind == PropertyName.PropertyNameKind.Identifier) {
            return this.factory.token(node.value);
        }
        return this.factory.token(Utils.escapeStringLiteral(node.value));
    }

    @Override
    @NotNull
    public CodeRep reduceFunctionBody(@NotNull FunctionBody node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<CodeRep> directives, @NotNull ImmutableList<CodeRep> statements) {
        CodeRep body;
        if (statements.isEmpty()) {
            body = this.factory.empty();
        } else {
            NonEmptyImmutableList seNel = (NonEmptyImmutableList)statements;
            body = this.parenToAvoidBeingDirective((Node)((NonEmptyImmutableList)node.statements).head, (CodeRep)seNel.head);
            body = this.seqVA(body, this.factory.seq(seNel.tail()));
        }
        return this.seqVA(this.factory.seq(directives), body);
    }

    @Override
    @NotNull
    public CodeRep reduceVariableDeclarator(@NotNull VariableDeclarator node, @NotNull ImmutableList<Branch> path, @NotNull CodeRep binding, @NotNull Maybe<CodeRep> init) {
        CodeRep result = this.factory.init(binding, init.map(state -> state.containsGroup ? this.factory.paren((CodeRep)state) : this.factory.testIn((CodeRep)state)));
        result.containsIn = init.maybe(false, state -> state.containsIn && !state.containsGroup);
        return result;
    }

    @Override
    @NotNull
    public CodeRep reduceBlock(@NotNull Block node, @NotNull ImmutableList<Branch> path, @NotNull ImmutableList<CodeRep> statements) {
        return this.factory.brace(this.factory.seq(statements));
    }
}

