/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.ast.types;

import com.shapesecurity.shift.ast.types.EitherType;
import com.shapesecurity.shift.ast.types.GenType;
import com.shapesecurity.shift.ast.types.Type;
import org.jetbrains.annotations.NotNull;

public class MaybeType
implements GenType {
    public static final MaybeType EXPRESSION = new MaybeType(Type.Expression);
    public static final MaybeType STATEMENT = new MaybeType(Type.Statement);
    public static final MaybeType IDENTIFIER = new MaybeType(Type.Identifier);
    public static final MaybeType CATCHCLAUSE = new MaybeType(Type.CatchClause);
    public static final MaybeType VARIABLEDECLARATION_OR_EXPRESSION = new MaybeType(EitherType.VARIABLEDECLARATION_EXPRESSION);
    @NotNull
    public final GenType elementType;

    private MaybeType(@NotNull GenType elementType) {
        this.elementType = elementType;
    }

    @NotNull
    public static MaybeType from(@NotNull GenType elementType) {
        if (elementType == EitherType.VARIABLEDECLARATION_EXPRESSION) {
            return VARIABLEDECLARATION_OR_EXPRESSION;
        }
        if (elementType instanceof Type) {
            switch ((Type)elementType) {
                case Expression: {
                    return EXPRESSION;
                }
                case Statement: {
                    return STATEMENT;
                }
                case Identifier: {
                    return IDENTIFIER;
                }
                case CatchClause: {
                    return CATCHCLAUSE;
                }
            }
        }
        return new MaybeType(elementType);
    }

    @Override
    @NotNull
    public Type rawType() {
        return Type.Maybe;
    }

    @Override
    public boolean isAssignableFrom(@NotNull GenType type) {
        return type == this || type instanceof MaybeType && this.elementType.isAssignableFrom(((MaybeType)type).elementType);
    }
}

