/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.ast.types;

import com.shapesecurity.shift.ast.types.GenType;
import com.shapesecurity.shift.ast.types.MaybeType;
import com.shapesecurity.shift.ast.types.NonEmptyListType;
import com.shapesecurity.shift.ast.types.Type;
import org.jetbrains.annotations.NotNull;

public class ListType
implements GenType {
    public static final ListType EXPRESSION = new ListType(Type.Expression);
    public static final ListType MAYBE_EXPRESSION = new ListType(MaybeType.EXPRESSION);
    public static final ListType STATEMENT = new ListType(Type.Statement);
    public static final ListType IDENTIFIER = new ListType(Type.Identifier);
    public static final ListType CATCHCLAUSE = new ListType(Type.CatchClause);
    @NotNull
    public final GenType elementType;

    private ListType(@NotNull GenType elementType) {
        this.elementType = elementType;
    }

    @Override
    @NotNull
    public Type rawType() {
        return Type.List;
    }

    @Override
    public boolean isAssignableFrom(@NotNull GenType type) {
        return type == this || type instanceof ListType && this.elementType.isAssignableFrom(((ListType)type).elementType) || type instanceof NonEmptyListType && this.elementType.isAssignableFrom(((NonEmptyListType)type).elementType);
    }

    @NotNull
    public static ListType from(@NotNull GenType elementType) {
        switch (elementType.rawType()) {
            case Expression: {
                return EXPRESSION;
            }
            case Maybe: {
                if (((MaybeType)elementType).elementType == Type.Expression) {
                    return MAYBE_EXPRESSION;
                }
            }
            case Statement: {
                return STATEMENT;
            }
            case Identifier: {
                return IDENTIFIER;
            }
            case CatchClause: {
                return CATCHCLAUSE;
            }
        }
        return new ListType(elementType);
    }
}

