/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.ast.statement;

import com.shapesecurity.shift.ast.Identifier;
import com.shapesecurity.shift.ast.Statement;
import com.shapesecurity.shift.ast.types.Type;
import org.jetbrains.annotations.NotNull;

public class LabeledStatement
extends Statement {
    @NotNull
    public final Identifier label;
    @NotNull
    public final Statement body;

    public LabeledStatement(@NotNull Identifier label, @NotNull Statement body) {
        this.label = label;
        this.body = body;
    }

    @Override
    @NotNull
    public Type type() {
        return Type.LabeledStatement;
    }

    public boolean equals(Object object) {
        return object instanceof LabeledStatement && this.label.equals(((LabeledStatement)object).label) && this.body.equals(((LabeledStatement)object).body);
    }

    @NotNull
    public Identifier getLabel() {
        return this.label;
    }

    @NotNull
    public Statement getBody() {
        return this.body;
    }

    @NotNull
    public LabeledStatement setLabel(@NotNull Identifier label) {
        return new LabeledStatement(label, this.body);
    }

    @NotNull
    public LabeledStatement setBody(@NotNull Statement body) {
        return new LabeledStatement(this.label, body);
    }
}

