/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.ast.statement;

import com.shapesecurity.functional.data.Maybe;
import com.shapesecurity.shift.ast.Expression;
import com.shapesecurity.shift.ast.Statement;
import com.shapesecurity.shift.ast.types.Type;
import org.jetbrains.annotations.NotNull;

public class IfStatement
extends Statement {
    @NotNull
    public final Expression test;
    @NotNull
    public final Statement consequent;
    @NotNull
    public final Maybe<Statement> alternate;

    public IfStatement(@NotNull Expression test, @NotNull Statement consequent, @NotNull Maybe<Statement> alternate) {
        this.test = test;
        this.consequent = consequent;
        this.alternate = alternate;
    }

    public IfStatement(@NotNull Expression test, @NotNull Statement consequent, @NotNull Statement alternate) {
        this(test, consequent, Maybe.just(alternate));
    }

    public IfStatement(@NotNull Expression test, @NotNull Statement consequent) {
        this(test, consequent, Maybe.nothing());
    }

    @Override
    @NotNull
    public Type type() {
        return Type.IfStatement;
    }

    public boolean equals(Object object) {
        return object instanceof IfStatement && this.test.equals(((IfStatement)object).test) && this.consequent.equals(((IfStatement)object).consequent) && this.alternate.equals(((IfStatement)object).alternate);
    }

    @NotNull
    public Expression getTest() {
        return this.test;
    }

    @NotNull
    public Statement getConsequent() {
        return this.consequent;
    }

    @NotNull
    public Maybe<Statement> getAlternate() {
        return this.alternate;
    }

    @NotNull
    public IfStatement setTest(@NotNull Expression test) {
        return new IfStatement(test, this.consequent, this.alternate);
    }

    @NotNull
    public IfStatement setConsequent(@NotNull Statement consequent) {
        return new IfStatement(this.test, consequent, this.alternate);
    }

    @NotNull
    public IfStatement setAlternate(@NotNull Maybe<Statement> alternate) {
        return new IfStatement(this.test, this.consequent, alternate);
    }
}

