/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.ast.statement;

import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.shift.ast.Function;
import com.shapesecurity.shift.ast.FunctionBody;
import com.shapesecurity.shift.ast.Identifier;
import com.shapesecurity.shift.ast.Statement;
import com.shapesecurity.shift.ast.types.Type;
import org.jetbrains.annotations.NotNull;

public class FunctionDeclaration
extends Statement
implements Function {
    @NotNull
    public final Identifier name;
    @NotNull
    public final ImmutableList<Identifier> parameters;
    @NotNull
    public final FunctionBody body;

    public FunctionDeclaration(@NotNull Identifier name, @NotNull ImmutableList<Identifier> parameters, @NotNull FunctionBody body) {
        this.name = name;
        this.parameters = parameters;
        this.body = body;
    }

    @Override
    @NotNull
    public Type type() {
        return Type.FunctionDeclaration;
    }

    public boolean equals(Object object) {
        return object instanceof FunctionDeclaration && this.name.equals(((FunctionDeclaration)object).name) && this.parameters.equals(((FunctionDeclaration)object).parameters) && this.body.equals(((FunctionDeclaration)object).body);
    }

    @Override
    @NotNull
    public ImmutableList<Identifier> parameters() {
        return this.parameters;
    }

    @NotNull
    public Identifier getName() {
        return this.name;
    }

    @NotNull
    public ImmutableList<Identifier> getParameters() {
        return this.parameters;
    }

    @NotNull
    public FunctionBody getBody() {
        return this.body;
    }

    @NotNull
    public FunctionDeclaration setName(@NotNull Identifier name) {
        return new FunctionDeclaration(name, this.parameters, this.body);
    }

    @NotNull
    public FunctionDeclaration setParameters(@NotNull ImmutableList<Identifier> parameters) {
        return new FunctionDeclaration(this.name, parameters, this.body);
    }

    @NotNull
    public FunctionDeclaration setBody(@NotNull FunctionBody body) {
        return new FunctionDeclaration(this.name, this.parameters, body);
    }
}

