/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.ast.property;

import com.shapesecurity.shift.ast.Identifier;
import com.shapesecurity.shift.ast.Node;
import com.shapesecurity.shift.ast.types.Type;
import com.shapesecurity.shift.utils.D2A;
import org.jetbrains.annotations.NotNull;

public final class PropertyName
extends Node {
    @NotNull
    public final String value;
    public final PropertyNameKind kind;

    private PropertyName(@NotNull String value, @NotNull PropertyNameKind kind) {
        this.value = value;
        this.kind = kind;
    }

    public PropertyName(@NotNull PropertyName node) {
        this(node.value, node.kind);
    }

    public PropertyName(@NotNull Identifier ident) {
        this(ident.name, PropertyNameKind.Identifier);
    }

    public PropertyName(@NotNull String str) {
        this(str, PropertyNameKind.String);
    }

    public PropertyName(double d) {
        this(D2A.d2a(d), PropertyNameKind.Number);
    }

    @Override
    @NotNull
    public Type type() {
        return Type.PropertyName;
    }

    public boolean equals(Object object) {
        return object instanceof PropertyName && this.kind.equals((Object)((PropertyName)object).kind) && this.value.equals(((PropertyName)object).value);
    }

    public static enum PropertyNameKind {
        Identifier("identifier"),
        String("string"),
        Number("number");

        @NotNull
        public final String name;

        private PropertyNameKind(String name) {
            this.name = name;
        }
    }
}

