/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.shift.ast.property;

import com.shapesecurity.shift.ast.Expression;
import com.shapesecurity.shift.ast.property.ObjectProperty;
import com.shapesecurity.shift.ast.property.PropertyName;
import com.shapesecurity.shift.ast.types.Type;
import org.jetbrains.annotations.NotNull;

public class DataProperty
extends ObjectProperty {
    @NotNull
    public final Expression value;

    public DataProperty(@NotNull PropertyName name, @NotNull Expression value) {
        super(name);
        this.value = value;
    }

    @Override
    @NotNull
    public ObjectProperty.ObjectPropertyKind getKind() {
        return ObjectProperty.ObjectPropertyKind.InitProperty;
    }

    @Override
    @NotNull
    public Type type() {
        return Type.DataProperty;
    }

    public boolean equals(Object object) {
        return object instanceof DataProperty && this.name.equals(((DataProperty)object).name) && this.value.equals(((DataProperty)object).value);
    }

    @NotNull
    public Expression getValue() {
        return this.value;
    }

    @NotNull
    public DataProperty setName(@NotNull PropertyName name) {
        return new DataProperty(name, this.value);
    }

    @NotNull
    public DataProperty setValue(@NotNull Expression value) {
        return new DataProperty(this.name, value);
    }
}

